package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Cesp;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing Cesp in entity cache.
 *
 * @author caret
 * @see Cesp
 * @generated
 */
public class CespCacheModel implements CacheModel<Cesp>, Externalizable {
    public long cespId;
    public long callId;
    public long createdByPersnId;
    public long creationDate;
    public String step;
    public String status;
    public String referredBy;
    public String assignedCslPersnId;
    public String goals;
    public String planProgressBarrier;
    public String cespClosed;
    public String cespClosedReason;
    public String goalsReached;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(27);

        sb.append("{cespId=");
        sb.append(cespId);
        sb.append(", callId=");
        sb.append(callId);
        sb.append(", createdByPersnId=");
        sb.append(createdByPersnId);
        sb.append(", creationDate=");
        sb.append(creationDate);
        sb.append(", step=");
        sb.append(step);
        sb.append(", status=");
        sb.append(status);
        sb.append(", referredBy=");
        sb.append(referredBy);
        sb.append(", assignedCslPersnId=");
        sb.append(assignedCslPersnId);
        sb.append(", goals=");
        sb.append(goals);
        sb.append(", planProgressBarrier=");
        sb.append(planProgressBarrier);
        sb.append(", cespClosed=");
        sb.append(cespClosed);
        sb.append(", cespClosedReason=");
        sb.append(cespClosedReason);
        sb.append(", goalsReached=");
        sb.append(goalsReached);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Cesp toEntityModel() {
        CespImpl cespImpl = new CespImpl();

        cespImpl.setCespId(cespId);
        cespImpl.setCallId(callId);
        cespImpl.setCreatedByPersnId(createdByPersnId);

        if (creationDate == Long.MIN_VALUE) {
            cespImpl.setCreationDate(null);
        } else {
            cespImpl.setCreationDate(new Date(creationDate));
        }

        if (step == null) {
            cespImpl.setStep(StringPool.BLANK);
        } else {
            cespImpl.setStep(step);
        }

        if (status == null) {
            cespImpl.setStatus(StringPool.BLANK);
        } else {
            cespImpl.setStatus(status);
        }

        if (referredBy == null) {
            cespImpl.setReferredBy(StringPool.BLANK);
        } else {
            cespImpl.setReferredBy(referredBy);
        }

        if (assignedCslPersnId == null) {
            cespImpl.setAssignedCslPersnId(StringPool.BLANK);
        } else {
            cespImpl.setAssignedCslPersnId(assignedCslPersnId);
        }

        if (goals == null) {
            cespImpl.setGoals(StringPool.BLANK);
        } else {
            cespImpl.setGoals(goals);
        }

        if (planProgressBarrier == null) {
            cespImpl.setPlanProgressBarrier(StringPool.BLANK);
        } else {
            cespImpl.setPlanProgressBarrier(planProgressBarrier);
        }

        if (cespClosed == null) {
            cespImpl.setCespClosed(StringPool.BLANK);
        } else {
            cespImpl.setCespClosed(cespClosed);
        }

        if (cespClosedReason == null) {
            cespImpl.setCespClosedReason(StringPool.BLANK);
        } else {
            cespImpl.setCespClosedReason(cespClosedReason);
        }

        if (goalsReached == null) {
            cespImpl.setGoalsReached(StringPool.BLANK);
        } else {
            cespImpl.setGoalsReached(goalsReached);
        }

        cespImpl.resetOriginalValues();

        return cespImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        cespId = objectInput.readLong();
        callId = objectInput.readLong();
        createdByPersnId = objectInput.readLong();
        creationDate = objectInput.readLong();
        step = objectInput.readUTF();
        status = objectInput.readUTF();
        referredBy = objectInput.readUTF();
        assignedCslPersnId = objectInput.readUTF();
        goals = objectInput.readUTF();
        planProgressBarrier = objectInput.readUTF();
        cespClosed = objectInput.readUTF();
        cespClosedReason = objectInput.readUTF();
        goalsReached = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(cespId);
        objectOutput.writeLong(callId);
        objectOutput.writeLong(createdByPersnId);
        objectOutput.writeLong(creationDate);

        if (step == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(step);
        }

        if (status == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(status);
        }

        if (referredBy == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(referredBy);
        }

        if (assignedCslPersnId == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(assignedCslPersnId);
        }

        if (goals == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(goals);
        }

        if (planProgressBarrier == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(planProgressBarrier);
        }

        if (cespClosed == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(cespClosed);
        }

        if (cespClosedReason == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(cespClosedReason);
        }

        if (goalsReached == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(goalsReached);
        }
    }
}
