package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Call;
import gov.va.caret.model.CallModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Call service. Represents a row in the &quot;CARET_CALL&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.CallModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CallImpl}.
 * </p>
 *
 * @author caret
 * @see CallImpl
 * @see gov.va.caret.model.Call
 * @see gov.va.caret.model.CallModel
 * @generated
 */
public class CallModelImpl extends BaseModelImpl<Call> implements CallModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a call model instance should use the {@link gov.va.caret.model.Call} interface instead.
     */
    public static final String TABLE_NAME = "CARET_CALL";
    public static final Object[][] TABLE_COLUMNS = {
            { "callId", Types.BIGINT },
            { "callType", Types.VARCHAR },
            { "callerRelationship", Types.VARCHAR },
            { "workPrimaryKey", Types.BIGINT },
            { "callState", Types.VARCHAR },
            { "callerPersnId", Types.BIGINT },
            { "callerTitle", Types.VARCHAR },
            { "callerLearnAbout", Types.VARCHAR },
            { "veteranPersnId", Types.BIGINT },
            { "message", Types.VARCHAR },
            { "summary", Types.VARCHAR },
            { "transferRemarks", Types.VARCHAR },
            { "cespGoal", Types.VARCHAR },
            { "cespOutcome", Types.VARCHAR },
            { "transferredTo", Types.VARCHAR },
            { "otherBenefits", Types.VARCHAR },
            { "contactInfo", Types.VARCHAR },
            { "eraService", Types.VARCHAR },
            { "serviceBranch", Types.VARCHAR },
            { "serviceStatus", Types.VARCHAR },
            { "contactInfoProvided", Types.BOOLEAN },
            { "referralAgreeable", Types.BOOLEAN },
            { "withoutContact", Types.BOOLEAN },
            { "hangUp", Types.BOOLEAN },
            { "wrongNumber", Types.BOOLEAN },
            { "sameAddress", Types.BOOLEAN },
            { "enrolled", Types.BOOLEAN },
            { "dutyDischargeAfter911", Types.BOOLEAN },
            { "scCondition", Types.BOOLEAN },
            { "pcafcQaulified", Types.BOOLEAN },
            { "verified", Types.BOOLEAN },
            { "anonymous", Types.BOOLEAN },
            { "createGroupId", Types.BIGINT },
            { "userId", Types.BIGINT },
            { "creationDate", Types.TIMESTAMP },
            { "callbackPref", Types.VARCHAR }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_CALL (callId LONG not null primary key,callType VARCHAR(75) null,callerRelationship VARCHAR(75) null,workPrimaryKey LONG,callState VARCHAR(75) null,callerPersnId LONG,callerTitle VARCHAR(75) null,callerLearnAbout VARCHAR(75) null,veteranPersnId LONG,message VARCHAR(75) null,summary VARCHAR(75) null,transferRemarks VARCHAR(75) null,cespGoal VARCHAR(75) null,cespOutcome VARCHAR(75) null,transferredTo VARCHAR(75) null,otherBenefits VARCHAR(75) null,contactInfo VARCHAR(75) null,eraService VARCHAR(75) null,serviceBranch VARCHAR(75) null,serviceStatus VARCHAR(75) null,contactInfoProvided BOOLEAN,referralAgreeable BOOLEAN,withoutContact BOOLEAN,hangUp BOOLEAN,wrongNumber BOOLEAN,sameAddress BOOLEAN,enrolled BOOLEAN,dutyDischargeAfter911 BOOLEAN,scCondition BOOLEAN,pcafcQaulified BOOLEAN,verified BOOLEAN,anonymous BOOLEAN,createGroupId LONG,userId LONG,creationDate DATE null,callbackPref VARCHAR(75) null)";
    public static final String TABLE_SQL_DROP = "drop table CARET_CALL";
    public static final String ORDER_BY_JPQL = " ORDER BY call.creationDate ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_CALL.creationDate ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Call"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Call"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.Call"),
            true);
    public static long CALLERPERSNID_COLUMN_BITMASK = 1L;
    public static long CREATEGROUPID_COLUMN_BITMASK = 2L;
    public static long USERID_COLUMN_BITMASK = 4L;
    public static long VETERANPERSNID_COLUMN_BITMASK = 8L;
    public static long CREATIONDATE_COLUMN_BITMASK = 16L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Call"));
    private static ClassLoader _classLoader = Call.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Call.class };
    private long _callId;
    private String _callType;
    private String _callerRelationship;
    private long _workPrimaryKey;
    private String _callState;
    private long _callerPersnId;
    private long _originalCallerPersnId;
    private boolean _setOriginalCallerPersnId;
    private String _callerTitle;
    private String _callerLearnAbout;
    private long _veteranPersnId;
    private long _originalVeteranPersnId;
    private boolean _setOriginalVeteranPersnId;
    private String _message;
    private String _summary;
    private String _transferRemarks;
    private String _cespGoal;
    private String _cespOutcome;
    private String _transferredTo;
    private String _otherBenefits;
    private String _contactInfo;
    private String _eraService;
    private String _serviceBranch;
    private String _serviceStatus;
    private boolean _contactInfoProvided;
    private boolean _referralAgreeable;
    private boolean _withoutContact;
    private boolean _hangUp;
    private boolean _wrongNumber;
    private boolean _sameAddress;
    private boolean _enrolled;
    private boolean _dutyDischargeAfter911;
    private boolean _scCondition;
    private boolean _pcafcQaulified;
    private boolean _verified;
    private boolean _anonymous;
    private long _createGroupId;
    private long _originalCreateGroupId;
    private boolean _setOriginalCreateGroupId;
    private long _userId;
    private String _userUuid;
    private long _originalUserId;
    private boolean _setOriginalUserId;
    private Date _creationDate;
    private String _callbackPref;
    private long _columnBitmask;
    private Call _escapedModel;

    public CallModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _callId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setCallId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _callId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Call.class;
    }

    @Override
    public String getModelClassName() {
        return Call.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("callId", getCallId());
        attributes.put("callType", getCallType());
        attributes.put("callerRelationship", getCallerRelationship());
        attributes.put("workPrimaryKey", getWorkPrimaryKey());
        attributes.put("callState", getCallState());
        attributes.put("callerPersnId", getCallerPersnId());
        attributes.put("callerTitle", getCallerTitle());
        attributes.put("callerLearnAbout", getCallerLearnAbout());
        attributes.put("veteranPersnId", getVeteranPersnId());
        attributes.put("message", getMessage());
        attributes.put("summary", getSummary());
        attributes.put("transferRemarks", getTransferRemarks());
        attributes.put("cespGoal", getCespGoal());
        attributes.put("cespOutcome", getCespOutcome());
        attributes.put("transferredTo", getTransferredTo());
        attributes.put("otherBenefits", getOtherBenefits());
        attributes.put("contactInfo", getContactInfo());
        attributes.put("eraService", getEraService());
        attributes.put("serviceBranch", getServiceBranch());
        attributes.put("serviceStatus", getServiceStatus());
        attributes.put("contactInfoProvided", getContactInfoProvided());
        attributes.put("referralAgreeable", getReferralAgreeable());
        attributes.put("withoutContact", getWithoutContact());
        attributes.put("hangUp", getHangUp());
        attributes.put("wrongNumber", getWrongNumber());
        attributes.put("sameAddress", getSameAddress());
        attributes.put("enrolled", getEnrolled());
        attributes.put("dutyDischargeAfter911", getDutyDischargeAfter911());
        attributes.put("scCondition", getScCondition());
        attributes.put("pcafcQaulified", getPcafcQaulified());
        attributes.put("verified", getVerified());
        attributes.put("anonymous", getAnonymous());
        attributes.put("createGroupId", getCreateGroupId());
        attributes.put("userId", getUserId());
        attributes.put("creationDate", getCreationDate());
        attributes.put("callbackPref", getCallbackPref());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        String callType = (String) attributes.get("callType");

        if (callType != null) {
            setCallType(callType);
        }

        String callerRelationship = (String) attributes.get(
                "callerRelationship");

        if (callerRelationship != null) {
            setCallerRelationship(callerRelationship);
        }

        Long workPrimaryKey = (Long) attributes.get("workPrimaryKey");

        if (workPrimaryKey != null) {
            setWorkPrimaryKey(workPrimaryKey);
        }

        String callState = (String) attributes.get("callState");

        if (callState != null) {
            setCallState(callState);
        }

        Long callerPersnId = (Long) attributes.get("callerPersnId");

        if (callerPersnId != null) {
            setCallerPersnId(callerPersnId);
        }

        String callerTitle = (String) attributes.get("callerTitle");

        if (callerTitle != null) {
            setCallerTitle(callerTitle);
        }

        String callerLearnAbout = (String) attributes.get("callerLearnAbout");

        if (callerLearnAbout != null) {
            setCallerLearnAbout(callerLearnAbout);
        }

        Long veteranPersnId = (Long) attributes.get("veteranPersnId");

        if (veteranPersnId != null) {
            setVeteranPersnId(veteranPersnId);
        }

        String message = (String) attributes.get("message");

        if (message != null) {
            setMessage(message);
        }

        String summary = (String) attributes.get("summary");

        if (summary != null) {
            setSummary(summary);
        }

        String transferRemarks = (String) attributes.get("transferRemarks");

        if (transferRemarks != null) {
            setTransferRemarks(transferRemarks);
        }

        String cespGoal = (String) attributes.get("cespGoal");

        if (cespGoal != null) {
            setCespGoal(cespGoal);
        }

        String cespOutcome = (String) attributes.get("cespOutcome");

        if (cespOutcome != null) {
            setCespOutcome(cespOutcome);
        }

        String transferredTo = (String) attributes.get("transferredTo");

        if (transferredTo != null) {
            setTransferredTo(transferredTo);
        }

        String otherBenefits = (String) attributes.get("otherBenefits");

        if (otherBenefits != null) {
            setOtherBenefits(otherBenefits);
        }

        String contactInfo = (String) attributes.get("contactInfo");

        if (contactInfo != null) {
            setContactInfo(contactInfo);
        }

        String eraService = (String) attributes.get("eraService");

        if (eraService != null) {
            setEraService(eraService);
        }

        String serviceBranch = (String) attributes.get("serviceBranch");

        if (serviceBranch != null) {
            setServiceBranch(serviceBranch);
        }

        String serviceStatus = (String) attributes.get("serviceStatus");

        if (serviceStatus != null) {
            setServiceStatus(serviceStatus);
        }

        Boolean contactInfoProvided = (Boolean) attributes.get(
                "contactInfoProvided");

        if (contactInfoProvided != null) {
            setContactInfoProvided(contactInfoProvided);
        }

        Boolean referralAgreeable = (Boolean) attributes.get(
                "referralAgreeable");

        if (referralAgreeable != null) {
            setReferralAgreeable(referralAgreeable);
        }

        Boolean withoutContact = (Boolean) attributes.get("withoutContact");

        if (withoutContact != null) {
            setWithoutContact(withoutContact);
        }

        Boolean hangUp = (Boolean) attributes.get("hangUp");

        if (hangUp != null) {
            setHangUp(hangUp);
        }

        Boolean wrongNumber = (Boolean) attributes.get("wrongNumber");

        if (wrongNumber != null) {
            setWrongNumber(wrongNumber);
        }

        Boolean sameAddress = (Boolean) attributes.get("sameAddress");

        if (sameAddress != null) {
            setSameAddress(sameAddress);
        }

        Boolean enrolled = (Boolean) attributes.get("enrolled");

        if (enrolled != null) {
            setEnrolled(enrolled);
        }

        Boolean dutyDischargeAfter911 = (Boolean) attributes.get(
                "dutyDischargeAfter911");

        if (dutyDischargeAfter911 != null) {
            setDutyDischargeAfter911(dutyDischargeAfter911);
        }

        Boolean scCondition = (Boolean) attributes.get("scCondition");

        if (scCondition != null) {
            setScCondition(scCondition);
        }

        Boolean pcafcQaulified = (Boolean) attributes.get("pcafcQaulified");

        if (pcafcQaulified != null) {
            setPcafcQaulified(pcafcQaulified);
        }

        Boolean verified = (Boolean) attributes.get("verified");

        if (verified != null) {
            setVerified(verified);
        }

        Boolean anonymous = (Boolean) attributes.get("anonymous");

        if (anonymous != null) {
            setAnonymous(anonymous);
        }

        Long createGroupId = (Long) attributes.get("createGroupId");

        if (createGroupId != null) {
            setCreateGroupId(createGroupId);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        String callbackPref = (String) attributes.get("callbackPref");

        if (callbackPref != null) {
            setCallbackPref(callbackPref);
        }
    }

    @Override
    public long getCallId() {
        return _callId;
    }

    @Override
    public void setCallId(long callId) {
        _callId = callId;
    }

    @Override
    public String getCallType() {
        if (_callType == null) {
            return StringPool.BLANK;
        } else {
            return _callType;
        }
    }

    @Override
    public void setCallType(String callType) {
        _callType = callType;
    }

    @Override
    public String getCallerRelationship() {
        if (_callerRelationship == null) {
            return StringPool.BLANK;
        } else {
            return _callerRelationship;
        }
    }

    @Override
    public void setCallerRelationship(String callerRelationship) {
        _callerRelationship = callerRelationship;
    }

    @Override
    public long getWorkPrimaryKey() {
        return _workPrimaryKey;
    }

    @Override
    public void setWorkPrimaryKey(long workPrimaryKey) {
        _workPrimaryKey = workPrimaryKey;
    }

    @Override
    public String getCallState() {
        if (_callState == null) {
            return StringPool.BLANK;
        } else {
            return _callState;
        }
    }

    @Override
    public void setCallState(String callState) {
        _callState = callState;
    }

    @Override
    public long getCallerPersnId() {
        return _callerPersnId;
    }

    @Override
    public void setCallerPersnId(long callerPersnId) {
        _columnBitmask |= CALLERPERSNID_COLUMN_BITMASK;

        if (!_setOriginalCallerPersnId) {
            _setOriginalCallerPersnId = true;

            _originalCallerPersnId = _callerPersnId;
        }

        _callerPersnId = callerPersnId;
    }

    public long getOriginalCallerPersnId() {
        return _originalCallerPersnId;
    }

    @Override
    public String getCallerTitle() {
        if (_callerTitle == null) {
            return StringPool.BLANK;
        } else {
            return _callerTitle;
        }
    }

    @Override
    public void setCallerTitle(String callerTitle) {
        _callerTitle = callerTitle;
    }

    @Override
    public String getCallerLearnAbout() {
        if (_callerLearnAbout == null) {
            return StringPool.BLANK;
        } else {
            return _callerLearnAbout;
        }
    }

    @Override
    public void setCallerLearnAbout(String callerLearnAbout) {
        _callerLearnAbout = callerLearnAbout;
    }

    @Override
    public long getVeteranPersnId() {
        return _veteranPersnId;
    }

    @Override
    public void setVeteranPersnId(long veteranPersnId) {
        _columnBitmask |= VETERANPERSNID_COLUMN_BITMASK;

        if (!_setOriginalVeteranPersnId) {
            _setOriginalVeteranPersnId = true;

            _originalVeteranPersnId = _veteranPersnId;
        }

        _veteranPersnId = veteranPersnId;
    }

    public long getOriginalVeteranPersnId() {
        return _originalVeteranPersnId;
    }

    @Override
    public String getMessage() {
        if (_message == null) {
            return StringPool.BLANK;
        } else {
            return _message;
        }
    }

    @Override
    public void setMessage(String message) {
        _message = message;
    }

    @Override
    public String getSummary() {
        if (_summary == null) {
            return StringPool.BLANK;
        } else {
            return _summary;
        }
    }

    @Override
    public void setSummary(String summary) {
        _summary = summary;
    }

    @Override
    public String getTransferRemarks() {
        if (_transferRemarks == null) {
            return StringPool.BLANK;
        } else {
            return _transferRemarks;
        }
    }

    @Override
    public void setTransferRemarks(String transferRemarks) {
        _transferRemarks = transferRemarks;
    }

    @Override
    public String getCespGoal() {
        if (_cespGoal == null) {
            return StringPool.BLANK;
        } else {
            return _cespGoal;
        }
    }

    @Override
    public void setCespGoal(String cespGoal) {
        _cespGoal = cespGoal;
    }

    @Override
    public String getCespOutcome() {
        if (_cespOutcome == null) {
            return StringPool.BLANK;
        } else {
            return _cespOutcome;
        }
    }

    @Override
    public void setCespOutcome(String cespOutcome) {
        _cespOutcome = cespOutcome;
    }

    @Override
    public String getTransferredTo() {
        if (_transferredTo == null) {
            return StringPool.BLANK;
        } else {
            return _transferredTo;
        }
    }

    @Override
    public void setTransferredTo(String transferredTo) {
        _transferredTo = transferredTo;
    }

    @Override
    public String getOtherBenefits() {
        if (_otherBenefits == null) {
            return StringPool.BLANK;
        } else {
            return _otherBenefits;
        }
    }

    @Override
    public void setOtherBenefits(String otherBenefits) {
        _otherBenefits = otherBenefits;
    }

    @Override
    public String getContactInfo() {
        if (_contactInfo == null) {
            return StringPool.BLANK;
        } else {
            return _contactInfo;
        }
    }

    @Override
    public void setContactInfo(String contactInfo) {
        _contactInfo = contactInfo;
    }

    @Override
    public String getEraService() {
        if (_eraService == null) {
            return StringPool.BLANK;
        } else {
            return _eraService;
        }
    }

    @Override
    public void setEraService(String eraService) {
        _eraService = eraService;
    }

    @Override
    public String getServiceBranch() {
        if (_serviceBranch == null) {
            return StringPool.BLANK;
        } else {
            return _serviceBranch;
        }
    }

    @Override
    public void setServiceBranch(String serviceBranch) {
        _serviceBranch = serviceBranch;
    }

    @Override
    public String getServiceStatus() {
        if (_serviceStatus == null) {
            return StringPool.BLANK;
        } else {
            return _serviceStatus;
        }
    }

    @Override
    public void setServiceStatus(String serviceStatus) {
        _serviceStatus = serviceStatus;
    }

    @Override
    public boolean getContactInfoProvided() {
        return _contactInfoProvided;
    }

    @Override
    public boolean isContactInfoProvided() {
        return _contactInfoProvided;
    }

    @Override
    public void setContactInfoProvided(boolean contactInfoProvided) {
        _contactInfoProvided = contactInfoProvided;
    }

    @Override
    public boolean getReferralAgreeable() {
        return _referralAgreeable;
    }

    @Override
    public boolean isReferralAgreeable() {
        return _referralAgreeable;
    }

    @Override
    public void setReferralAgreeable(boolean referralAgreeable) {
        _referralAgreeable = referralAgreeable;
    }

    @Override
    public boolean getWithoutContact() {
        return _withoutContact;
    }

    @Override
    public boolean isWithoutContact() {
        return _withoutContact;
    }

    @Override
    public void setWithoutContact(boolean withoutContact) {
        _withoutContact = withoutContact;
    }

    @Override
    public boolean getHangUp() {
        return _hangUp;
    }

    @Override
    public boolean isHangUp() {
        return _hangUp;
    }

    @Override
    public void setHangUp(boolean hangUp) {
        _hangUp = hangUp;
    }

    @Override
    public boolean getWrongNumber() {
        return _wrongNumber;
    }

    @Override
    public boolean isWrongNumber() {
        return _wrongNumber;
    }

    @Override
    public void setWrongNumber(boolean wrongNumber) {
        _wrongNumber = wrongNumber;
    }

    @Override
    public boolean getSameAddress() {
        return _sameAddress;
    }

    @Override
    public boolean isSameAddress() {
        return _sameAddress;
    }

    @Override
    public void setSameAddress(boolean sameAddress) {
        _sameAddress = sameAddress;
    }

    @Override
    public boolean getEnrolled() {
        return _enrolled;
    }

    @Override
    public boolean isEnrolled() {
        return _enrolled;
    }

    @Override
    public void setEnrolled(boolean enrolled) {
        _enrolled = enrolled;
    }

    @Override
    public boolean getDutyDischargeAfter911() {
        return _dutyDischargeAfter911;
    }

    @Override
    public boolean isDutyDischargeAfter911() {
        return _dutyDischargeAfter911;
    }

    @Override
    public void setDutyDischargeAfter911(boolean dutyDischargeAfter911) {
        _dutyDischargeAfter911 = dutyDischargeAfter911;
    }

    @Override
    public boolean getScCondition() {
        return _scCondition;
    }

    @Override
    public boolean isScCondition() {
        return _scCondition;
    }

    @Override
    public void setScCondition(boolean scCondition) {
        _scCondition = scCondition;
    }

    @Override
    public boolean getPcafcQaulified() {
        return _pcafcQaulified;
    }

    @Override
    public boolean isPcafcQaulified() {
        return _pcafcQaulified;
    }

    @Override
    public void setPcafcQaulified(boolean pcafcQaulified) {
        _pcafcQaulified = pcafcQaulified;
    }

    @Override
    public boolean getVerified() {
        return _verified;
    }

    @Override
    public boolean isVerified() {
        return _verified;
    }

    @Override
    public void setVerified(boolean verified) {
        _verified = verified;
    }

    @Override
    public boolean getAnonymous() {
        return _anonymous;
    }

    @Override
    public boolean isAnonymous() {
        return _anonymous;
    }

    @Override
    public void setAnonymous(boolean anonymous) {
        _anonymous = anonymous;
    }

    @Override
    public long getCreateGroupId() {
        return _createGroupId;
    }

    @Override
    public void setCreateGroupId(long createGroupId) {
        _columnBitmask |= CREATEGROUPID_COLUMN_BITMASK;

        if (!_setOriginalCreateGroupId) {
            _setOriginalCreateGroupId = true;

            _originalCreateGroupId = _createGroupId;
        }

        _createGroupId = createGroupId;
    }

    public long getOriginalCreateGroupId() {
        return _originalCreateGroupId;
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _columnBitmask |= USERID_COLUMN_BITMASK;

        if (!_setOriginalUserId) {
            _setOriginalUserId = true;

            _originalUserId = _userId;
        }

        _userId = userId;
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    public long getOriginalUserId() {
        return _originalUserId;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _columnBitmask = -1L;

        _creationDate = creationDate;
    }

    @Override
    public String getCallbackPref() {
        if (_callbackPref == null) {
            return StringPool.BLANK;
        } else {
            return _callbackPref;
        }
    }

    @Override
    public void setCallbackPref(String callbackPref) {
        _callbackPref = callbackPref;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Call.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Call toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Call) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        CallImpl callImpl = new CallImpl();

        callImpl.setCallId(getCallId());
        callImpl.setCallType(getCallType());
        callImpl.setCallerRelationship(getCallerRelationship());
        callImpl.setWorkPrimaryKey(getWorkPrimaryKey());
        callImpl.setCallState(getCallState());
        callImpl.setCallerPersnId(getCallerPersnId());
        callImpl.setCallerTitle(getCallerTitle());
        callImpl.setCallerLearnAbout(getCallerLearnAbout());
        callImpl.setVeteranPersnId(getVeteranPersnId());
        callImpl.setMessage(getMessage());
        callImpl.setSummary(getSummary());
        callImpl.setTransferRemarks(getTransferRemarks());
        callImpl.setCespGoal(getCespGoal());
        callImpl.setCespOutcome(getCespOutcome());
        callImpl.setTransferredTo(getTransferredTo());
        callImpl.setOtherBenefits(getOtherBenefits());
        callImpl.setContactInfo(getContactInfo());
        callImpl.setEraService(getEraService());
        callImpl.setServiceBranch(getServiceBranch());
        callImpl.setServiceStatus(getServiceStatus());
        callImpl.setContactInfoProvided(getContactInfoProvided());
        callImpl.setReferralAgreeable(getReferralAgreeable());
        callImpl.setWithoutContact(getWithoutContact());
        callImpl.setHangUp(getHangUp());
        callImpl.setWrongNumber(getWrongNumber());
        callImpl.setSameAddress(getSameAddress());
        callImpl.setEnrolled(getEnrolled());
        callImpl.setDutyDischargeAfter911(getDutyDischargeAfter911());
        callImpl.setScCondition(getScCondition());
        callImpl.setPcafcQaulified(getPcafcQaulified());
        callImpl.setVerified(getVerified());
        callImpl.setAnonymous(getAnonymous());
        callImpl.setCreateGroupId(getCreateGroupId());
        callImpl.setUserId(getUserId());
        callImpl.setCreationDate(getCreationDate());
        callImpl.setCallbackPref(getCallbackPref());

        callImpl.resetOriginalValues();

        return callImpl;
    }

    @Override
    public int compareTo(Call call) {
        int value = 0;

        value = DateUtil.compareTo(getCreationDate(), call.getCreationDate());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Call)) {
            return false;
        }

        Call call = (Call) obj;

        long primaryKey = call.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        CallModelImpl callModelImpl = this;

        callModelImpl._originalCallerPersnId = callModelImpl._callerPersnId;

        callModelImpl._setOriginalCallerPersnId = false;

        callModelImpl._originalVeteranPersnId = callModelImpl._veteranPersnId;

        callModelImpl._setOriginalVeteranPersnId = false;

        callModelImpl._originalCreateGroupId = callModelImpl._createGroupId;

        callModelImpl._setOriginalCreateGroupId = false;

        callModelImpl._originalUserId = callModelImpl._userId;

        callModelImpl._setOriginalUserId = false;

        callModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<Call> toCacheModel() {
        CallCacheModel callCacheModel = new CallCacheModel();

        callCacheModel.callId = getCallId();

        callCacheModel.callType = getCallType();

        String callType = callCacheModel.callType;

        if ((callType != null) && (callType.length() == 0)) {
            callCacheModel.callType = null;
        }

        callCacheModel.callerRelationship = getCallerRelationship();

        String callerRelationship = callCacheModel.callerRelationship;

        if ((callerRelationship != null) && (callerRelationship.length() == 0)) {
            callCacheModel.callerRelationship = null;
        }

        callCacheModel.workPrimaryKey = getWorkPrimaryKey();

        callCacheModel.callState = getCallState();

        String callState = callCacheModel.callState;

        if ((callState != null) && (callState.length() == 0)) {
            callCacheModel.callState = null;
        }

        callCacheModel.callerPersnId = getCallerPersnId();

        callCacheModel.callerTitle = getCallerTitle();

        String callerTitle = callCacheModel.callerTitle;

        if ((callerTitle != null) && (callerTitle.length() == 0)) {
            callCacheModel.callerTitle = null;
        }

        callCacheModel.callerLearnAbout = getCallerLearnAbout();

        String callerLearnAbout = callCacheModel.callerLearnAbout;

        if ((callerLearnAbout != null) && (callerLearnAbout.length() == 0)) {
            callCacheModel.callerLearnAbout = null;
        }

        callCacheModel.veteranPersnId = getVeteranPersnId();

        callCacheModel.message = getMessage();

        String message = callCacheModel.message;

        if ((message != null) && (message.length() == 0)) {
            callCacheModel.message = null;
        }

        callCacheModel.summary = getSummary();

        String summary = callCacheModel.summary;

        if ((summary != null) && (summary.length() == 0)) {
            callCacheModel.summary = null;
        }

        callCacheModel.transferRemarks = getTransferRemarks();

        String transferRemarks = callCacheModel.transferRemarks;

        if ((transferRemarks != null) && (transferRemarks.length() == 0)) {
            callCacheModel.transferRemarks = null;
        }

        callCacheModel.cespGoal = getCespGoal();

        String cespGoal = callCacheModel.cespGoal;

        if ((cespGoal != null) && (cespGoal.length() == 0)) {
            callCacheModel.cespGoal = null;
        }

        callCacheModel.cespOutcome = getCespOutcome();

        String cespOutcome = callCacheModel.cespOutcome;

        if ((cespOutcome != null) && (cespOutcome.length() == 0)) {
            callCacheModel.cespOutcome = null;
        }

        callCacheModel.transferredTo = getTransferredTo();

        String transferredTo = callCacheModel.transferredTo;

        if ((transferredTo != null) && (transferredTo.length() == 0)) {
            callCacheModel.transferredTo = null;
        }

        callCacheModel.otherBenefits = getOtherBenefits();

        String otherBenefits = callCacheModel.otherBenefits;

        if ((otherBenefits != null) && (otherBenefits.length() == 0)) {
            callCacheModel.otherBenefits = null;
        }

        callCacheModel.contactInfo = getContactInfo();

        String contactInfo = callCacheModel.contactInfo;

        if ((contactInfo != null) && (contactInfo.length() == 0)) {
            callCacheModel.contactInfo = null;
        }

        callCacheModel.eraService = getEraService();

        String eraService = callCacheModel.eraService;

        if ((eraService != null) && (eraService.length() == 0)) {
            callCacheModel.eraService = null;
        }

        callCacheModel.serviceBranch = getServiceBranch();

        String serviceBranch = callCacheModel.serviceBranch;

        if ((serviceBranch != null) && (serviceBranch.length() == 0)) {
            callCacheModel.serviceBranch = null;
        }

        callCacheModel.serviceStatus = getServiceStatus();

        String serviceStatus = callCacheModel.serviceStatus;

        if ((serviceStatus != null) && (serviceStatus.length() == 0)) {
            callCacheModel.serviceStatus = null;
        }

        callCacheModel.contactInfoProvided = getContactInfoProvided();

        callCacheModel.referralAgreeable = getReferralAgreeable();

        callCacheModel.withoutContact = getWithoutContact();

        callCacheModel.hangUp = getHangUp();

        callCacheModel.wrongNumber = getWrongNumber();

        callCacheModel.sameAddress = getSameAddress();

        callCacheModel.enrolled = getEnrolled();

        callCacheModel.dutyDischargeAfter911 = getDutyDischargeAfter911();

        callCacheModel.scCondition = getScCondition();

        callCacheModel.pcafcQaulified = getPcafcQaulified();

        callCacheModel.verified = getVerified();

        callCacheModel.anonymous = getAnonymous();

        callCacheModel.createGroupId = getCreateGroupId();

        callCacheModel.userId = getUserId();

        Date creationDate = getCreationDate();

        if (creationDate != null) {
            callCacheModel.creationDate = creationDate.getTime();
        } else {
            callCacheModel.creationDate = Long.MIN_VALUE;
        }

        callCacheModel.callbackPref = getCallbackPref();

        String callbackPref = callCacheModel.callbackPref;

        if ((callbackPref != null) && (callbackPref.length() == 0)) {
            callCacheModel.callbackPref = null;
        }

        return callCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(73);

        sb.append("{callId=");
        sb.append(getCallId());
        sb.append(", callType=");
        sb.append(getCallType());
        sb.append(", callerRelationship=");
        sb.append(getCallerRelationship());
        sb.append(", workPrimaryKey=");
        sb.append(getWorkPrimaryKey());
        sb.append(", callState=");
        sb.append(getCallState());
        sb.append(", callerPersnId=");
        sb.append(getCallerPersnId());
        sb.append(", callerTitle=");
        sb.append(getCallerTitle());
        sb.append(", callerLearnAbout=");
        sb.append(getCallerLearnAbout());
        sb.append(", veteranPersnId=");
        sb.append(getVeteranPersnId());
        sb.append(", message=");
        sb.append(getMessage());
        sb.append(", summary=");
        sb.append(getSummary());
        sb.append(", transferRemarks=");
        sb.append(getTransferRemarks());
        sb.append(", cespGoal=");
        sb.append(getCespGoal());
        sb.append(", cespOutcome=");
        sb.append(getCespOutcome());
        sb.append(", transferredTo=");
        sb.append(getTransferredTo());
        sb.append(", otherBenefits=");
        sb.append(getOtherBenefits());
        sb.append(", contactInfo=");
        sb.append(getContactInfo());
        sb.append(", eraService=");
        sb.append(getEraService());
        sb.append(", serviceBranch=");
        sb.append(getServiceBranch());
        sb.append(", serviceStatus=");
        sb.append(getServiceStatus());
        sb.append(", contactInfoProvided=");
        sb.append(getContactInfoProvided());
        sb.append(", referralAgreeable=");
        sb.append(getReferralAgreeable());
        sb.append(", withoutContact=");
        sb.append(getWithoutContact());
        sb.append(", hangUp=");
        sb.append(getHangUp());
        sb.append(", wrongNumber=");
        sb.append(getWrongNumber());
        sb.append(", sameAddress=");
        sb.append(getSameAddress());
        sb.append(", enrolled=");
        sb.append(getEnrolled());
        sb.append(", dutyDischargeAfter911=");
        sb.append(getDutyDischargeAfter911());
        sb.append(", scCondition=");
        sb.append(getScCondition());
        sb.append(", pcafcQaulified=");
        sb.append(getPcafcQaulified());
        sb.append(", verified=");
        sb.append(getVerified());
        sb.append(", anonymous=");
        sb.append(getAnonymous());
        sb.append(", createGroupId=");
        sb.append(getCreateGroupId());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", callbackPref=");
        sb.append(getCallbackPref());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(112);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Call");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>callId</column-name><column-value><![CDATA[");
        sb.append(getCallId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callType</column-name><column-value><![CDATA[");
        sb.append(getCallType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callerRelationship</column-name><column-value><![CDATA[");
        sb.append(getCallerRelationship());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>workPrimaryKey</column-name><column-value><![CDATA[");
        sb.append(getWorkPrimaryKey());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callState</column-name><column-value><![CDATA[");
        sb.append(getCallState());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callerPersnId</column-name><column-value><![CDATA[");
        sb.append(getCallerPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callerTitle</column-name><column-value><![CDATA[");
        sb.append(getCallerTitle());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callerLearnAbout</column-name><column-value><![CDATA[");
        sb.append(getCallerLearnAbout());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>veteranPersnId</column-name><column-value><![CDATA[");
        sb.append(getVeteranPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>message</column-name><column-value><![CDATA[");
        sb.append(getMessage());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>summary</column-name><column-value><![CDATA[");
        sb.append(getSummary());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>transferRemarks</column-name><column-value><![CDATA[");
        sb.append(getTransferRemarks());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cespGoal</column-name><column-value><![CDATA[");
        sb.append(getCespGoal());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cespOutcome</column-name><column-value><![CDATA[");
        sb.append(getCespOutcome());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>transferredTo</column-name><column-value><![CDATA[");
        sb.append(getTransferredTo());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>otherBenefits</column-name><column-value><![CDATA[");
        sb.append(getOtherBenefits());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>contactInfo</column-name><column-value><![CDATA[");
        sb.append(getContactInfo());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>eraService</column-name><column-value><![CDATA[");
        sb.append(getEraService());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>serviceBranch</column-name><column-value><![CDATA[");
        sb.append(getServiceBranch());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>serviceStatus</column-name><column-value><![CDATA[");
        sb.append(getServiceStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>contactInfoProvided</column-name><column-value><![CDATA[");
        sb.append(getContactInfoProvided());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>referralAgreeable</column-name><column-value><![CDATA[");
        sb.append(getReferralAgreeable());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>withoutContact</column-name><column-value><![CDATA[");
        sb.append(getWithoutContact());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>hangUp</column-name><column-value><![CDATA[");
        sb.append(getHangUp());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>wrongNumber</column-name><column-value><![CDATA[");
        sb.append(getWrongNumber());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>sameAddress</column-name><column-value><![CDATA[");
        sb.append(getSameAddress());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>enrolled</column-name><column-value><![CDATA[");
        sb.append(getEnrolled());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>dutyDischargeAfter911</column-name><column-value><![CDATA[");
        sb.append(getDutyDischargeAfter911());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>scCondition</column-name><column-value><![CDATA[");
        sb.append(getScCondition());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>pcafcQaulified</column-name><column-value><![CDATA[");
        sb.append(getPcafcQaulified());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>verified</column-name><column-value><![CDATA[");
        sb.append(getVerified());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>anonymous</column-name><column-value><![CDATA[");
        sb.append(getAnonymous());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>createGroupId</column-name><column-value><![CDATA[");
        sb.append(getCreateGroupId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callbackPref</column-name><column-value><![CDATA[");
        sb.append(getCallbackPref());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
