package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Call;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing Call in entity cache.
 *
 * @author caret
 * @see Call
 * @generated
 */
public class CallCacheModel implements CacheModel<Call>, Externalizable {
    public long callId;
    public String callType;
    public String callerRelationship;
    public long workPrimaryKey;
    public String callState;
    public long callerPersnId;
    public String callerTitle;
    public String callerLearnAbout;
    public long veteranPersnId;
    public String message;
    public String summary;
    public String transferRemarks;
    public String cespGoal;
    public String cespOutcome;
    public String transferredTo;
    public String otherBenefits;
    public String contactInfo;
    public String eraService;
    public String serviceBranch;
    public String serviceStatus;
    public boolean contactInfoProvided;
    public boolean referralAgreeable;
    public boolean withoutContact;
    public boolean hangUp;
    public boolean wrongNumber;
    public boolean sameAddress;
    public boolean enrolled;
    public boolean dutyDischargeAfter911;
    public boolean scCondition;
    public boolean pcafcQaulified;
    public boolean verified;
    public boolean anonymous;
    public long createGroupId;
    public long userId;
    public long creationDate;
    public String callbackPref;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(73);

        sb.append("{callId=");
        sb.append(callId);
        sb.append(", callType=");
        sb.append(callType);
        sb.append(", callerRelationship=");
        sb.append(callerRelationship);
        sb.append(", workPrimaryKey=");
        sb.append(workPrimaryKey);
        sb.append(", callState=");
        sb.append(callState);
        sb.append(", callerPersnId=");
        sb.append(callerPersnId);
        sb.append(", callerTitle=");
        sb.append(callerTitle);
        sb.append(", callerLearnAbout=");
        sb.append(callerLearnAbout);
        sb.append(", veteranPersnId=");
        sb.append(veteranPersnId);
        sb.append(", message=");
        sb.append(message);
        sb.append(", summary=");
        sb.append(summary);
        sb.append(", transferRemarks=");
        sb.append(transferRemarks);
        sb.append(", cespGoal=");
        sb.append(cespGoal);
        sb.append(", cespOutcome=");
        sb.append(cespOutcome);
        sb.append(", transferredTo=");
        sb.append(transferredTo);
        sb.append(", otherBenefits=");
        sb.append(otherBenefits);
        sb.append(", contactInfo=");
        sb.append(contactInfo);
        sb.append(", eraService=");
        sb.append(eraService);
        sb.append(", serviceBranch=");
        sb.append(serviceBranch);
        sb.append(", serviceStatus=");
        sb.append(serviceStatus);
        sb.append(", contactInfoProvided=");
        sb.append(contactInfoProvided);
        sb.append(", referralAgreeable=");
        sb.append(referralAgreeable);
        sb.append(", withoutContact=");
        sb.append(withoutContact);
        sb.append(", hangUp=");
        sb.append(hangUp);
        sb.append(", wrongNumber=");
        sb.append(wrongNumber);
        sb.append(", sameAddress=");
        sb.append(sameAddress);
        sb.append(", enrolled=");
        sb.append(enrolled);
        sb.append(", dutyDischargeAfter911=");
        sb.append(dutyDischargeAfter911);
        sb.append(", scCondition=");
        sb.append(scCondition);
        sb.append(", pcafcQaulified=");
        sb.append(pcafcQaulified);
        sb.append(", verified=");
        sb.append(verified);
        sb.append(", anonymous=");
        sb.append(anonymous);
        sb.append(", createGroupId=");
        sb.append(createGroupId);
        sb.append(", userId=");
        sb.append(userId);
        sb.append(", creationDate=");
        sb.append(creationDate);
        sb.append(", callbackPref=");
        sb.append(callbackPref);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Call toEntityModel() {
        CallImpl callImpl = new CallImpl();

        callImpl.setCallId(callId);

        if (callType == null) {
            callImpl.setCallType(StringPool.BLANK);
        } else {
            callImpl.setCallType(callType);
        }

        if (callerRelationship == null) {
            callImpl.setCallerRelationship(StringPool.BLANK);
        } else {
            callImpl.setCallerRelationship(callerRelationship);
        }

        callImpl.setWorkPrimaryKey(workPrimaryKey);

        if (callState == null) {
            callImpl.setCallState(StringPool.BLANK);
        } else {
            callImpl.setCallState(callState);
        }

        callImpl.setCallerPersnId(callerPersnId);

        if (callerTitle == null) {
            callImpl.setCallerTitle(StringPool.BLANK);
        } else {
            callImpl.setCallerTitle(callerTitle);
        }

        if (callerLearnAbout == null) {
            callImpl.setCallerLearnAbout(StringPool.BLANK);
        } else {
            callImpl.setCallerLearnAbout(callerLearnAbout);
        }

        callImpl.setVeteranPersnId(veteranPersnId);

        if (message == null) {
            callImpl.setMessage(StringPool.BLANK);
        } else {
            callImpl.setMessage(message);
        }

        if (summary == null) {
            callImpl.setSummary(StringPool.BLANK);
        } else {
            callImpl.setSummary(summary);
        }

        if (transferRemarks == null) {
            callImpl.setTransferRemarks(StringPool.BLANK);
        } else {
            callImpl.setTransferRemarks(transferRemarks);
        }

        if (cespGoal == null) {
            callImpl.setCespGoal(StringPool.BLANK);
        } else {
            callImpl.setCespGoal(cespGoal);
        }

        if (cespOutcome == null) {
            callImpl.setCespOutcome(StringPool.BLANK);
        } else {
            callImpl.setCespOutcome(cespOutcome);
        }

        if (transferredTo == null) {
            callImpl.setTransferredTo(StringPool.BLANK);
        } else {
            callImpl.setTransferredTo(transferredTo);
        }

        if (otherBenefits == null) {
            callImpl.setOtherBenefits(StringPool.BLANK);
        } else {
            callImpl.setOtherBenefits(otherBenefits);
        }

        if (contactInfo == null) {
            callImpl.setContactInfo(StringPool.BLANK);
        } else {
            callImpl.setContactInfo(contactInfo);
        }

        if (eraService == null) {
            callImpl.setEraService(StringPool.BLANK);
        } else {
            callImpl.setEraService(eraService);
        }

        if (serviceBranch == null) {
            callImpl.setServiceBranch(StringPool.BLANK);
        } else {
            callImpl.setServiceBranch(serviceBranch);
        }

        if (serviceStatus == null) {
            callImpl.setServiceStatus(StringPool.BLANK);
        } else {
            callImpl.setServiceStatus(serviceStatus);
        }

        callImpl.setContactInfoProvided(contactInfoProvided);
        callImpl.setReferralAgreeable(referralAgreeable);
        callImpl.setWithoutContact(withoutContact);
        callImpl.setHangUp(hangUp);
        callImpl.setWrongNumber(wrongNumber);
        callImpl.setSameAddress(sameAddress);
        callImpl.setEnrolled(enrolled);
        callImpl.setDutyDischargeAfter911(dutyDischargeAfter911);
        callImpl.setScCondition(scCondition);
        callImpl.setPcafcQaulified(pcafcQaulified);
        callImpl.setVerified(verified);
        callImpl.setAnonymous(anonymous);
        callImpl.setCreateGroupId(createGroupId);
        callImpl.setUserId(userId);

        if (creationDate == Long.MIN_VALUE) {
            callImpl.setCreationDate(null);
        } else {
            callImpl.setCreationDate(new Date(creationDate));
        }

        if (callbackPref == null) {
            callImpl.setCallbackPref(StringPool.BLANK);
        } else {
            callImpl.setCallbackPref(callbackPref);
        }

        callImpl.resetOriginalValues();

        return callImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        callId = objectInput.readLong();
        callType = objectInput.readUTF();
        callerRelationship = objectInput.readUTF();
        workPrimaryKey = objectInput.readLong();
        callState = objectInput.readUTF();
        callerPersnId = objectInput.readLong();
        callerTitle = objectInput.readUTF();
        callerLearnAbout = objectInput.readUTF();
        veteranPersnId = objectInput.readLong();
        message = objectInput.readUTF();
        summary = objectInput.readUTF();
        transferRemarks = objectInput.readUTF();
        cespGoal = objectInput.readUTF();
        cespOutcome = objectInput.readUTF();
        transferredTo = objectInput.readUTF();
        otherBenefits = objectInput.readUTF();
        contactInfo = objectInput.readUTF();
        eraService = objectInput.readUTF();
        serviceBranch = objectInput.readUTF();
        serviceStatus = objectInput.readUTF();
        contactInfoProvided = objectInput.readBoolean();
        referralAgreeable = objectInput.readBoolean();
        withoutContact = objectInput.readBoolean();
        hangUp = objectInput.readBoolean();
        wrongNumber = objectInput.readBoolean();
        sameAddress = objectInput.readBoolean();
        enrolled = objectInput.readBoolean();
        dutyDischargeAfter911 = objectInput.readBoolean();
        scCondition = objectInput.readBoolean();
        pcafcQaulified = objectInput.readBoolean();
        verified = objectInput.readBoolean();
        anonymous = objectInput.readBoolean();
        createGroupId = objectInput.readLong();
        userId = objectInput.readLong();
        creationDate = objectInput.readLong();
        callbackPref = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(callId);

        if (callType == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(callType);
        }

        if (callerRelationship == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(callerRelationship);
        }

        objectOutput.writeLong(workPrimaryKey);

        if (callState == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(callState);
        }

        objectOutput.writeLong(callerPersnId);

        if (callerTitle == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(callerTitle);
        }

        if (callerLearnAbout == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(callerLearnAbout);
        }

        objectOutput.writeLong(veteranPersnId);

        if (message == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(message);
        }

        if (summary == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(summary);
        }

        if (transferRemarks == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(transferRemarks);
        }

        if (cespGoal == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(cespGoal);
        }

        if (cespOutcome == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(cespOutcome);
        }

        if (transferredTo == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(transferredTo);
        }

        if (otherBenefits == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(otherBenefits);
        }

        if (contactInfo == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(contactInfo);
        }

        if (eraService == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(eraService);
        }

        if (serviceBranch == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(serviceBranch);
        }

        if (serviceStatus == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(serviceStatus);
        }

        objectOutput.writeBoolean(contactInfoProvided);
        objectOutput.writeBoolean(referralAgreeable);
        objectOutput.writeBoolean(withoutContact);
        objectOutput.writeBoolean(hangUp);
        objectOutput.writeBoolean(wrongNumber);
        objectOutput.writeBoolean(sameAddress);
        objectOutput.writeBoolean(enrolled);
        objectOutput.writeBoolean(dutyDischargeAfter911);
        objectOutput.writeBoolean(scCondition);
        objectOutput.writeBoolean(pcafcQaulified);
        objectOutput.writeBoolean(verified);
        objectOutput.writeBoolean(anonymous);
        objectOutput.writeLong(createGroupId);
        objectOutput.writeLong(userId);
        objectOutput.writeLong(creationDate);

        if (callbackPref == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(callbackPref);
        }
    }
}
