package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.BoxGp;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing BoxGp in entity cache.
 *
 * @author caret
 * @see BoxGp
 * @generated
 */
public class BoxGpCacheModel implements CacheModel<BoxGp>, Externalizable {
    public long boxGpId;
    public String boxGroup;
    public String boxSubGroup;
    public String label;
    public int viewSequence;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{boxGpId=");
        sb.append(boxGpId);
        sb.append(", boxGroup=");
        sb.append(boxGroup);
        sb.append(", boxSubGroup=");
        sb.append(boxSubGroup);
        sb.append(", label=");
        sb.append(label);
        sb.append(", viewSequence=");
        sb.append(viewSequence);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public BoxGp toEntityModel() {
        BoxGpImpl boxGpImpl = new BoxGpImpl();

        boxGpImpl.setBoxGpId(boxGpId);

        if (boxGroup == null) {
            boxGpImpl.setBoxGroup(StringPool.BLANK);
        } else {
            boxGpImpl.setBoxGroup(boxGroup);
        }

        if (boxSubGroup == null) {
            boxGpImpl.setBoxSubGroup(StringPool.BLANK);
        } else {
            boxGpImpl.setBoxSubGroup(boxSubGroup);
        }

        if (label == null) {
            boxGpImpl.setLabel(StringPool.BLANK);
        } else {
            boxGpImpl.setLabel(label);
        }

        boxGpImpl.setViewSequence(viewSequence);

        boxGpImpl.resetOriginalValues();

        return boxGpImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        boxGpId = objectInput.readLong();
        boxGroup = objectInput.readUTF();
        boxSubGroup = objectInput.readUTF();
        label = objectInput.readUTF();
        viewSequence = objectInput.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(boxGpId);

        if (boxGroup == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(boxGroup);
        }

        if (boxSubGroup == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(boxSubGroup);
        }

        if (label == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(label);
        }

        objectOutput.writeInt(viewSequence);
    }
}
