package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.BlsRe;
import gov.va.caret.model.BlsReModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the BlsRe service. Represents a row in the &quot;CARET_BLS&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.BlsReModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BlsReImpl}.
 * </p>
 *
 * @author caret
 * @see BlsReImpl
 * @see gov.va.caret.model.BlsRe
 * @see gov.va.caret.model.BlsReModel
 * @generated
 */
public class BlsReModelImpl extends BaseModelImpl<BlsRe> implements BlsReModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a bls re model instance should use the {@link gov.va.caret.model.BlsRe} interface instead.
     */
    public static final String TABLE_NAME = "CARET_BLS";
    public static final Object[][] TABLE_COLUMNS = {
            { "blsReId", Types.BIGINT },
            { "blsAeId", Types.BIGINT },
            { "year", Types.INTEGER },
            { "h75", Types.DOUBLE },
            { "city", Types.VARCHAR },
            { "zip", Types.VARCHAR },
            { "state_", Types.VARCHAR },
            { "county", Types.VARCHAR }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_BLS (blsReId LONG not null primary key,blsAeId LONG,year INTEGER,h75 DOUBLE,city VARCHAR(75) null,zip VARCHAR(75) null,state_ VARCHAR(75) null,county VARCHAR(75) null)";
    public static final String TABLE_SQL_DROP = "drop table CARET_BLS";
    public static final String ORDER_BY_JPQL = " ORDER BY blsRe.state ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_BLS.state_ ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.BlsRe"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.BlsRe"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.BlsRe"),
            true);
    public static long STATE_COLUMN_BITMASK = 1L;
    public static long ZIP_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.BlsRe"));
    private static ClassLoader _classLoader = BlsRe.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { BlsRe.class };
    private long _blsReId;
    private long _blsAeId;
    private int _year;
    private Double _h75;
    private String _city;
    private String _zip;
    private String _originalZip;
    private String _state;
    private String _originalState;
    private String _county;
    private long _columnBitmask;
    private BlsRe _escapedModel;

    public BlsReModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _blsReId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBlsReId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _blsReId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return BlsRe.class;
    }

    @Override
    public String getModelClassName() {
        return BlsRe.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("blsReId", getBlsReId());
        attributes.put("blsAeId", getBlsAeId());
        attributes.put("year", getYear());
        attributes.put("h75", getH75());
        attributes.put("city", getCity());
        attributes.put("zip", getZip());
        attributes.put("state", getState());
        attributes.put("county", getCounty());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long blsReId = (Long) attributes.get("blsReId");

        if (blsReId != null) {
            setBlsReId(blsReId);
        }

        Long blsAeId = (Long) attributes.get("blsAeId");

        if (blsAeId != null) {
            setBlsAeId(blsAeId);
        }

        Integer year = (Integer) attributes.get("year");

        if (year != null) {
            setYear(year);
        }

        Double h75 = (Double) attributes.get("h75");

        if (h75 != null) {
            setH75(h75);
        }

        String city = (String) attributes.get("city");

        if (city != null) {
            setCity(city);
        }

        String zip = (String) attributes.get("zip");

        if (zip != null) {
            setZip(zip);
        }

        String state = (String) attributes.get("state");

        if (state != null) {
            setState(state);
        }

        String county = (String) attributes.get("county");

        if (county != null) {
            setCounty(county);
        }
    }

    @Override
    public long getBlsReId() {
        return _blsReId;
    }

    @Override
    public void setBlsReId(long blsReId) {
        _blsReId = blsReId;
    }

    @Override
    public long getBlsAeId() {
        return _blsAeId;
    }

    @Override
    public void setBlsAeId(long blsAeId) {
        _blsAeId = blsAeId;
    }

    @Override
    public int getYear() {
        return _year;
    }

    @Override
    public void setYear(int year) {
        _year = year;
    }

    @Override
    public Double getH75() {
        return _h75;
    }

    @Override
    public void setH75(Double h75) {
        _h75 = h75;
    }

    @Override
    public String getCity() {
        if (_city == null) {
            return StringPool.BLANK;
        } else {
            return _city;
        }
    }

    @Override
    public void setCity(String city) {
        _city = city;
    }

    @Override
    public String getZip() {
        if (_zip == null) {
            return StringPool.BLANK;
        } else {
            return _zip;
        }
    }

    @Override
    public void setZip(String zip) {
        _columnBitmask |= ZIP_COLUMN_BITMASK;

        if (_originalZip == null) {
            _originalZip = _zip;
        }

        _zip = zip;
    }

    public String getOriginalZip() {
        return GetterUtil.getString(_originalZip);
    }

    @Override
    public String getState() {
        if (_state == null) {
            return StringPool.BLANK;
        } else {
            return _state;
        }
    }

    @Override
    public void setState(String state) {
        _columnBitmask = -1L;

        if (_originalState == null) {
            _originalState = _state;
        }

        _state = state;
    }

    public String getOriginalState() {
        return GetterUtil.getString(_originalState);
    }

    @Override
    public String getCounty() {
        if (_county == null) {
            return StringPool.BLANK;
        } else {
            return _county;
        }
    }

    @Override
    public void setCounty(String county) {
        _county = county;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            BlsRe.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public BlsRe toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (BlsRe) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        BlsReImpl blsReImpl = new BlsReImpl();

        blsReImpl.setBlsReId(getBlsReId());
        blsReImpl.setBlsAeId(getBlsAeId());
        blsReImpl.setYear(getYear());
        blsReImpl.setH75(getH75());
        blsReImpl.setCity(getCity());
        blsReImpl.setZip(getZip());
        blsReImpl.setState(getState());
        blsReImpl.setCounty(getCounty());

        blsReImpl.resetOriginalValues();

        return blsReImpl;
    }

    @Override
    public int compareTo(BlsRe blsRe) {
        int value = 0;

        value = getState().compareTo(blsRe.getState());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BlsRe)) {
            return false;
        }

        BlsRe blsRe = (BlsRe) obj;

        long primaryKey = blsRe.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        BlsReModelImpl blsReModelImpl = this;

        blsReModelImpl._originalZip = blsReModelImpl._zip;

        blsReModelImpl._originalState = blsReModelImpl._state;

        blsReModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<BlsRe> toCacheModel() {
        BlsReCacheModel blsReCacheModel = new BlsReCacheModel();

        blsReCacheModel.blsReId = getBlsReId();

        blsReCacheModel.blsAeId = getBlsAeId();

        blsReCacheModel.year = getYear();

        blsReCacheModel.h75 = getH75();

        blsReCacheModel.city = getCity();

        String city = blsReCacheModel.city;

        if ((city != null) && (city.length() == 0)) {
            blsReCacheModel.city = null;
        }

        blsReCacheModel.zip = getZip();

        String zip = blsReCacheModel.zip;

        if ((zip != null) && (zip.length() == 0)) {
            blsReCacheModel.zip = null;
        }

        blsReCacheModel.state = getState();

        String state = blsReCacheModel.state;

        if ((state != null) && (state.length() == 0)) {
            blsReCacheModel.state = null;
        }

        blsReCacheModel.county = getCounty();

        String county = blsReCacheModel.county;

        if ((county != null) && (county.length() == 0)) {
            blsReCacheModel.county = null;
        }

        return blsReCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(17);

        sb.append("{blsReId=");
        sb.append(getBlsReId());
        sb.append(", blsAeId=");
        sb.append(getBlsAeId());
        sb.append(", year=");
        sb.append(getYear());
        sb.append(", h75=");
        sb.append(getH75());
        sb.append(", city=");
        sb.append(getCity());
        sb.append(", zip=");
        sb.append(getZip());
        sb.append(", state=");
        sb.append(getState());
        sb.append(", county=");
        sb.append(getCounty());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(28);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BlsRe");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>blsReId</column-name><column-value><![CDATA[");
        sb.append(getBlsReId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>blsAeId</column-name><column-value><![CDATA[");
        sb.append(getBlsAeId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>year</column-name><column-value><![CDATA[");
        sb.append(getYear());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>h75</column-name><column-value><![CDATA[");
        sb.append(getH75());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>city</column-name><column-value><![CDATA[");
        sb.append(getCity());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>zip</column-name><column-value><![CDATA[");
        sb.append(getZip());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>state</column-name><column-value><![CDATA[");
        sb.append(getState());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>county</column-name><column-value><![CDATA[");
        sb.append(getCounty());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
