package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.BlsRe;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing BlsRe in entity cache.
 *
 * @author caret
 * @see BlsRe
 * @generated
 */
public class BlsReCacheModel implements CacheModel<BlsRe>, Externalizable {
    public long blsReId;
    public long blsAeId;
    public int year;
    public Double h75;
    public String city;
    public String zip;
    public String state;
    public String county;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(17);

        sb.append("{blsReId=");
        sb.append(blsReId);
        sb.append(", blsAeId=");
        sb.append(blsAeId);
        sb.append(", year=");
        sb.append(year);
        sb.append(", h75=");
        sb.append(h75);
        sb.append(", city=");
        sb.append(city);
        sb.append(", zip=");
        sb.append(zip);
        sb.append(", state=");
        sb.append(state);
        sb.append(", county=");
        sb.append(county);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public BlsRe toEntityModel() {
        BlsReImpl blsReImpl = new BlsReImpl();

        blsReImpl.setBlsReId(blsReId);
        blsReImpl.setBlsAeId(blsAeId);
        blsReImpl.setYear(year);
        blsReImpl.setH75(h75);

        if (city == null) {
            blsReImpl.setCity(StringPool.BLANK);
        } else {
            blsReImpl.setCity(city);
        }

        if (zip == null) {
            blsReImpl.setZip(StringPool.BLANK);
        } else {
            blsReImpl.setZip(zip);
        }

        if (state == null) {
            blsReImpl.setState(StringPool.BLANK);
        } else {
            blsReImpl.setState(state);
        }

        if (county == null) {
            blsReImpl.setCounty(StringPool.BLANK);
        } else {
            blsReImpl.setCounty(county);
        }

        blsReImpl.resetOriginalValues();

        return blsReImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        blsReId = objectInput.readLong();
        blsAeId = objectInput.readLong();
        year = objectInput.readInt();
        h75 = objectInput.readDouble();
        city = objectInput.readUTF();
        zip = objectInput.readUTF();
        state = objectInput.readUTF();
        county = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(blsReId);
        objectOutput.writeLong(blsAeId);
        objectOutput.writeInt(year);
        objectOutput.writeDouble(h75);

        if (city == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(city);
        }

        if (zip == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(zip);
        }

        if (state == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(state);
        }

        if (county == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(county);
        }
    }
}
