package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.BlsAe;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing BlsAe in entity cache.
 *
 * @author caret
 * @see BlsAe
 * @generated
 */
public class BlsAeCacheModel implements CacheModel<BlsAe>, Externalizable {
    public long blsAeId;
    public String areaName;
    public int areaNumber;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(7);

        sb.append("{blsAeId=");
        sb.append(blsAeId);
        sb.append(", areaName=");
        sb.append(areaName);
        sb.append(", areaNumber=");
        sb.append(areaNumber);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public BlsAe toEntityModel() {
        BlsAeImpl blsAeImpl = new BlsAeImpl();

        blsAeImpl.setBlsAeId(blsAeId);

        if (areaName == null) {
            blsAeImpl.setAreaName(StringPool.BLANK);
        } else {
            blsAeImpl.setAreaName(areaName);
        }

        blsAeImpl.setAreaNumber(areaNumber);

        blsAeImpl.resetOriginalValues();

        return blsAeImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        blsAeId = objectInput.readLong();
        areaName = objectInput.readUTF();
        areaNumber = objectInput.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(blsAeId);

        if (areaName == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(areaName);
        }

        objectOutput.writeInt(areaNumber);
    }
}
