package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.BgNum;
import gov.va.caret.service.BgNumLocalServiceUtil;

/**
 * The extended model base implementation for the BgNum service. Represents a row in the &quot;CARET_BOXED_GROUP_NUMERIC&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BgNumImpl}.
 * </p>
 *
 * @author caret
 * @see BgNumImpl
 * @see gov.va.caret.model.BgNum
 * @generated
 */
public abstract class BgNumBaseImpl extends BgNumModelImpl implements BgNum {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a bg num model instance should use the {@link BgNum} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            BgNumLocalServiceUtil.addBgNum(this);
        } else {
            BgNumLocalServiceUtil.updateBgNum(this);
        }
    }
}
