/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.BgMem;
import gov.va.caret.model.BgMemModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the BgMem service. Represents a row in the &quot;CARET_MEDIUM_STR_ASSOCIATION&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.BgMemModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BgMemImpl}.
 * </p>
 *
 * @author caret
 * @see BgMemImpl
 * @see gov.va.caret.model.BgMem
 * @see gov.va.caret.model.BgMemModel
 * @generated
 */
public class BgMemModelImpl extends BaseModelImpl<BgMem> implements BgMemModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a bg mem model instance should use the {@link gov.va.caret.model.BgMem} interface instead.
	 */
	public static final String TABLE_NAME = "CARET_MEDIUM_STR_ASSOCIATION";
	public static final Object[][] TABLE_COLUMNS = {
			{ "bgMemId", Types.BIGINT },
			{ "ownerId", Types.BIGINT },
			{ "boxGpId", Types.BIGINT },
			{ "mediumText", Types.VARCHAR }
		};
	public static final String TABLE_SQL_CREATE = "create table CARET_MEDIUM_STR_ASSOCIATION (bgMemId LONG not null primary key,ownerId LONG,boxGpId LONG,mediumText VARCHAR(75) null)";
	public static final String TABLE_SQL_DROP = "drop table CARET_MEDIUM_STR_ASSOCIATION";
	public static final String ORDER_BY_JPQL = " ORDER BY bgMem.bgMemId ASC";
	public static final String ORDER_BY_SQL = " ORDER BY CARET_MEDIUM_STR_ASSOCIATION.bgMemId ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.entity.cache.enabled.gov.va.caret.model.BgMem"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.finder.cache.enabled.gov.va.caret.model.BgMem"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.column.bitmask.enabled.gov.va.caret.model.BgMem"),
			true);
	public static long BOXGPID_COLUMN_BITMASK = 1L;
	public static long OWNERID_COLUMN_BITMASK = 2L;
	public static long BGMEMID_COLUMN_BITMASK = 4L;
	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
				"lock.expiration.time.gov.va.caret.model.BgMem"));

	public BgMemModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _bgMemId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setBgMemId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _bgMemId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return BgMem.class;
	}

	@Override
	public String getModelClassName() {
		return BgMem.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("bgMemId", getBgMemId());
		attributes.put("ownerId", getOwnerId());
		attributes.put("boxGpId", getBoxGpId());
		attributes.put("mediumText", getMediumText());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long bgMemId = (Long)attributes.get("bgMemId");

		if (bgMemId != null) {
			setBgMemId(bgMemId);
		}

		Long ownerId = (Long)attributes.get("ownerId");

		if (ownerId != null) {
			setOwnerId(ownerId);
		}

		Long boxGpId = (Long)attributes.get("boxGpId");

		if (boxGpId != null) {
			setBoxGpId(boxGpId);
		}

		String mediumText = (String)attributes.get("mediumText");

		if (mediumText != null) {
			setMediumText(mediumText);
		}
	}

	@Override
	public long getBgMemId() {
		return _bgMemId;
	}

	@Override
	public void setBgMemId(long bgMemId) {
		_bgMemId = bgMemId;
	}

	@Override
	public long getOwnerId() {
		return _ownerId;
	}

	@Override
	public void setOwnerId(long ownerId) {
		_columnBitmask |= OWNERID_COLUMN_BITMASK;

		if (!_setOriginalOwnerId) {
			_setOriginalOwnerId = true;

			_originalOwnerId = _ownerId;
		}

		_ownerId = ownerId;
	}

	public long getOriginalOwnerId() {
		return _originalOwnerId;
	}

	@Override
	public long getBoxGpId() {
		return _boxGpId;
	}

	@Override
	public void setBoxGpId(long boxGpId) {
		_columnBitmask |= BOXGPID_COLUMN_BITMASK;

		if (!_setOriginalBoxGpId) {
			_setOriginalBoxGpId = true;

			_originalBoxGpId = _boxGpId;
		}

		_boxGpId = boxGpId;
	}

	public long getOriginalBoxGpId() {
		return _originalBoxGpId;
	}

	@Override
	public String getMediumText() {
		if (_mediumText == null) {
			return StringPool.BLANK;
		}
		else {
			return _mediumText;
		}
	}

	@Override
	public void setMediumText(String mediumText) {
		_mediumText = mediumText;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
			BgMem.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public BgMem toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (BgMem)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		BgMemImpl bgMemImpl = new BgMemImpl();

		bgMemImpl.setBgMemId(getBgMemId());
		bgMemImpl.setOwnerId(getOwnerId());
		bgMemImpl.setBoxGpId(getBoxGpId());
		bgMemImpl.setMediumText(getMediumText());

		bgMemImpl.resetOriginalValues();

		return bgMemImpl;
	}

	@Override
	public int compareTo(BgMem bgMem) {
		long primaryKey = bgMem.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof BgMem)) {
			return false;
		}

		BgMem bgMem = (BgMem)obj;

		long primaryKey = bgMem.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public void resetOriginalValues() {
		BgMemModelImpl bgMemModelImpl = this;

		bgMemModelImpl._originalOwnerId = bgMemModelImpl._ownerId;

		bgMemModelImpl._setOriginalOwnerId = false;

		bgMemModelImpl._originalBoxGpId = bgMemModelImpl._boxGpId;

		bgMemModelImpl._setOriginalBoxGpId = false;

		bgMemModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<BgMem> toCacheModel() {
		BgMemCacheModel bgMemCacheModel = new BgMemCacheModel();

		bgMemCacheModel.bgMemId = getBgMemId();

		bgMemCacheModel.ownerId = getOwnerId();

		bgMemCacheModel.boxGpId = getBoxGpId();

		bgMemCacheModel.mediumText = getMediumText();

		String mediumText = bgMemCacheModel.mediumText;

		if ((mediumText != null) && (mediumText.length() == 0)) {
			bgMemCacheModel.mediumText = null;
		}

		return bgMemCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(9);

		sb.append("{bgMemId=");
		sb.append(getBgMemId());
		sb.append(", ownerId=");
		sb.append(getOwnerId());
		sb.append(", boxGpId=");
		sb.append(getBoxGpId());
		sb.append(", mediumText=");
		sb.append(getMediumText());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(16);

		sb.append("<model><model-name>");
		sb.append("gov.va.caret.model.BgMem");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>bgMemId</column-name><column-value><![CDATA[");
		sb.append(getBgMemId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ownerId</column-name><column-value><![CDATA[");
		sb.append(getOwnerId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>boxGpId</column-name><column-value><![CDATA[");
		sb.append(getBoxGpId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>mediumText</column-name><column-value><![CDATA[");
		sb.append(getMediumText());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static ClassLoader _classLoader = BgMem.class.getClassLoader();
	private static Class<?>[] _escapedModelInterfaces = new Class[] { BgMem.class };
	private long _bgMemId;
	private long _ownerId;
	private long _originalOwnerId;
	private boolean _setOriginalOwnerId;
	private long _boxGpId;
	private long _originalBoxGpId;
	private boolean _setOriginalBoxGpId;
	private String _mediumText;
	private long _columnBitmask;
	private BgMem _escapedModel;
}