package gov.va.caret.controller.dashboard.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchContainerConfig implements Serializable, Comparable<SearchContainerConfig> {

	private static final long serialVersionUID = 1L;
	public static final String SEARCH_CONTAINER_CONFIG = "SearchContainerConfig";

	@Override
	public int compareTo(SearchContainerConfig o) {
		return 0;
	}

	private boolean ascending = false;
	private boolean filtered = false;
	private boolean sorted = false;

	private List<Map<String,Object>> params = new ArrayList<Map<String,Object>>();
	
	private String orderCol;
	private String name;
	private int count;
	private int start;
	private int range;
	
	public SearchContainerConfig(String name, int count) {
		super();
		this.name = name;
	}
	
	public String getName() {
		return name;
	}
	
	public int getCount() {
		return count;
	}

	public int getStart() {
		return start;
	}

	public void setStart(int start) {
		this.start = start;
	}

	public int getRange() {
		return range;
	}

	public void setRange(int range) {
		this.range = range;
	}
	
	public List<Map<String, Object>> getParams() {
		return params;
	}
	public boolean isAscending() {
		return ascending;
	}
	public void setAscending(boolean ascending) {
		this.ascending = ascending;
	}
	public boolean isFiltered() {
		return filtered;
	}
	public void setFiltered(boolean filtered) {
		this.filtered = filtered;
	}
	public boolean isSorted() {
		return sorted;
	}
	public void setSorted(boolean sorted) {
		this.sorted = sorted;
	}
	public String getOrderCol() {
		return orderCol;
	}
	public void setOrderCol(String orderCol) {
		this.orderCol = orderCol;
	}
	
	
	
}
