package gov.va.caret.controller.dashboard.config;

import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;

public class HealthDashboardConfig extends DashboardConfig {

	private static final long serialVersionUID = 1L;
	public final String VIEW = "/jsp/dashboard/health.jsp";
	
	public HealthDashboardConfig() {
		super();
		
		this.enabledSearch = new EnabledSearch( new CachedReport("referrals") );
		this.reports = new GenericReport[]{ 
				new GenericReport("overdueGroupReferrals", false, "creationDate", true, ReportParameter.roleId ),
				new GenericReport("groupReferrals", false, "creationDate", true, ReportParameter.roleId ),
				new GenericReport("myReferrals", false, "creationDate", true, ReportParameter.userId ) };
	}

	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.CREATE_REFERRAL,
			CAction.CaretCan.CREATE_MESSAGES
		};
	}
	
	@Override
	public String getView() {
		return VIEW;
	}

	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR
			};
	}
}
/*
                Dashboard HEC
                                Main view
                                                create referral
                                                                update LOD section
                                                search/view  referrals
                                                search/view VCG
                                                associate referrals with VCG
                                                create/read/reply internal messaging


                Dashboard HRC
                                Main view
                                                create referral
                                                search/view  referrals
                                                search/view VCG
                                                associate referrals with VCG 
                                                create/read/reply internal messaging

 */
