package gov.va.caret.controller.dashboard.config;

import gov.va.caret.security.CAction;

public enum DashboardType {
	CSC_FUNCTION( CscDashboardConfig.class, true ), 
	CSL_FUNCTION( CslDashboardConfig.class, true ),
	HEC_FUNCTION( HealthDashboardConfig.class, true ),
	HRC_FUNCTION( HealthDashboardConfig.class, true ),
	CBOPC_FUNCTION( CbopcDashboardConfig.class, true ),
	CBOPCFM_FUNCTION( CbopcFmDashboardConfig.class, true ),
	VACO_FUNCTION( VacoDashboardConfig.class, true ),
	TECH_FUNCTION( TechDashboardConfig.class, false );
	
	Class<? extends DashboardConfig> dashboardConfig;
	boolean helped = false;
	
	DashboardType( Class<? extends DashboardConfig> dashboardConfig, boolean helped ){
		this.dashboardConfig = dashboardConfig;
		this.helped = helped;
	}
	
	public CAction.CaretCan getAction (){
		return CAction.CaretCan.valueOf( name() );
	}
	public boolean isHelped (){
		return helped;
	}
}