package gov.va.caret.controller.dashboard.config;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Role;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.security.CAction;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ResultMap;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;

public class DashboardConfigFactory { 
	
	public static DashboardConfig loadInstance( PortletRequest request, MimeResponse response ) {
		DashboardConfig dashboardConfig = null;
		
		if ( request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG) == null ){
			try {
				dashboardConfig = initDashboard(request);
				request.getPortletSession().setAttribute( CaretStrPool.DASHBOARD_CONFIG, dashboardConfig);
			} catch (SystemException e) {
				e.printStackTrace();
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		} else {
			dashboardConfig = (DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG);
		}
		if ( dashboardConfig != null ){
			try {
				request.setAttribute( CaretStrPool.ROLE, dashboardConfig.getRole() );
				if ( response != null ){
					loadNoteContent( request, response.createRenderURL() );
					loadDashBoard ( dashboardConfig, request );
				}
				
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
		
		return dashboardConfig;
	}

	private static DashboardConfig initDashboard ( PortletRequest request ) throws SystemException, ApplicationWorkFlowException {

		if ( CAction.isOmniAdmin( request ) ){
			try { //default dashboard for Portal-Admin... HEC_FUNCTION
				return DashboardType.HEC_FUNCTION.dashboardConfig.newInstance();
			} catch (InstantiationException e) {
			} catch (IllegalAccessException e) {
			}
		}

		//Assumption is that CareT users will have at most 1 site role and 1 general role with sub-type "CareT"
		long userId = PortalUtil.getUserId(request);
		List <Role> roles = RoleLocalServiceUtil.getSubtypeRoles( CAction.CARET );
		for ( Role role : roles ){
			if ( _log.isDebugEnabled() ){
				_log.debug ("Role is " +  role.getName() );
			}
			if ( RoleLocalServiceUtil.hasUserRole( userId, role.getRoleId() ) ){
				try { 
					for ( DashboardType dashboarType: DashboardType.values() ){ 
						if ( CAction.canDoCaret( request, dashboarType.name() ) ){
							DashboardConfig dashboardConfig = dashboarType.dashboardConfig.newInstance();
							dashboardConfig.setRole( role.getName() );
							dashboardConfig.setRoleId ( role.getRoleId() );
							if ( dashboardConfig instanceof FacilityDashboardConfig ){
								((FacilityDashboardConfig) dashboardConfig).setFacilities( CaretParam.getFacilities(request) );
								((FacilityDashboardConfig) dashboardConfig).setUsers( request, roles );
							}
							if ( dashboardConfig instanceof TechDashboardConfig ){
								((TechDashboardConfig ) dashboardConfig).setRoles( request, roles );
							}
							
							return dashboardConfig;
						}
					}
				} catch(java.lang.IllegalArgumentException e){
					e.printStackTrace();
				} catch (InstantiationException e) {
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					e.printStackTrace();
				}
			} else {
				if ( _log.isDebugEnabled() ){
					_log.debug("Not..." + role.getName() );
				}
			}
		}
		
		
		_log.info("No dashboard created...");
		return null;
	}
	
	private static void loadDashBoard(DashboardConfig dashboardConfig, PortletRequest renderRequest) throws ApplicationWorkFlowException {
		
		renderRequest.setAttribute( CaretStrPool.CARET_MENU, dashboardConfig.getMenu( renderRequest ) );
		renderRequest.setAttribute( CaretStrPool.SEARCHES, dashboardConfig.getEnabledSearch().getKeywords() );
		
		if ( dashboardConfig instanceof TechDashboardConfig ){
			((TechDashboardConfig) dashboardConfig).setSearchContext( renderRequest );
			CAction.canImpersonate( renderRequest );
			return;
		}
		if ( dashboardConfig instanceof FacilityDashboardConfig ){
			((FacilityDashboardConfig)dashboardConfig).configureFacility( renderRequest );
		}
		
		
		Map<String,Integer> total = ResultMap.getResultTotalMap( renderRequest );
		Map<String,List<?>> results = ResultMap.getResultListMap( renderRequest );
		Map<String,String> orderByType = ResultMap.getResultOrderTypeMap( renderRequest );
		Map<String,String> orderByColumn = ResultMap.getResultOrderColumnMap( renderRequest );
		
		Map<String,Integer> deltaMap = ResultMap.getResultOrderDeltaMap( renderRequest );
		
		for ( GenericReport report: dashboardConfig.reports ){
			if ( report instanceof CachedReport ) continue;
			Object reportParams = CaretParam.getParameter( renderRequest, report.getParameterNames() );
			int count = CaretLocalServiceUtil.getReportCount( report.getName(), reportParams );
			total.put( report.getName(), count );
			
//			SearchContainerConfig scConfig = (SearchContainerConfig)renderRequest.getPortletSession().getAttribute( report.getName() );
			
			
			if ( count > 0 && !report.isLazy() ){
//				int start = 0;
//				int end = 75;
//				
//				String orderColumn = orderByColumn.get( report.getName() );
//				boolean orderType = orderByType.get( report.getName() );
//				
//				List<Map<String,Object>> list = CaretLocalServiceUtil.getReport( 
//						report.getName(), report.getParameterNames(), 
//						orderColumn, orderType, start, end);
//				list.size();
//				results.put( report.getName(), list );
				
				int cur = ParamUtil.getInteger(renderRequest, "cur");
				int delta = ParamUtil.getInteger(renderRequest, "delta", SearchContainer.DEFAULT_DELTA);
				int start = ( cur == 0 )? 0 : delta * ( cur-1 );
				int end = ( cur == 0 )? delta : ( delta * cur );
				
				report.run(renderRequest, false, start, end);
			}
		}
		
	}
	
	private static void loadNoteContent (PortletRequest request, BaseURL baseUrl) throws ApplicationWorkFlowException {

		Object singleton = Collections.singletonMap( CaretStrPool.USER_ID, PortalUtil.getUserId(request) );
		
		ResultMap.getResultTotalMap( request ).put( CaretStrPool.MY_MESSAGES, CaretLocalServiceUtil.getReportCount( CaretStrPool.MY_NOTES, singleton ) );
		
		//TODO:// pull start/end params
		int start = 0;
		int	end = 75;
		ResultMap.getResultListMap( request ).put( CaretStrPool.MY_MESSAGES, CaretLocalServiceUtil.getReport( CaretStrPool.MY_NOTES, singleton, start, end) );
		
		//TODO: set URL...
		if ( baseUrl != null ){
			ResultMap.getResultUrlMap( request, baseUrl );
		}
	}
	
	private static Log _log = LogFactoryUtil.getLog(DashboardConfigFactory.class);
	
}