package gov.va.caret.controller.dashboard.config;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;

import gov.va.caret.security.CAction;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

import javax.portlet.PortletRequest;


public abstract class DashboardConfig implements Serializable {

	private static final long serialVersionUID = 21221212121L;
	protected EnabledSearch enabledSearch;
	protected GenericReport[] reports;
	protected String role;
	protected long roleId;
	
	public String getRole() {
		return role;
	}
	
	public long getRoleId() {
		return roleId;
	}

	public void setRole(String role) {
		this.role = role;
	}

	public abstract String getView ();
	public abstract CAction.CaretCan[] getCreateActions();
	public abstract CAction.CaretCan[] getToolsActions();
	
	public EnabledSearch getEnabledSearch() {
		return enabledSearch;
	}
	public GenericReport[] getReports() {
		return reports;
	}

	public void setRoleId( long roleId ) {
		this.roleId = roleId;		
	}
	
	public GenericReport getReport (String name){
		for ( GenericReport report: enabledSearch.getCachedReports() ){
			if ( name.equals( report.getName() ) ){
				return report;
			}
		}
		for ( GenericReport report: reports ){
			if ( name.equals( report.getName() ) ){
				return report;
			}
		}
		return null;
	}

	public Object getMenu(PortletRequest renderRequest) {
		Map<String,String> createActions = new TreeMap<String,String>();
		Locale locale = LocaleUtil.getDefault();
		for ( CAction.CaretCan canDo: getCreateActions() ){
			if ( CAction.canDoCaret( renderRequest, canDo.name() ) ){
				createActions.put( canDo.name(), LanguageUtil.get( locale, canDo.toString() ));
			}
		}
		
		Map<String,String> toolsActions = new TreeMap<String,String>();
		for ( CAction.CaretCan canDo: getToolsActions() ){
			if ( CAction.canDoCaret( renderRequest, canDo.name() ) ){
				toolsActions.put( canDo.name(), LanguageUtil.get( locale, canDo.toString() ) );
			}
		}
		
		Map<String,Map<String,String>> menu = new HashMap<String, Map<String,String>>();
		if ( !createActions.isEmpty() ){
			menu.put("createActions", createActions);
		}
		if ( !toolsActions.isEmpty() ){
			menu.put("toolsActions", toolsActions);
		}
		if ( menu.isEmpty() ){
			return null;
		}
			
		return menu;
	}
}
