package gov.va.caret.controller.dashboard.config;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Facil;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.portlet.PortletRequest;

public class CscDashboardConfig extends FacilityDashboardConfig {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6732888370712702769L;
	public final String VIEW = "/jsp/dashboard/csc.jsp";
	private Map<Long,Facil> facilities;
	long groupId = 0;
	
	
	public CscDashboardConfig() {
		super();
		
		this.reports = new GenericReport[]{ 
				new GenericReport("unassignedWork", false, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ), 
				new GenericReport("myApplicationWork", false, "creationDate", true, ReportParameter.userId, ReportParameter.queId ),
				//My CBOPC Work...
				new GenericReport("myCbopcWork", false, "creationDate", true, ReportParameter.userId, ReportParameter.queId ),
				
				new GenericReport("newApplications", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ) ,
				new GenericReport("inProcess", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId  ),
				new GenericReport("transferred", true, "creationDate", true, ReportParameter.userOrgIds ) ,
				new GenericReport("dueTodayWork", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ), 
				new GenericReport("overdueApps", true, "creationDate", true, ReportParameter.userOrgIds ) ,
				new GenericReport("overdueInProcess", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ),
				//new GenericReport("homeVisit", true, "creationDate", true, ReportParameter.userOrgIds ),
				new GenericReport("homeVisit", true, "creationDate", true ),
				new GenericReport("deathNotice", true, "creationDate", true, ReportParameter.userOrgIds ),
				new GenericReport("referrals", true, "creationDate", true, ReportParameter.userOrgIds ) ,
				new GenericReport("vcgNotifications", true, "creationDate", true, ReportParameter.userOrgIds ),
				new GenericReport("tiuNoteRewrite", true, "creationDate", true, ReportParameter.userOrgIds ),
				new CachedReport("persnAudit")
			};
		
		this.enabledSearch = new EnabledSearch( new CachedReport("vcgs"), new CachedReport("workItems") );
	}
	
	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.CREATE_MESSAGES,
			CAction.CaretCan.CREATE_APPLICATIONS
		};
	}
	
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR,
				CAction.CaretCan.IDENTITY_MATCHING
			};
	}

	@Override
	public String getView() {
		return VIEW;
	}
	public void setFacilityId( long groupId ){
		this.groupId = groupId;
	}
	
	public long getFacilityId(){
		if ( groupId == 0 ){
			if ( !facilities.isEmpty() ){
				return facilities.get(0).getGroupId();
			}
		}
		return groupId;
	}
	public Map<Long,Facil> getFacilities(){
		return facilities;
	}
	public void setFacilities(Map<Long,Facil> facilities){
		this.facilities = facilities;
	}
	
	public void setUsers(PortletRequest request, List<Role> roles ) throws ApplicationWorkFlowException {
		@SuppressWarnings("unchecked")
		Map<String,Long> userMap = (Map<String,Long>)request.getPortletSession().getAttribute(CaretStrPool.USERMAP);
		if ( userMap == null ) {
			userMap = new TreeMap<String,Long>();
		}
		
//		List<Organization> orgs;
//		Set<Long> userIds = new TreeSet<Long>();
//		try {
//			orgs = OrganizationLocalServiceUtil.getUserOrganizations( PortalUtil.getUserId(request) );
//			for ( Organization org: orgs ){
//				for ( long userId : UserLocalServiceUtil.getOrganizationUserIds( org.getOrganizationId() ) ){
//					userIds.add(userId);
//				}
//			}
//		} catch (SystemException e) {
//			throw new ApplicationWorkFlowException(e);
//		}
		
		if ( userMap.isEmpty() ){
			List<String> list = Arrays.asList(PortletProps.getArray( CaretStrPool.CSC_ASSIGNABLE_ROLES ) ); 
			for ( Role role: roles ){
				if ( list.contains( role.getName() ) ){
					try {
						List<User> users = UserLocalServiceUtil.getRoleUsers( role.getRoleId() );
						for ( User user: users ){
//							if ( userIds.contains( user.getUserId() ) ){
								userMap.put(user.getFullName(), user.getUserId() );
//							}
						}
					} catch (SystemException e) {
						e.printStackTrace();
					}
				}
			}
			request.getPortletSession().setAttribute(CaretStrPool.USERMAP, userMap);
			
			
		}
	}

	@Override
	public void configureFacility(PortletRequest request) throws ApplicationWorkFlowException {
		Map<Long,Facil> facilities = CaretParam.getFacilities(request);
		String facility = "";
		if ( facilities != null && !facilities.isEmpty() ){
			StringBuilder sb = new StringBuilder(" ( Facility=");
			for ( Iterator<Facil> iter = facilities.values().iterator(); iter.hasNext(); ){
				Facil facil = iter.next();
				sb.append(facil.getFacilityNumber()).append(", ");
				if ( facility.isEmpty() ){
					try {
						Organization org = OrganizationLocalServiceUtil.getOrganization( facil.getGroupId() );
						facility = org.getName();
					} catch (PortalException e) {
						e.printStackTrace();
					} catch (SystemException e) {
						e.printStackTrace();
					}
				} else {
					facility = "multiple-facilities";
				}
			}
			request.setAttribute("facilityName", facility );
			request.setAttribute("facilityNumber", sb.substring(0, sb.length() - 2) + " )" );
		}
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		caret.put( CaretStrPool.VHA_SYSTEM, Toolbox.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
		caret.put( CaretStrPool.USERMAP, request.getPortletSession().getAttribute(CaretStrPool.USERMAP) );
		caret.put( CaretStrPool.WORKITEM_TYPES, WorkType.getFilterRegistered() );
	}

	
	private static Log _log = LogFactoryUtil.getLog( CscDashboardConfig.class );
}
