package gov.va.caret.controller.dashboard.config;

import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;


public class CbopcDashboardConfig extends DashboardConfig {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5910038587835405338L;
	public final String VIEW = "/jsp/dashboard/cbopc.jsp";
	
	public CbopcDashboardConfig() {
		super();
		
		this.enabledSearch = new EnabledSearch( new CachedReport("vcgs"), new CachedReport("workItems"), new CachedReport("vendors"), new CachedReport("payments") );
		this.reports = new GenericReport[]{ 
//					new GenericReport("vendors"),
					new GenericReport("myCbopcWork", false, "creationDate", true, ReportParameter.userId, ReportParameter.queId ),
					new GenericReport("cbopcChampva", false, "creationDate", true, ReportParameter.userId, ReportParameter.queId ),
					new GenericReport("cbopcVendor", false, "creationDate", true, ReportParameter.userId, ReportParameter.queId ),
					new GenericReport("cbopcReview", false, "creationDate", true, ReportParameter.userId, ReportParameter.queId )
//					new GenericReport("vcgApplications"),
//					new GenericReport("cbopcPayments"),
//					new GenericReport("blsRates")
					};
	}
	
	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.CREATE_MESSAGES
		};
	}

	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR
			};
	}
	
	@Override
	public String getView() {
		return VIEW;
	}

}
