package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.Waivr;

/**
 * The persistence interface for the waivr service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see WaivrPersistenceImpl
 * @see WaivrUtil
 * @generated
 */
public interface WaivrPersistence extends BasePersistence<Waivr> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link WaivrUtil} to access the waivr persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Caches the waivr in the entity cache if it is enabled.
    *
    * @param waivr the waivr
    */
    public void cacheResult(gov.va.caret.model.Waivr waivr);

    /**
    * Caches the waivrs in the entity cache if it is enabled.
    *
    * @param waivrs the waivrs
    */
    public void cacheResult(java.util.List<gov.va.caret.model.Waivr> waivrs);

    /**
    * Creates a new waivr with the primary key. Does not add the waivr to the database.
    *
    * @param waivrId the primary key for the new waivr
    * @return the new waivr
    */
    public gov.va.caret.model.Waivr create(long waivrId);

    /**
    * Removes the waivr with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param waivrId the primary key of the waivr
    * @return the waivr that was removed
    * @throws gov.va.caret.NoSuchWaivrException if a waivr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Waivr remove(long waivrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWaivrException;

    public gov.va.caret.model.Waivr updateImpl(gov.va.caret.model.Waivr waivr)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the waivr with the primary key or throws a {@link gov.va.caret.NoSuchWaivrException} if it could not be found.
    *
    * @param waivrId the primary key of the waivr
    * @return the waivr
    * @throws gov.va.caret.NoSuchWaivrException if a waivr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Waivr findByPrimaryKey(long waivrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWaivrException;

    /**
    * Returns the waivr with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param waivrId the primary key of the waivr
    * @return the waivr, or <code>null</code> if a waivr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Waivr fetchByPrimaryKey(long waivrId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the waivrs.
    *
    * @return the waivrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Waivr> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the waivrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WaivrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of waivrs
    * @param end the upper bound of the range of waivrs (not inclusive)
    * @return the range of waivrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Waivr> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the waivrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WaivrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of waivrs
    * @param end the upper bound of the range of waivrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of waivrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Waivr> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the waivrs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of waivrs.
    *
    * @return the number of waivrs
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
