package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.VetVr;

import java.util.List;

/**
 * The persistence utility for the vet vr service. This utility wraps {@link VetVrPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see VetVrPersistence
 * @see VetVrPersistenceImpl
 * @generated
 */
public class VetVrUtil {
    private static VetVrPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(VetVr vetVr) {
        getPersistence().clearCache(vetVr);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<VetVr> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<VetVr> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<VetVr> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static VetVr update(VetVr vetVr) throws SystemException {
        return getPersistence().update(vetVr);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static VetVr update(VetVr vetVr, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(vetVr, serviceContext);
    }

    /**
    * Caches the vet vr in the entity cache if it is enabled.
    *
    * @param vetVr the vet vr
    */
    public static void cacheResult(gov.va.caret.model.VetVr vetVr) {
        getPersistence().cacheResult(vetVr);
    }

    /**
    * Caches the vet vrs in the entity cache if it is enabled.
    *
    * @param vetVrs the vet vrs
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.VetVr> vetVrs) {
        getPersistence().cacheResult(vetVrs);
    }

    /**
    * Creates a new vet vr with the primary key. Does not add the vet vr to the database.
    *
    * @param vetVrId the primary key for the new vet vr
    * @return the new vet vr
    */
    public static gov.va.caret.model.VetVr create(long vetVrId) {
        return getPersistence().create(vetVrId);
    }

    /**
    * Removes the vet vr with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param vetVrId the primary key of the vet vr
    * @return the vet vr that was removed
    * @throws gov.va.caret.NoSuchVetVrException if a vet vr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VetVr remove(long vetVrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVetVrException {
        return getPersistence().remove(vetVrId);
    }

    public static gov.va.caret.model.VetVr updateImpl(
        gov.va.caret.model.VetVr vetVr)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(vetVr);
    }

    /**
    * Returns the vet vr with the primary key or throws a {@link gov.va.caret.NoSuchVetVrException} if it could not be found.
    *
    * @param vetVrId the primary key of the vet vr
    * @return the vet vr
    * @throws gov.va.caret.NoSuchVetVrException if a vet vr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VetVr findByPrimaryKey(long vetVrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVetVrException {
        return getPersistence().findByPrimaryKey(vetVrId);
    }

    /**
    * Returns the vet vr with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param vetVrId the primary key of the vet vr
    * @return the vet vr, or <code>null</code> if a vet vr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VetVr fetchByPrimaryKey(long vetVrId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(vetVrId);
    }

    /**
    * Returns all the vet vrs.
    *
    * @return the vet vrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VetVr> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the vet vrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VetVrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vet vrs
    * @param end the upper bound of the range of vet vrs (not inclusive)
    * @return the range of vet vrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VetVr> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the vet vrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VetVrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vet vrs
    * @param end the upper bound of the range of vet vrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of vet vrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VetVr> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the vet vrs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of vet vrs.
    *
    * @return the number of vet vrs
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static VetVrPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (VetVrPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    VetVrPersistence.class.getName());

            ReferenceRegistry.registerReference(VetVrUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(VetVrPersistence persistence) {
    }
}
