package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.VetVr;

/**
 * The persistence interface for the vet vr service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see VetVrPersistenceImpl
 * @see VetVrUtil
 * @generated
 */
public interface VetVrPersistence extends BasePersistence<VetVr> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link VetVrUtil} to access the vet vr persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Caches the vet vr in the entity cache if it is enabled.
    *
    * @param vetVr the vet vr
    */
    public void cacheResult(gov.va.caret.model.VetVr vetVr);

    /**
    * Caches the vet vrs in the entity cache if it is enabled.
    *
    * @param vetVrs the vet vrs
    */
    public void cacheResult(java.util.List<gov.va.caret.model.VetVr> vetVrs);

    /**
    * Creates a new vet vr with the primary key. Does not add the vet vr to the database.
    *
    * @param vetVrId the primary key for the new vet vr
    * @return the new vet vr
    */
    public gov.va.caret.model.VetVr create(long vetVrId);

    /**
    * Removes the vet vr with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param vetVrId the primary key of the vet vr
    * @return the vet vr that was removed
    * @throws gov.va.caret.NoSuchVetVrException if a vet vr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.VetVr remove(long vetVrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVetVrException;

    public gov.va.caret.model.VetVr updateImpl(gov.va.caret.model.VetVr vetVr)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the vet vr with the primary key or throws a {@link gov.va.caret.NoSuchVetVrException} if it could not be found.
    *
    * @param vetVrId the primary key of the vet vr
    * @return the vet vr
    * @throws gov.va.caret.NoSuchVetVrException if a vet vr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.VetVr findByPrimaryKey(long vetVrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVetVrException;

    /**
    * Returns the vet vr with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param vetVrId the primary key of the vet vr
    * @return the vet vr, or <code>null</code> if a vet vr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.VetVr fetchByPrimaryKey(long vetVrId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the vet vrs.
    *
    * @return the vet vrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.VetVr> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the vet vrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VetVrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vet vrs
    * @param end the upper bound of the range of vet vrs (not inclusive)
    * @return the range of vet vrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.VetVr> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the vet vrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VetVrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vet vrs
    * @param end the upper bound of the range of vet vrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of vet vrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.VetVr> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the vet vrs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of vet vrs.
    *
    * @return the number of vet vrs
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
