package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.Vcg;

/**
 * The persistence interface for the vcg service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see VcgPersistenceImpl
 * @see VcgUtil
 * @generated
 */
public interface VcgPersistence extends BasePersistence<Vcg> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link VcgUtil} to access the vcg persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns the vcg where veteranId = &#63; or throws a {@link gov.va.caret.NoSuchVcgException} if it could not be found.
    *
    * @param veteranId the veteran ID
    * @return the matching vcg
    * @throws gov.va.caret.NoSuchVcgException if a matching vcg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vcg findByVeteran(long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgException;

    /**
    * Returns the vcg where veteranId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param veteranId the veteran ID
    * @return the matching vcg, or <code>null</code> if a matching vcg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vcg fetchByVeteran(long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the vcg where veteranId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param veteranId the veteran ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching vcg, or <code>null</code> if a matching vcg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vcg fetchByVeteran(long veteranId,
        boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes the vcg where veteranId = &#63; from the database.
    *
    * @param veteranId the veteran ID
    * @return the vcg that was removed
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vcg removeByVeteran(long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgException;

    /**
    * Returns the number of vcgs where veteranId = &#63;.
    *
    * @param veteranId the veteran ID
    * @return the number of matching vcgs
    * @throws SystemException if a system exception occurred
    */
    public int countByVeteran(long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the vcg in the entity cache if it is enabled.
    *
    * @param vcg the vcg
    */
    public void cacheResult(gov.va.caret.model.Vcg vcg);

    /**
    * Caches the vcgs in the entity cache if it is enabled.
    *
    * @param vcgs the vcgs
    */
    public void cacheResult(java.util.List<gov.va.caret.model.Vcg> vcgs);

    /**
    * Creates a new vcg with the primary key. Does not add the vcg to the database.
    *
    * @param vcgId the primary key for the new vcg
    * @return the new vcg
    */
    public gov.va.caret.model.Vcg create(long vcgId);

    /**
    * Removes the vcg with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param vcgId the primary key of the vcg
    * @return the vcg that was removed
    * @throws gov.va.caret.NoSuchVcgException if a vcg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vcg remove(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgException;

    public gov.va.caret.model.Vcg updateImpl(gov.va.caret.model.Vcg vcg)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the vcg with the primary key or throws a {@link gov.va.caret.NoSuchVcgException} if it could not be found.
    *
    * @param vcgId the primary key of the vcg
    * @return the vcg
    * @throws gov.va.caret.NoSuchVcgException if a vcg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vcg findByPrimaryKey(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgException;

    /**
    * Returns the vcg with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param vcgId the primary key of the vcg
    * @return the vcg, or <code>null</code> if a vcg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vcg fetchByPrimaryKey(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the vcgs.
    *
    * @return the vcgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vcg> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the vcgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vcgs
    * @param end the upper bound of the range of vcgs (not inclusive)
    * @return the range of vcgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vcg> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the vcgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vcgs
    * @param end the upper bound of the range of vcgs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of vcgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vcg> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the vcgs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of vcgs.
    *
    * @return the number of vcgs
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
