package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.StiPt;

/**
 * The persistence interface for the sti pt service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see StiPtPersistenceImpl
 * @see StiPtUtil
 * @generated
 */
public interface StiPtPersistence extends BasePersistence<StiPt> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link StiPtUtil} to access the sti pt persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the sti pts where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @return the matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findByStiRdId(long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the sti pts where stiRdId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stiRdId the sti rd ID
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @return the range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findByStiRdId(
        long stiRdId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the sti pts where stiRdId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stiRdId the sti rd ID
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findByStiRdId(
        long stiRdId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first sti pt in the ordered set where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt findByStiRdId_First(long stiRdId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException;

    /**
    * Returns the first sti pt in the ordered set where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt fetchByStiRdId_First(long stiRdId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last sti pt in the ordered set where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt findByStiRdId_Last(long stiRdId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException;

    /**
    * Returns the last sti pt in the ordered set where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt fetchByStiRdId_Last(long stiRdId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the sti pts before and after the current sti pt in the ordered set where stiRdId = &#63;.
    *
    * @param stiPtId the primary key of the current sti pt
    * @param stiRdId the sti rd ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt[] findByStiRdId_PrevAndNext(long stiPtId,
        long stiRdId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException;

    /**
    * Removes all the sti pts where stiRdId = &#63; from the database.
    *
    * @param stiRdId the sti rd ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByStiRdId(long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of sti pts where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @return the number of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public int countByStiRdId(long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the sti pts where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @return the matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findByVendrId(long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the sti pts where vendrId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vendrId the vendr ID
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @return the range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findByVendrId(
        long vendrId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the sti pts where vendrId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vendrId the vendr ID
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findByVendrId(
        long vendrId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first sti pt in the ordered set where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt findByVendrId_First(long vendrId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException;

    /**
    * Returns the first sti pt in the ordered set where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt fetchByVendrId_First(long vendrId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last sti pt in the ordered set where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt findByVendrId_Last(long vendrId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException;

    /**
    * Returns the last sti pt in the ordered set where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt fetchByVendrId_Last(long vendrId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the sti pts before and after the current sti pt in the ordered set where vendrId = &#63;.
    *
    * @param stiPtId the primary key of the current sti pt
    * @param vendrId the vendr ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt[] findByVendrId_PrevAndNext(long stiPtId,
        long vendrId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException;

    /**
    * Removes all the sti pts where vendrId = &#63; from the database.
    *
    * @param vendrId the vendr ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByVendrId(long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of sti pts where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @return the number of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public int countByVendrId(long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @return the matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findByStipendStatus(
        java.lang.String stipendStatus, java.util.Date stipendStartDate)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @return the range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findByStipendStatus(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findByStipendStatus(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt findByStipendStatus_First(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException;

    /**
    * Returns the first sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt fetchByStipendStatus_First(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt findByStipendStatus_Last(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException;

    /**
    * Returns the last sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt fetchByStipendStatus_Last(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the sti pts before and after the current sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stiPtId the primary key of the current sti pt
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt[] findByStipendStatus_PrevAndNext(
        long stiPtId, java.lang.String stipendStatus,
        java.util.Date stipendStartDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException;

    /**
    * Removes all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63; from the database.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @throws SystemException if a system exception occurred
    */
    public void removeByStipendStatus(java.lang.String stipendStatus,
        java.util.Date stipendStartDate)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @return the number of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public int countByStipendStatus(java.lang.String stipendStatus,
        java.util.Date stipendStartDate)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the sti pt in the entity cache if it is enabled.
    *
    * @param stiPt the sti pt
    */
    public void cacheResult(gov.va.caret.model.StiPt stiPt);

    /**
    * Caches the sti pts in the entity cache if it is enabled.
    *
    * @param stiPts the sti pts
    */
    public void cacheResult(java.util.List<gov.va.caret.model.StiPt> stiPts);

    /**
    * Creates a new sti pt with the primary key. Does not add the sti pt to the database.
    *
    * @param stiPtId the primary key for the new sti pt
    * @return the new sti pt
    */
    public gov.va.caret.model.StiPt create(long stiPtId);

    /**
    * Removes the sti pt with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param stiPtId the primary key of the sti pt
    * @return the sti pt that was removed
    * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt remove(long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException;

    public gov.va.caret.model.StiPt updateImpl(gov.va.caret.model.StiPt stiPt)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the sti pt with the primary key or throws a {@link gov.va.caret.NoSuchStiPtException} if it could not be found.
    *
    * @param stiPtId the primary key of the sti pt
    * @return the sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt findByPrimaryKey(long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException;

    /**
    * Returns the sti pt with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param stiPtId the primary key of the sti pt
    * @return the sti pt, or <code>null</code> if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiPt fetchByPrimaryKey(long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the sti pts.
    *
    * @return the sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the sti pts.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @return the range of sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the sti pts.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of sti pts
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiPt> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the sti pts from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of sti pts.
    *
    * @return the number of sti pts
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
