package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.Call;

import java.util.List;

/**
 * The persistence utility for the call service. This utility wraps {@link CallPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see CallPersistence
 * @see CallPersistenceImpl
 * @generated
 */
public class CallUtil {
    private static CallPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(Call call) {
        getPersistence().clearCache(call);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<Call> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<Call> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<Call> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static Call update(Call call) throws SystemException {
        return getPersistence().update(call);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static Call update(Call call, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(call, serviceContext);
    }

    /**
    * Returns all the calls where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @return the matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByCreateGroupId(
        long createGroupId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByCreateGroupId(createGroupId);
    }

    /**
    * Returns a range of all the calls where createGroupId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param createGroupId the create group ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @return the range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByCreateGroupId(
        long createGroupId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByCreateGroupId(createGroupId, start, end);
    }

    /**
    * Returns an ordered range of all the calls where createGroupId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param createGroupId the create group ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByCreateGroupId(
        long createGroupId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByCreateGroupId(createGroupId, start, end,
            orderByComparator);
    }

    /**
    * Returns the first call in the ordered set where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call findByCreateGroupId_First(
        long createGroupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence()
                   .findByCreateGroupId_First(createGroupId, orderByComparator);
    }

    /**
    * Returns the first call in the ordered set where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call fetchByCreateGroupId_First(
        long createGroupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByCreateGroupId_First(createGroupId, orderByComparator);
    }

    /**
    * Returns the last call in the ordered set where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call findByCreateGroupId_Last(
        long createGroupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence()
                   .findByCreateGroupId_Last(createGroupId, orderByComparator);
    }

    /**
    * Returns the last call in the ordered set where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call fetchByCreateGroupId_Last(
        long createGroupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByCreateGroupId_Last(createGroupId, orderByComparator);
    }

    /**
    * Returns the calls before and after the current call in the ordered set where createGroupId = &#63;.
    *
    * @param callId the primary key of the current call
    * @param createGroupId the create group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next call
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call[] findByCreateGroupId_PrevAndNext(
        long callId, long createGroupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence()
                   .findByCreateGroupId_PrevAndNext(callId, createGroupId,
            orderByComparator);
    }

    /**
    * Removes all the calls where createGroupId = &#63; from the database.
    *
    * @param createGroupId the create group ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByCreateGroupId(long createGroupId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByCreateGroupId(createGroupId);
    }

    /**
    * Returns the number of calls where createGroupId = &#63;.
    *
    * @param createGroupId the create group ID
    * @return the number of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static int countByCreateGroupId(long createGroupId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByCreateGroupId(createGroupId);
    }

    /**
    * Returns all the calls where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @return the matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByCallerPersnId(
        long callerPersnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByCallerPersnId(callerPersnId);
    }

    /**
    * Returns a range of all the calls where callerPersnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callerPersnId the caller persn ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @return the range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByCallerPersnId(
        long callerPersnId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByCallerPersnId(callerPersnId, start, end);
    }

    /**
    * Returns an ordered range of all the calls where callerPersnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callerPersnId the caller persn ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByCallerPersnId(
        long callerPersnId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByCallerPersnId(callerPersnId, start, end,
            orderByComparator);
    }

    /**
    * Returns the first call in the ordered set where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call findByCallerPersnId_First(
        long callerPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence()
                   .findByCallerPersnId_First(callerPersnId, orderByComparator);
    }

    /**
    * Returns the first call in the ordered set where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call fetchByCallerPersnId_First(
        long callerPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByCallerPersnId_First(callerPersnId, orderByComparator);
    }

    /**
    * Returns the last call in the ordered set where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call findByCallerPersnId_Last(
        long callerPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence()
                   .findByCallerPersnId_Last(callerPersnId, orderByComparator);
    }

    /**
    * Returns the last call in the ordered set where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call fetchByCallerPersnId_Last(
        long callerPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByCallerPersnId_Last(callerPersnId, orderByComparator);
    }

    /**
    * Returns the calls before and after the current call in the ordered set where callerPersnId = &#63;.
    *
    * @param callId the primary key of the current call
    * @param callerPersnId the caller persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next call
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call[] findByCallerPersnId_PrevAndNext(
        long callId, long callerPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence()
                   .findByCallerPersnId_PrevAndNext(callId, callerPersnId,
            orderByComparator);
    }

    /**
    * Removes all the calls where callerPersnId = &#63; from the database.
    *
    * @param callerPersnId the caller persn ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByCallerPersnId(long callerPersnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByCallerPersnId(callerPersnId);
    }

    /**
    * Returns the number of calls where callerPersnId = &#63;.
    *
    * @param callerPersnId the caller persn ID
    * @return the number of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static int countByCallerPersnId(long callerPersnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByCallerPersnId(callerPersnId);
    }

    /**
    * Returns all the calls where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @return the matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByVeteranPersnId(
        long veteranPersnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVeteranPersnId(veteranPersnId);
    }

    /**
    * Returns a range of all the calls where veteranPersnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param veteranPersnId the veteran persn ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @return the range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByVeteranPersnId(
        long veteranPersnId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVeteranPersnId(veteranPersnId, start, end);
    }

    /**
    * Returns an ordered range of all the calls where veteranPersnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param veteranPersnId the veteran persn ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByVeteranPersnId(
        long veteranPersnId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByVeteranPersnId(veteranPersnId, start, end,
            orderByComparator);
    }

    /**
    * Returns the first call in the ordered set where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call findByVeteranPersnId_First(
        long veteranPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence()
                   .findByVeteranPersnId_First(veteranPersnId, orderByComparator);
    }

    /**
    * Returns the first call in the ordered set where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call fetchByVeteranPersnId_First(
        long veteranPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByVeteranPersnId_First(veteranPersnId,
            orderByComparator);
    }

    /**
    * Returns the last call in the ordered set where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call findByVeteranPersnId_Last(
        long veteranPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence()
                   .findByVeteranPersnId_Last(veteranPersnId, orderByComparator);
    }

    /**
    * Returns the last call in the ordered set where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call fetchByVeteranPersnId_Last(
        long veteranPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByVeteranPersnId_Last(veteranPersnId, orderByComparator);
    }

    /**
    * Returns the calls before and after the current call in the ordered set where veteranPersnId = &#63;.
    *
    * @param callId the primary key of the current call
    * @param veteranPersnId the veteran persn ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next call
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call[] findByVeteranPersnId_PrevAndNext(
        long callId, long veteranPersnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence()
                   .findByVeteranPersnId_PrevAndNext(callId, veteranPersnId,
            orderByComparator);
    }

    /**
    * Removes all the calls where veteranPersnId = &#63; from the database.
    *
    * @param veteranPersnId the veteran persn ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByVeteranPersnId(long veteranPersnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByVeteranPersnId(veteranPersnId);
    }

    /**
    * Returns the number of calls where veteranPersnId = &#63;.
    *
    * @param veteranPersnId the veteran persn ID
    * @return the number of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static int countByVeteranPersnId(long veteranPersnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByVeteranPersnId(veteranPersnId);
    }

    /**
    * Returns all the calls where userId = &#63;.
    *
    * @param userId the user ID
    * @return the matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByUserId(
        long userId) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByUserId(userId);
    }

    /**
    * Returns a range of all the calls where userId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param userId the user ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @return the range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByUserId(
        long userId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByUserId(userId, start, end);
    }

    /**
    * Returns an ordered range of all the calls where userId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param userId the user ID
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findByUserId(
        long userId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByUserId(userId, start, end, orderByComparator);
    }

    /**
    * Returns the first call in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call findByUserId_First(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence().findByUserId_First(userId, orderByComparator);
    }

    /**
    * Returns the first call in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call fetchByUserId_First(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByUserId_First(userId, orderByComparator);
    }

    /**
    * Returns the last call in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call
    * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call findByUserId_Last(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence().findByUserId_Last(userId, orderByComparator);
    }

    /**
    * Returns the last call in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching call, or <code>null</code> if a matching call could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call fetchByUserId_Last(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByUserId_Last(userId, orderByComparator);
    }

    /**
    * Returns the calls before and after the current call in the ordered set where userId = &#63;.
    *
    * @param callId the primary key of the current call
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next call
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call[] findByUserId_PrevAndNext(
        long callId, long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence()
                   .findByUserId_PrevAndNext(callId, userId, orderByComparator);
    }

    /**
    * Removes all the calls where userId = &#63; from the database.
    *
    * @param userId the user ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByUserId(long userId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByUserId(userId);
    }

    /**
    * Returns the number of calls where userId = &#63;.
    *
    * @param userId the user ID
    * @return the number of matching calls
    * @throws SystemException if a system exception occurred
    */
    public static int countByUserId(long userId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByUserId(userId);
    }

    /**
    * Caches the call in the entity cache if it is enabled.
    *
    * @param call the call
    */
    public static void cacheResult(gov.va.caret.model.Call call) {
        getPersistence().cacheResult(call);
    }

    /**
    * Caches the calls in the entity cache if it is enabled.
    *
    * @param calls the calls
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.Call> calls) {
        getPersistence().cacheResult(calls);
    }

    /**
    * Creates a new call with the primary key. Does not add the call to the database.
    *
    * @param callId the primary key for the new call
    * @return the new call
    */
    public static gov.va.caret.model.Call create(long callId) {
        return getPersistence().create(callId);
    }

    /**
    * Removes the call with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param callId the primary key of the call
    * @return the call that was removed
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call remove(long callId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence().remove(callId);
    }

    public static gov.va.caret.model.Call updateImpl(
        gov.va.caret.model.Call call)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(call);
    }

    /**
    * Returns the call with the primary key or throws a {@link gov.va.caret.NoSuchCallException} if it could not be found.
    *
    * @param callId the primary key of the call
    * @return the call
    * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call findByPrimaryKey(long callId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCallException {
        return getPersistence().findByPrimaryKey(callId);
    }

    /**
    * Returns the call with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param callId the primary key of the call
    * @return the call, or <code>null</code> if a call with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Call fetchByPrimaryKey(long callId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(callId);
    }

    /**
    * Returns all the calls.
    *
    * @return the calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the calls.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @return the range of calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the calls.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of calls
    * @param end the upper bound of the range of calls (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of calls
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Call> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the calls from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of calls.
    *
    * @return the number of calls
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static CallPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (CallPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    CallPersistence.class.getName());

            ReferenceRegistry.registerReference(CallUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(CallPersistence persistence) {
    }
}
