package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.BlsAe;

import java.util.List;

/**
 * The persistence utility for the bls ae service. This utility wraps {@link BlsAePersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BlsAePersistence
 * @see BlsAePersistenceImpl
 * @generated
 */
public class BlsAeUtil {
    private static BlsAePersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(BlsAe blsAe) {
        getPersistence().clearCache(blsAe);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<BlsAe> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<BlsAe> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<BlsAe> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static BlsAe update(BlsAe blsAe) throws SystemException {
        return getPersistence().update(blsAe);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static BlsAe update(BlsAe blsAe, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(blsAe, serviceContext);
    }

    /**
    * Returns the bls ae where areaNumber = &#63; or throws a {@link gov.va.caret.NoSuchBlsAeException} if it could not be found.
    *
    * @param areaNumber the area number
    * @return the matching bls ae
    * @throws gov.va.caret.NoSuchBlsAeException if a matching bls ae could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsAe findByNumber(int areaNumber)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsAeException {
        return getPersistence().findByNumber(areaNumber);
    }

    /**
    * Returns the bls ae where areaNumber = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param areaNumber the area number
    * @return the matching bls ae, or <code>null</code> if a matching bls ae could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsAe fetchByNumber(int areaNumber)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByNumber(areaNumber);
    }

    /**
    * Returns the bls ae where areaNumber = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param areaNumber the area number
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching bls ae, or <code>null</code> if a matching bls ae could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsAe fetchByNumber(int areaNumber,
        boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByNumber(areaNumber, retrieveFromCache);
    }

    /**
    * Removes the bls ae where areaNumber = &#63; from the database.
    *
    * @param areaNumber the area number
    * @return the bls ae that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsAe removeByNumber(int areaNumber)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsAeException {
        return getPersistence().removeByNumber(areaNumber);
    }

    /**
    * Returns the number of bls aes where areaNumber = &#63;.
    *
    * @param areaNumber the area number
    * @return the number of matching bls aes
    * @throws SystemException if a system exception occurred
    */
    public static int countByNumber(int areaNumber)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByNumber(areaNumber);
    }

    /**
    * Caches the bls ae in the entity cache if it is enabled.
    *
    * @param blsAe the bls ae
    */
    public static void cacheResult(gov.va.caret.model.BlsAe blsAe) {
        getPersistence().cacheResult(blsAe);
    }

    /**
    * Caches the bls aes in the entity cache if it is enabled.
    *
    * @param blsAes the bls aes
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.BlsAe> blsAes) {
        getPersistence().cacheResult(blsAes);
    }

    /**
    * Creates a new bls ae with the primary key. Does not add the bls ae to the database.
    *
    * @param blsAeId the primary key for the new bls ae
    * @return the new bls ae
    */
    public static gov.va.caret.model.BlsAe create(long blsAeId) {
        return getPersistence().create(blsAeId);
    }

    /**
    * Removes the bls ae with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param blsAeId the primary key of the bls ae
    * @return the bls ae that was removed
    * @throws gov.va.caret.NoSuchBlsAeException if a bls ae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsAe remove(long blsAeId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsAeException {
        return getPersistence().remove(blsAeId);
    }

    public static gov.va.caret.model.BlsAe updateImpl(
        gov.va.caret.model.BlsAe blsAe)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(blsAe);
    }

    /**
    * Returns the bls ae with the primary key or throws a {@link gov.va.caret.NoSuchBlsAeException} if it could not be found.
    *
    * @param blsAeId the primary key of the bls ae
    * @return the bls ae
    * @throws gov.va.caret.NoSuchBlsAeException if a bls ae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsAe findByPrimaryKey(long blsAeId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsAeException {
        return getPersistence().findByPrimaryKey(blsAeId);
    }

    /**
    * Returns the bls ae with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param blsAeId the primary key of the bls ae
    * @return the bls ae, or <code>null</code> if a bls ae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsAe fetchByPrimaryKey(long blsAeId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(blsAeId);
    }

    /**
    * Returns all the bls aes.
    *
    * @return the bls aes
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsAe> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the bls aes.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsAeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bls aes
    * @param end the upper bound of the range of bls aes (not inclusive)
    * @return the range of bls aes
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsAe> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the bls aes.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsAeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bls aes
    * @param end the upper bound of the range of bls aes (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of bls aes
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsAe> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the bls aes from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of bls aes.
    *
    * @return the number of bls aes
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static BlsAePersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (BlsAePersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    BlsAePersistence.class.getName());

            ReferenceRegistry.registerReference(BlsAeUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(BlsAePersistence persistence) {
    }
}
