package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.BgLae;

import java.util.List;

/**
 * The persistence utility for the bg lae service. This utility wraps {@link BgLaePersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgLaePersistence
 * @see BgLaePersistenceImpl
 * @generated
 */
public class BgLaeUtil {
    private static BgLaePersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(BgLae bgLae) {
        getPersistence().clearCache(bgLae);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<BgLae> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<BgLae> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<BgLae> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static BgLae update(BgLae bgLae) throws SystemException {
        return getPersistence().update(bgLae);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static BgLae update(BgLae bgLae, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(bgLae, serviceContext);
    }

    /**
    * Returns all the bg laes where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the matching bg laes
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgLae> findByBoxGroupCharAssociations(
        long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByBoxGroupCharAssociations(ownerId);
    }

    /**
    * Returns a range of all the bg laes where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg laes
    * @param end the upper bound of the range of bg laes (not inclusive)
    * @return the range of matching bg laes
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgLae> findByBoxGroupCharAssociations(
        long ownerId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByBoxGroupCharAssociations(ownerId, start, end);
    }

    /**
    * Returns an ordered range of all the bg laes where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg laes
    * @param end the upper bound of the range of bg laes (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bg laes
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgLae> findByBoxGroupCharAssociations(
        long ownerId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByBoxGroupCharAssociations(ownerId, start, end,
            orderByComparator);
    }

    /**
    * Returns the first bg lae in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg lae
    * @throws gov.va.caret.NoSuchBgLaeException if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae findByBoxGroupCharAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException {
        return getPersistence()
                   .findByBoxGroupCharAssociations_First(ownerId,
            orderByComparator);
    }

    /**
    * Returns the first bg lae in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg lae, or <code>null</code> if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae fetchByBoxGroupCharAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBoxGroupCharAssociations_First(ownerId,
            orderByComparator);
    }

    /**
    * Returns the last bg lae in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg lae
    * @throws gov.va.caret.NoSuchBgLaeException if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae findByBoxGroupCharAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException {
        return getPersistence()
                   .findByBoxGroupCharAssociations_Last(ownerId,
            orderByComparator);
    }

    /**
    * Returns the last bg lae in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg lae, or <code>null</code> if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae fetchByBoxGroupCharAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBoxGroupCharAssociations_Last(ownerId,
            orderByComparator);
    }

    /**
    * Returns the bg laes before and after the current bg lae in the ordered set where ownerId = &#63;.
    *
    * @param bgLaeId the primary key of the current bg lae
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bg lae
    * @throws gov.va.caret.NoSuchBgLaeException if a bg lae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae[] findByBoxGroupCharAssociations_PrevAndNext(
        long bgLaeId, long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException {
        return getPersistence()
                   .findByBoxGroupCharAssociations_PrevAndNext(bgLaeId,
            ownerId, orderByComparator);
    }

    /**
    * Removes all the bg laes where ownerId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByBoxGroupCharAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByBoxGroupCharAssociations(ownerId);
    }

    /**
    * Returns the number of bg laes where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the number of matching bg laes
    * @throws SystemException if a system exception occurred
    */
    public static int countByBoxGroupCharAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByBoxGroupCharAssociations(ownerId);
    }

    /**
    * Returns the bg lae where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgLaeException} if it could not be found.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg lae
    * @throws gov.va.caret.NoSuchBgLaeException if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae findByBgCharInst(long ownerId,
        long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException {
        return getPersistence().findByBgCharInst(ownerId, boxGpId);
    }

    /**
    * Returns the bg lae where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg lae, or <code>null</code> if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae fetchByBgCharInst(long ownerId,
        long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByBgCharInst(ownerId, boxGpId);
    }

    /**
    * Returns the bg lae where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching bg lae, or <code>null</code> if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae fetchByBgCharInst(long ownerId,
        long boxGpId, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBgCharInst(ownerId, boxGpId, retrieveFromCache);
    }

    /**
    * Removes the bg lae where ownerId = &#63; and boxGpId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the bg lae that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae removeByBgCharInst(long ownerId,
        long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException {
        return getPersistence().removeByBgCharInst(ownerId, boxGpId);
    }

    /**
    * Returns the number of bg laes where ownerId = &#63; and boxGpId = &#63;.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the number of matching bg laes
    * @throws SystemException if a system exception occurred
    */
    public static int countByBgCharInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByBgCharInst(ownerId, boxGpId);
    }

    /**
    * Caches the bg lae in the entity cache if it is enabled.
    *
    * @param bgLae the bg lae
    */
    public static void cacheResult(gov.va.caret.model.BgLae bgLae) {
        getPersistence().cacheResult(bgLae);
    }

    /**
    * Caches the bg laes in the entity cache if it is enabled.
    *
    * @param bgLaes the bg laes
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.BgLae> bgLaes) {
        getPersistence().cacheResult(bgLaes);
    }

    /**
    * Creates a new bg lae with the primary key. Does not add the bg lae to the database.
    *
    * @param bgLaeId the primary key for the new bg lae
    * @return the new bg lae
    */
    public static gov.va.caret.model.BgLae create(long bgLaeId) {
        return getPersistence().create(bgLaeId);
    }

    /**
    * Removes the bg lae with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param bgLaeId the primary key of the bg lae
    * @return the bg lae that was removed
    * @throws gov.va.caret.NoSuchBgLaeException if a bg lae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae remove(long bgLaeId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException {
        return getPersistence().remove(bgLaeId);
    }

    public static gov.va.caret.model.BgLae updateImpl(
        gov.va.caret.model.BgLae bgLae)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(bgLae);
    }

    /**
    * Returns the bg lae with the primary key or throws a {@link gov.va.caret.NoSuchBgLaeException} if it could not be found.
    *
    * @param bgLaeId the primary key of the bg lae
    * @return the bg lae
    * @throws gov.va.caret.NoSuchBgLaeException if a bg lae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae findByPrimaryKey(long bgLaeId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException {
        return getPersistence().findByPrimaryKey(bgLaeId);
    }

    /**
    * Returns the bg lae with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param bgLaeId the primary key of the bg lae
    * @return the bg lae, or <code>null</code> if a bg lae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BgLae fetchByPrimaryKey(long bgLaeId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(bgLaeId);
    }

    /**
    * Returns all the bg laes.
    *
    * @return the bg laes
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgLae> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the bg laes.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg laes
    * @param end the upper bound of the range of bg laes (not inclusive)
    * @return the range of bg laes
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgLae> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the bg laes.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg laes
    * @param end the upper bound of the range of bg laes (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of bg laes
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BgLae> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the bg laes from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of bg laes.
    *
    * @return the number of bg laes
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static BgLaePersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (BgLaePersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    BgLaePersistence.class.getName());

            ReferenceRegistry.registerReference(BgLaeUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(BgLaePersistence persistence) {
    }
}
