package gov.va.caret.service;

import com.liferay.portal.service.ServiceWrapper;

/**
 * Provides a wrapper for {@link BgNumLocalService}.
 *
 * @author caret
 * @see BgNumLocalService
 * @generated
 */
public class BgNumLocalServiceWrapper implements BgNumLocalService,
    ServiceWrapper<BgNumLocalService> {
    private BgNumLocalService _bgNumLocalService;

    public BgNumLocalServiceWrapper(BgNumLocalService bgNumLocalService) {
        _bgNumLocalService = bgNumLocalService;
    }

    /**
    * Adds the bg num to the database. Also notifies the appropriate model listeners.
    *
    * @param bgNum the bg num
    * @return the bg num that was added
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BgNum addBgNum(gov.va.caret.model.BgNum bgNum)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.addBgNum(bgNum);
    }

    /**
    * Creates a new bg num with the primary key. Does not add the bg num to the database.
    *
    * @param bgNumId the primary key for the new bg num
    * @return the new bg num
    */
    @Override
    public gov.va.caret.model.BgNum createBgNum(long bgNumId) {
        return _bgNumLocalService.createBgNum(bgNumId);
    }

    /**
    * Deletes the bg num with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param bgNumId the primary key of the bg num
    * @return the bg num that was removed
    * @throws PortalException if a bg num with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BgNum deleteBgNum(long bgNumId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.deleteBgNum(bgNumId);
    }

    /**
    * Deletes the bg num from the database. Also notifies the appropriate model listeners.
    *
    * @param bgNum the bg num
    * @return the bg num that was removed
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BgNum deleteBgNum(gov.va.caret.model.BgNum bgNum)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.deleteBgNum(bgNum);
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
        return _bgNumLocalService.dynamicQuery();
    }

    /**
    * Performs a dynamic query on the database and returns the matching rows.
    *
    * @param dynamicQuery the dynamic query
    * @return the matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.dynamicQuery(dynamicQuery);
    }

    /**
    * Performs a dynamic query on the database and returns a range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @return the range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.dynamicQuery(dynamicQuery, start, end);
    }

    /**
    * Performs a dynamic query on the database and returns an ordered range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.dynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.dynamicQueryCount(dynamicQuery);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @param projection the projection to apply to the query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
        com.liferay.portal.kernel.dao.orm.Projection projection)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.dynamicQueryCount(dynamicQuery, projection);
    }

    @Override
    public gov.va.caret.model.BgNum fetchBgNum(long bgNumId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.fetchBgNum(bgNumId);
    }

    /**
    * Returns the bg num with the primary key.
    *
    * @param bgNumId the primary key of the bg num
    * @return the bg num
    * @throws PortalException if a bg num with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BgNum getBgNum(long bgNumId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.getBgNum(bgNumId);
    }

    @Override
    public com.liferay.portal.model.PersistedModel getPersistedModel(
        java.io.Serializable primaryKeyObj)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.getPersistedModel(primaryKeyObj);
    }

    /**
    * Returns a range of all the bg nums.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg nums
    * @param end the upper bound of the range of bg nums (not inclusive)
    * @return the range of bg nums
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.util.List<gov.va.caret.model.BgNum> getBgNums(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.getBgNums(start, end);
    }

    /**
    * Returns the number of bg nums.
    *
    * @return the number of bg nums
    * @throws SystemException if a system exception occurred
    */
    @Override
    public int getBgNumsCount()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.getBgNumsCount();
    }

    /**
    * Updates the bg num in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
    *
    * @param bgNum the bg num
    * @return the bg num that was updated
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BgNum updateBgNum(gov.va.caret.model.BgNum bgNum)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgNumLocalService.updateBgNum(bgNum);
    }

    /**
    * Returns the Spring bean ID for this bean.
    *
    * @return the Spring bean ID for this bean
    */
    @Override
    public java.lang.String getBeanIdentifier() {
        return _bgNumLocalService.getBeanIdentifier();
    }

    /**
    * Sets the Spring bean ID for this bean.
    *
    * @param beanIdentifier the Spring bean ID for this bean
    */
    @Override
    public void setBeanIdentifier(java.lang.String beanIdentifier) {
        _bgNumLocalService.setBeanIdentifier(beanIdentifier);
    }

    @Override
    public java.lang.Object invokeMethod(java.lang.String name,
        java.lang.String[] parameterTypes, java.lang.Object[] arguments)
        throws java.lang.Throwable {
        return _bgNumLocalService.invokeMethod(name, parameterTypes, arguments);
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedService}
     */
    public BgNumLocalService getWrappedBgNumLocalService() {
        return _bgNumLocalService;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #setWrappedService}
     */
    public void setWrappedBgNumLocalService(BgNumLocalService bgNumLocalService) {
        _bgNumLocalService = bgNumLocalService;
    }

    @Override
    public BgNumLocalService getWrappedService() {
        return _bgNumLocalService;
    }

    @Override
    public void setWrappedService(BgNumLocalService bgNumLocalService) {
        _bgNumLocalService = bgNumLocalService;
    }
}
