package gov.va.caret.service;

import com.liferay.portal.service.ServiceWrapper;

/**
 * Provides a wrapper for {@link AssmtLocalService}.
 *
 * @author caret
 * @see AssmtLocalService
 * @generated
 */
public class AssmtLocalServiceWrapper implements AssmtLocalService,
    ServiceWrapper<AssmtLocalService> {
    private AssmtLocalService _assmtLocalService;

    public AssmtLocalServiceWrapper(AssmtLocalService assmtLocalService) {
        _assmtLocalService = assmtLocalService;
    }

    /**
    * Adds the assmt to the database. Also notifies the appropriate model listeners.
    *
    * @param assmt the assmt
    * @return the assmt that was added
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Assmt addAssmt(gov.va.caret.model.Assmt assmt)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.addAssmt(assmt);
    }

    /**
    * Creates a new assmt with the primary key. Does not add the assmt to the database.
    *
    * @param assmtId the primary key for the new assmt
    * @return the new assmt
    */
    @Override
    public gov.va.caret.model.Assmt createAssmt(long assmtId) {
        return _assmtLocalService.createAssmt(assmtId);
    }

    /**
    * Deletes the assmt with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param assmtId the primary key of the assmt
    * @return the assmt that was removed
    * @throws PortalException if a assmt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Assmt deleteAssmt(long assmtId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.deleteAssmt(assmtId);
    }

    /**
    * Deletes the assmt from the database. Also notifies the appropriate model listeners.
    *
    * @param assmt the assmt
    * @return the assmt that was removed
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Assmt deleteAssmt(gov.va.caret.model.Assmt assmt)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.deleteAssmt(assmt);
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
        return _assmtLocalService.dynamicQuery();
    }

    /**
    * Performs a dynamic query on the database and returns the matching rows.
    *
    * @param dynamicQuery the dynamic query
    * @return the matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.dynamicQuery(dynamicQuery);
    }

    /**
    * Performs a dynamic query on the database and returns a range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @return the range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.dynamicQuery(dynamicQuery, start, end);
    }

    /**
    * Performs a dynamic query on the database and returns an ordered range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.dynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.dynamicQueryCount(dynamicQuery);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @param projection the projection to apply to the query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
        com.liferay.portal.kernel.dao.orm.Projection projection)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.dynamicQueryCount(dynamicQuery, projection);
    }

    @Override
    public gov.va.caret.model.Assmt fetchAssmt(long assmtId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.fetchAssmt(assmtId);
    }

    /**
    * Returns the assmt with the primary key.
    *
    * @param assmtId the primary key of the assmt
    * @return the assmt
    * @throws PortalException if a assmt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Assmt getAssmt(long assmtId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.getAssmt(assmtId);
    }

    @Override
    public com.liferay.portal.model.PersistedModel getPersistedModel(
        java.io.Serializable primaryKeyObj)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.getPersistedModel(primaryKeyObj);
    }

    /**
    * Returns a range of all the assmts.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of assmts
    * @param end the upper bound of the range of assmts (not inclusive)
    * @return the range of assmts
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.util.List<gov.va.caret.model.Assmt> getAssmts(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.getAssmts(start, end);
    }

    /**
    * Returns the number of assmts.
    *
    * @return the number of assmts
    * @throws SystemException if a system exception occurred
    */
    @Override
    public int getAssmtsCount()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.getAssmtsCount();
    }

    /**
    * Updates the assmt in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
    *
    * @param assmt the assmt
    * @return the assmt that was updated
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Assmt updateAssmt(gov.va.caret.model.Assmt assmt)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _assmtLocalService.updateAssmt(assmt);
    }

    /**
    * Returns the Spring bean ID for this bean.
    *
    * @return the Spring bean ID for this bean
    */
    @Override
    public java.lang.String getBeanIdentifier() {
        return _assmtLocalService.getBeanIdentifier();
    }

    /**
    * Sets the Spring bean ID for this bean.
    *
    * @param beanIdentifier the Spring bean ID for this bean
    */
    @Override
    public void setBeanIdentifier(java.lang.String beanIdentifier) {
        _assmtLocalService.setBeanIdentifier(beanIdentifier);
    }

    @Override
    public java.lang.Object invokeMethod(java.lang.String name,
        java.lang.String[] parameterTypes, java.lang.Object[] arguments)
        throws java.lang.Throwable {
        return _assmtLocalService.invokeMethod(name, parameterTypes, arguments);
    }

    @Override
    public java.util.List<gov.va.caret.model.Assmt> findByVcgId(long vcgId)
        throws gov.va.caret.ApplicationWorkFlowException {
        return _assmtLocalService.findByVcgId(vcgId);
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedService}
     */
    public AssmtLocalService getWrappedAssmtLocalService() {
        return _assmtLocalService;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #setWrappedService}
     */
    public void setWrappedAssmtLocalService(AssmtLocalService assmtLocalService) {
        _assmtLocalService = assmtLocalService;
    }

    @Override
    public AssmtLocalService getWrappedService() {
        return _assmtLocalService;
    }

    @Override
    public void setWrappedService(AssmtLocalService assmtLocalService) {
        _assmtLocalService = assmtLocalService;
    }
}
