package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the ZipFy service. Represents a row in the &quot;CARET_FACILITY_ZIP&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.ZipFyModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.ZipFyImpl}.
 * </p>
 *
 * @author caret
 * @see ZipFy
 * @see gov.va.caret.model.impl.ZipFyImpl
 * @see gov.va.caret.model.impl.ZipFyModelImpl
 * @generated
 */
public interface ZipFyModel extends BaseModel<ZipFy> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a zip fy model instance should use the {@link ZipFy} interface instead.
     */

    /**
     * Returns the primary key of this zip fy.
     *
     * @return the primary key of this zip fy
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this zip fy.
     *
     * @param primaryKey the primary key of this zip fy
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the zip fy ID of this zip fy.
     *
     * @return the zip fy ID of this zip fy
     */
    public long getZipFyId();

    /**
     * Sets the zip fy ID of this zip fy.
     *
     * @param zipFyId the zip fy ID of this zip fy
     */
    public void setZipFyId(long zipFyId);

    /**
     * Returns the facil ID of this zip fy.
     *
     * @return the facil ID of this zip fy
     */
    public long getFacilId();

    /**
     * Sets the facil ID of this zip fy.
     *
     * @param facilId the facil ID of this zip fy
     */
    public void setFacilId(long facilId);

    /**
     * Returns the facil zip of this zip fy.
     *
     * @return the facil zip of this zip fy
     */
    @AutoEscape
    public String getFacilZip();

    /**
     * Sets the facil zip of this zip fy.
     *
     * @param facilZip the facil zip of this zip fy
     */
    public void setFacilZip(String facilZip);

    /**
     * Returns the distance of this zip fy.
     *
     * @return the distance of this zip fy
     */
    public double getDistance();

    /**
     * Sets the distance of this zip fy.
     *
     * @param distance the distance of this zip fy
     */
    public void setDistance(double distance);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.ZipFy zipFy);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.ZipFy> toCacheModel();

    @Override
    public gov.va.caret.model.ZipFy toEscapedModel();

    @Override
    public gov.va.caret.model.ZipFy toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
