package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.ZipFyLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class ZipFyClp extends BaseModelImpl<ZipFy> implements ZipFy {
    private long _zipFyId;
    private long _facilId;
    private String _facilZip;
    private double _distance;
    private BaseModel<?> _zipFyRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public ZipFyClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return ZipFy.class;
    }

    @Override
    public String getModelClassName() {
        return ZipFy.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _zipFyId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setZipFyId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _zipFyId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("zipFyId", getZipFyId());
        attributes.put("facilId", getFacilId());
        attributes.put("facilZip", getFacilZip());
        attributes.put("distance", getDistance());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long zipFyId = (Long) attributes.get("zipFyId");

        if (zipFyId != null) {
            setZipFyId(zipFyId);
        }

        Long facilId = (Long) attributes.get("facilId");

        if (facilId != null) {
            setFacilId(facilId);
        }

        String facilZip = (String) attributes.get("facilZip");

        if (facilZip != null) {
            setFacilZip(facilZip);
        }

        Double distance = (Double) attributes.get("distance");

        if (distance != null) {
            setDistance(distance);
        }
    }

    @Override
    public long getZipFyId() {
        return _zipFyId;
    }

    @Override
    public void setZipFyId(long zipFyId) {
        _zipFyId = zipFyId;

        if (_zipFyRemoteModel != null) {
            try {
                Class<?> clazz = _zipFyRemoteModel.getClass();

                Method method = clazz.getMethod("setZipFyId", long.class);

                method.invoke(_zipFyRemoteModel, zipFyId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getFacilId() {
        return _facilId;
    }

    @Override
    public void setFacilId(long facilId) {
        _facilId = facilId;

        if (_zipFyRemoteModel != null) {
            try {
                Class<?> clazz = _zipFyRemoteModel.getClass();

                Method method = clazz.getMethod("setFacilId", long.class);

                method.invoke(_zipFyRemoteModel, facilId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getFacilZip() {
        return _facilZip;
    }

    @Override
    public void setFacilZip(String facilZip) {
        _facilZip = facilZip;

        if (_zipFyRemoteModel != null) {
            try {
                Class<?> clazz = _zipFyRemoteModel.getClass();

                Method method = clazz.getMethod("setFacilZip", String.class);

                method.invoke(_zipFyRemoteModel, facilZip);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public double getDistance() {
        return _distance;
    }

    @Override
    public void setDistance(double distance) {
        _distance = distance;

        if (_zipFyRemoteModel != null) {
            try {
                Class<?> clazz = _zipFyRemoteModel.getClass();

                Method method = clazz.getMethod("setDistance", double.class);

                method.invoke(_zipFyRemoteModel, distance);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getZipFyRemoteModel() {
        return _zipFyRemoteModel;
    }

    public void setZipFyRemoteModel(BaseModel<?> zipFyRemoteModel) {
        _zipFyRemoteModel = zipFyRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _zipFyRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_zipFyRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            ZipFyLocalServiceUtil.addZipFy(this);
        } else {
            ZipFyLocalServiceUtil.updateZipFy(this);
        }
    }

    @Override
    public ZipFy toEscapedModel() {
        return (ZipFy) ProxyUtil.newProxyInstance(ZipFy.class.getClassLoader(),
            new Class[] { ZipFy.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        ZipFyClp clone = new ZipFyClp();

        clone.setZipFyId(getZipFyId());
        clone.setFacilId(getFacilId());
        clone.setFacilZip(getFacilZip());
        clone.setDistance(getDistance());

        return clone;
    }

    @Override
    public int compareTo(ZipFy zipFy) {
        long primaryKey = zipFy.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof ZipFyClp)) {
            return false;
        }

        ZipFyClp zipFy = (ZipFyClp) obj;

        long primaryKey = zipFy.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{zipFyId=");
        sb.append(getZipFyId());
        sb.append(", facilId=");
        sb.append(getFacilId());
        sb.append(", facilZip=");
        sb.append(getFacilZip());
        sb.append(", distance=");
        sb.append(getDistance());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.ZipFy");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>zipFyId</column-name><column-value><![CDATA[");
        sb.append(getZipFyId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>facilId</column-name><column-value><![CDATA[");
        sb.append(getFacilId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>facilZip</column-name><column-value><![CDATA[");
        sb.append(getFacilZip());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>distance</column-name><column-value><![CDATA[");
        sb.append(getDistance());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
