package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class WorImSoap implements Serializable {
    private long _worImId;
    private String _type;
    private long _classId;
    private long _classPk;
    private String _status;
    private Date _creationDate;
    private Date _dueDate;
    private Date _completionDate;
    private long _completionBy;
    private long _groupId;
    private long _userId;
    private long _caregiverId;
    private long _persnId;
    private long _queId;
    private long _vcgId;

    public WorImSoap() {
    }

    public static WorImSoap toSoapModel(WorIm model) {
        WorImSoap soapModel = new WorImSoap();

        soapModel.setWorImId(model.getWorImId());
        soapModel.setType(model.getType());
        soapModel.setClassId(model.getClassId());
        soapModel.setClassPk(model.getClassPk());
        soapModel.setStatus(model.getStatus());
        soapModel.setCreationDate(model.getCreationDate());
        soapModel.setDueDate(model.getDueDate());
        soapModel.setCompletionDate(model.getCompletionDate());
        soapModel.setCompletionBy(model.getCompletionBy());
        soapModel.setGroupId(model.getGroupId());
        soapModel.setUserId(model.getUserId());
        soapModel.setCaregiverId(model.getCaregiverId());
        soapModel.setPersnId(model.getPersnId());
        soapModel.setQueId(model.getQueId());
        soapModel.setVcgId(model.getVcgId());

        return soapModel;
    }

    public static WorImSoap[] toSoapModels(WorIm[] models) {
        WorImSoap[] soapModels = new WorImSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static WorImSoap[][] toSoapModels(WorIm[][] models) {
        WorImSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new WorImSoap[models.length][models[0].length];
        } else {
            soapModels = new WorImSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static WorImSoap[] toSoapModels(List<WorIm> models) {
        List<WorImSoap> soapModels = new ArrayList<WorImSoap>(models.size());

        for (WorIm model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new WorImSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _worImId;
    }

    public void setPrimaryKey(long pk) {
        setWorImId(pk);
    }

    public long getWorImId() {
        return _worImId;
    }

    public void setWorImId(long worImId) {
        _worImId = worImId;
    }

    public String getType() {
        return _type;
    }

    public void setType(String type) {
        _type = type;
    }

    public long getClassId() {
        return _classId;
    }

    public void setClassId(long classId) {
        _classId = classId;
    }

    public long getClassPk() {
        return _classPk;
    }

    public void setClassPk(long classPk) {
        _classPk = classPk;
    }

    public String getStatus() {
        return _status;
    }

    public void setStatus(String status) {
        _status = status;
    }

    public Date getCreationDate() {
        return _creationDate;
    }

    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    public Date getDueDate() {
        return _dueDate;
    }

    public void setDueDate(Date dueDate) {
        _dueDate = dueDate;
    }

    public Date getCompletionDate() {
        return _completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        _completionDate = completionDate;
    }

    public long getCompletionBy() {
        return _completionBy;
    }

    public void setCompletionBy(long completionBy) {
        _completionBy = completionBy;
    }

    public long getGroupId() {
        return _groupId;
    }

    public void setGroupId(long groupId) {
        _groupId = groupId;
    }

    public long getUserId() {
        return _userId;
    }

    public void setUserId(long userId) {
        _userId = userId;
    }

    public long getCaregiverId() {
        return _caregiverId;
    }

    public void setCaregiverId(long caregiverId) {
        _caregiverId = caregiverId;
    }

    public long getPersnId() {
        return _persnId;
    }

    public void setPersnId(long persnId) {
        _persnId = persnId;
    }

    public long getQueId() {
        return _queId;
    }

    public void setQueId(long queId) {
        _queId = queId;
    }

    public long getVcgId() {
        return _vcgId;
    }

    public void setVcgId(long vcgId) {
        _vcgId = vcgId;
    }
}
