package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Waivr service. Represents a row in the &quot;CARET_WAIVER&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.WaivrModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.WaivrImpl}.
 * </p>
 *
 * @author caret
 * @see Waivr
 * @see gov.va.caret.model.impl.WaivrImpl
 * @see gov.va.caret.model.impl.WaivrModelImpl
 * @generated
 */
public interface WaivrModel extends BaseModel<Waivr> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a waivr model instance should use the {@link Waivr} interface instead.
     */

    /**
     * Returns the primary key of this waivr.
     *
     * @return the primary key of this waivr
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this waivr.
     *
     * @param primaryKey the primary key of this waivr
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the waivr ID of this waivr.
     *
     * @return the waivr ID of this waivr
     */
    public long getWaivrId();

    /**
     * Sets the waivr ID of this waivr.
     *
     * @param waivrId the waivr ID of this waivr
     */
    public void setWaivrId(long waivrId);

    /**
     * Returns the class pk of this waivr.
     *
     * @return the class pk of this waivr
     */
    public long getClassPk();

    /**
     * Sets the class pk of this waivr.
     *
     * @param classPk the class pk of this waivr
     */
    public void setClassPk(long classPk);

    /**
     * Returns the adjudication of this waivr.
     *
     * @return the adjudication of this waivr
     */
    @AutoEscape
    public String getAdjudication();

    /**
     * Sets the adjudication of this waivr.
     *
     * @param adjudication the adjudication of this waivr
     */
    public void setAdjudication(String adjudication);

    /**
     * Returns the reason of this waivr.
     *
     * @return the reason of this waivr
     */
    @AutoEscape
    public String getReason();

    /**
     * Sets the reason of this waivr.
     *
     * @param reason the reason of this waivr
     */
    public void setReason(String reason);

    /**
     * Returns the note of this waivr.
     *
     * @return the note of this waivr
     */
    @AutoEscape
    public String getNote();

    /**
     * Sets the note of this waivr.
     *
     * @param note the note of this waivr
     */
    public void setNote(String note);

    /**
     * Returns the creation date of this waivr.
     *
     * @return the creation date of this waivr
     */
    public Date getCreationDate();

    /**
     * Sets the creation date of this waivr.
     *
     * @param creationDate the creation date of this waivr
     */
    public void setCreationDate(Date creationDate);

    /**
     * Returns the completion date of this waivr.
     *
     * @return the completion date of this waivr
     */
    public Date getCompletionDate();

    /**
     * Sets the completion date of this waivr.
     *
     * @param completionDate the completion date of this waivr
     */
    public void setCompletionDate(Date completionDate);

    /**
     * Returns the user ID of this waivr.
     *
     * @return the user ID of this waivr
     */
    public long getUserId();

    /**
     * Sets the user ID of this waivr.
     *
     * @param userId the user ID of this waivr
     */
    public void setUserId(long userId);

    /**
     * Returns the user uuid of this waivr.
     *
     * @return the user uuid of this waivr
     * @throws SystemException if a system exception occurred
     */
    public String getUserUuid() throws SystemException;

    /**
     * Sets the user uuid of this waivr.
     *
     * @param userUuid the user uuid of this waivr
     */
    public void setUserUuid(String userUuid);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Waivr waivr);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Waivr> toCacheModel();

    @Override
    public gov.va.caret.model.Waivr toEscapedModel();

    @Override
    public gov.va.caret.model.Waivr toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
