package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class VendrSoap implements Serializable {
    private long _vendrId;
    private String _lastName;
    private String _firstName;
    private String _middleName;
    private String _fedTaxId;
    private String _address;
    private String _address2;
    private String _city;
    private String _state;
    private String _zip;
    private String _phone;
    private String _phone2;
    private String _gracePeriod;
    private String _gracePeriodDuration;
    private String _directDepositInfo;
    private String _paymentMethod;
    private String _crypto1;
    private long _groupId;

    public VendrSoap() {
    }

    public static VendrSoap toSoapModel(Vendr model) {
        VendrSoap soapModel = new VendrSoap();

        soapModel.setVendrId(model.getVendrId());
        soapModel.setLastName(model.getLastName());
        soapModel.setFirstName(model.getFirstName());
        soapModel.setMiddleName(model.getMiddleName());
        soapModel.setFedTaxId(model.getFedTaxId());
        soapModel.setAddress(model.getAddress());
        soapModel.setAddress2(model.getAddress2());
        soapModel.setCity(model.getCity());
        soapModel.setState(model.getState());
        soapModel.setZip(model.getZip());
        soapModel.setPhone(model.getPhone());
        soapModel.setPhone2(model.getPhone2());
        soapModel.setGracePeriod(model.getGracePeriod());
        soapModel.setGracePeriodDuration(model.getGracePeriodDuration());
        soapModel.setDirectDepositInfo(model.getDirectDepositInfo());
        soapModel.setPaymentMethod(model.getPaymentMethod());
        soapModel.setCrypto1(model.getCrypto1());
        soapModel.setGroupId(model.getGroupId());

        return soapModel;
    }

    public static VendrSoap[] toSoapModels(Vendr[] models) {
        VendrSoap[] soapModels = new VendrSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static VendrSoap[][] toSoapModels(Vendr[][] models) {
        VendrSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new VendrSoap[models.length][models[0].length];
        } else {
            soapModels = new VendrSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static VendrSoap[] toSoapModels(List<Vendr> models) {
        List<VendrSoap> soapModels = new ArrayList<VendrSoap>(models.size());

        for (Vendr model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new VendrSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _vendrId;
    }

    public void setPrimaryKey(long pk) {
        setVendrId(pk);
    }

    public long getVendrId() {
        return _vendrId;
    }

    public void setVendrId(long vendrId) {
        _vendrId = vendrId;
    }

    public String getLastName() {
        return _lastName;
    }

    public void setLastName(String lastName) {
        _lastName = lastName;
    }

    public String getFirstName() {
        return _firstName;
    }

    public void setFirstName(String firstName) {
        _firstName = firstName;
    }

    public String getMiddleName() {
        return _middleName;
    }

    public void setMiddleName(String middleName) {
        _middleName = middleName;
    }

    public String getFedTaxId() {
        return _fedTaxId;
    }

    public void setFedTaxId(String fedTaxId) {
        _fedTaxId = fedTaxId;
    }

    public String getAddress() {
        return _address;
    }

    public void setAddress(String address) {
        _address = address;
    }

    public String getAddress2() {
        return _address2;
    }

    public void setAddress2(String address2) {
        _address2 = address2;
    }

    public String getCity() {
        return _city;
    }

    public void setCity(String city) {
        _city = city;
    }

    public String getState() {
        return _state;
    }

    public void setState(String state) {
        _state = state;
    }

    public String getZip() {
        return _zip;
    }

    public void setZip(String zip) {
        _zip = zip;
    }

    public String getPhone() {
        return _phone;
    }

    public void setPhone(String phone) {
        _phone = phone;
    }

    public String getPhone2() {
        return _phone2;
    }

    public void setPhone2(String phone2) {
        _phone2 = phone2;
    }

    public String getGracePeriod() {
        return _gracePeriod;
    }

    public void setGracePeriod(String gracePeriod) {
        _gracePeriod = gracePeriod;
    }

    public String getGracePeriodDuration() {
        return _gracePeriodDuration;
    }

    public void setGracePeriodDuration(String gracePeriodDuration) {
        _gracePeriodDuration = gracePeriodDuration;
    }

    public String getDirectDepositInfo() {
        return _directDepositInfo;
    }

    public void setDirectDepositInfo(String directDepositInfo) {
        _directDepositInfo = directDepositInfo;
    }

    public String getPaymentMethod() {
        return _paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        _paymentMethod = paymentMethod;
    }

    public String getCrypto1() {
        return _crypto1;
    }

    public void setCrypto1(String crypto1) {
        _crypto1 = crypto1;
    }

    public long getGroupId() {
        return _groupId;
    }

    public void setGroupId(long groupId) {
        _groupId = groupId;
    }
}
