package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Vcg}.
 * </p>
 *
 * @author caret
 * @see Vcg
 * @generated
 */
public class VcgWrapper implements Vcg, ModelWrapper<Vcg> {
    private Vcg _vcg;

    public VcgWrapper(Vcg vcg) {
        _vcg = vcg;
    }

    @Override
    public Class<?> getModelClass() {
        return Vcg.class;
    }

    @Override
    public String getModelClassName() {
        return Vcg.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("vcgId", getVcgId());
        attributes.put("veteranId", getVeteranId());
        attributes.put("status", getStatus());
        attributes.put("assessCompletionDate", getAssessCompletionDate());
        attributes.put("primaryTrainedDate", getPrimaryTrainedDate());
        attributes.put("visitationDate", getVisitationDate());
        attributes.put("primaryId", getPrimaryId());
        attributes.put("secondaryId", getSecondaryId());
        attributes.put("secondaryTwoId", getSecondaryTwoId());
        attributes.put("generalCaregiver", getGeneralCaregiver());
        attributes.put("primaryType", getPrimaryType());
        attributes.put("secondaryType", getSecondaryType());
        attributes.put("secondaryTwoType", getSecondaryTwoType());
        attributes.put("primaryDispositionDate", getPrimaryDispositionDate());
        attributes.put("secondaryDispositionDate", getSecondaryDispositionDate());
        attributes.put("secondaryTwoDispositionDate",
            getSecondaryTwoDispositionDate());
        attributes.put("tierLevel", getTierLevel());
        attributes.put("tierEffectiveDate", getTierEffectiveDate());
        attributes.put("veteranDispReason", getVeteranDispReason());
        attributes.put("primaryDispReason", getPrimaryDispReason());
        attributes.put("secondaryDispReason", getSecondaryDispReason());
        attributes.put("secondaryTwoDispReason", getSecondaryTwoDispReason());
        attributes.put("primaryRevocationDate", getPrimaryRevocationDate());
        attributes.put("secondaryRevocationDate", getSecondaryRevocationDate());
        attributes.put("secondaryTwoRevocationDate",
            getSecondaryTwoRevocationDate());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long vcgId = (Long) attributes.get("vcgId");

        if (vcgId != null) {
            setVcgId(vcgId);
        }

        Long veteranId = (Long) attributes.get("veteranId");

        if (veteranId != null) {
            setVeteranId(veteranId);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        Date assessCompletionDate = (Date) attributes.get(
                "assessCompletionDate");

        if (assessCompletionDate != null) {
            setAssessCompletionDate(assessCompletionDate);
        }

        Date primaryTrainedDate = (Date) attributes.get("primaryTrainedDate");

        if (primaryTrainedDate != null) {
            setPrimaryTrainedDate(primaryTrainedDate);
        }

        Date visitationDate = (Date) attributes.get("visitationDate");

        if (visitationDate != null) {
            setVisitationDate(visitationDate);
        }

        Long primaryId = (Long) attributes.get("primaryId");

        if (primaryId != null) {
            setPrimaryId(primaryId);
        }

        Long secondaryId = (Long) attributes.get("secondaryId");

        if (secondaryId != null) {
            setSecondaryId(secondaryId);
        }

        Long secondaryTwoId = (Long) attributes.get("secondaryTwoId");

        if (secondaryTwoId != null) {
            setSecondaryTwoId(secondaryTwoId);
        }

        Boolean generalCaregiver = (Boolean) attributes.get("generalCaregiver");

        if (generalCaregiver != null) {
            setGeneralCaregiver(generalCaregiver);
        }

        String primaryType = (String) attributes.get("primaryType");

        if (primaryType != null) {
            setPrimaryType(primaryType);
        }

        String secondaryType = (String) attributes.get("secondaryType");

        if (secondaryType != null) {
            setSecondaryType(secondaryType);
        }

        String secondaryTwoType = (String) attributes.get("secondaryTwoType");

        if (secondaryTwoType != null) {
            setSecondaryTwoType(secondaryTwoType);
        }

        Date primaryDispositionDate = (Date) attributes.get(
                "primaryDispositionDate");

        if (primaryDispositionDate != null) {
            setPrimaryDispositionDate(primaryDispositionDate);
        }

        Date secondaryDispositionDate = (Date) attributes.get(
                "secondaryDispositionDate");

        if (secondaryDispositionDate != null) {
            setSecondaryDispositionDate(secondaryDispositionDate);
        }

        Date secondaryTwoDispositionDate = (Date) attributes.get(
                "secondaryTwoDispositionDate");

        if (secondaryTwoDispositionDate != null) {
            setSecondaryTwoDispositionDate(secondaryTwoDispositionDate);
        }

        Integer tierLevel = (Integer) attributes.get("tierLevel");

        if (tierLevel != null) {
            setTierLevel(tierLevel);
        }

        Date tierEffectiveDate = (Date) attributes.get("tierEffectiveDate");

        if (tierEffectiveDate != null) {
            setTierEffectiveDate(tierEffectiveDate);
        }

        String veteranDispReason = (String) attributes.get("veteranDispReason");

        if (veteranDispReason != null) {
            setVeteranDispReason(veteranDispReason);
        }

        String primaryDispReason = (String) attributes.get("primaryDispReason");

        if (primaryDispReason != null) {
            setPrimaryDispReason(primaryDispReason);
        }

        String secondaryDispReason = (String) attributes.get(
                "secondaryDispReason");

        if (secondaryDispReason != null) {
            setSecondaryDispReason(secondaryDispReason);
        }

        String secondaryTwoDispReason = (String) attributes.get(
                "secondaryTwoDispReason");

        if (secondaryTwoDispReason != null) {
            setSecondaryTwoDispReason(secondaryTwoDispReason);
        }

        Date primaryRevocationDate = (Date) attributes.get(
                "primaryRevocationDate");

        if (primaryRevocationDate != null) {
            setPrimaryRevocationDate(primaryRevocationDate);
        }

        Date secondaryRevocationDate = (Date) attributes.get(
                "secondaryRevocationDate");

        if (secondaryRevocationDate != null) {
            setSecondaryRevocationDate(secondaryRevocationDate);
        }

        Date secondaryTwoRevocationDate = (Date) attributes.get(
                "secondaryTwoRevocationDate");

        if (secondaryTwoRevocationDate != null) {
            setSecondaryTwoRevocationDate(secondaryTwoRevocationDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    /**
    * Returns the primary key of this vcg.
    *
    * @return the primary key of this vcg
    */
    @Override
    public long getPrimaryKey() {
        return _vcg.getPrimaryKey();
    }

    /**
    * Sets the primary key of this vcg.
    *
    * @param primaryKey the primary key of this vcg
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _vcg.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the vcg ID of this vcg.
    *
    * @return the vcg ID of this vcg
    */
    @Override
    public long getVcgId() {
        return _vcg.getVcgId();
    }

    /**
    * Sets the vcg ID of this vcg.
    *
    * @param vcgId the vcg ID of this vcg
    */
    @Override
    public void setVcgId(long vcgId) {
        _vcg.setVcgId(vcgId);
    }

    /**
    * Returns the veteran ID of this vcg.
    *
    * @return the veteran ID of this vcg
    */
    @Override
    public long getVeteranId() {
        return _vcg.getVeteranId();
    }

    /**
    * Sets the veteran ID of this vcg.
    *
    * @param veteranId the veteran ID of this vcg
    */
    @Override
    public void setVeteranId(long veteranId) {
        _vcg.setVeteranId(veteranId);
    }

    /**
    * Returns the status of this vcg.
    *
    * @return the status of this vcg
    */
    @Override
    public java.lang.String getStatus() {
        return _vcg.getStatus();
    }

    /**
    * Sets the status of this vcg.
    *
    * @param status the status of this vcg
    */
    @Override
    public void setStatus(java.lang.String status) {
        _vcg.setStatus(status);
    }

    /**
    * Returns the assess completion date of this vcg.
    *
    * @return the assess completion date of this vcg
    */
    @Override
    public java.util.Date getAssessCompletionDate() {
        return _vcg.getAssessCompletionDate();
    }

    /**
    * Sets the assess completion date of this vcg.
    *
    * @param assessCompletionDate the assess completion date of this vcg
    */
    @Override
    public void setAssessCompletionDate(java.util.Date assessCompletionDate) {
        _vcg.setAssessCompletionDate(assessCompletionDate);
    }

    /**
    * Returns the primary trained date of this vcg.
    *
    * @return the primary trained date of this vcg
    */
    @Override
    public java.util.Date getPrimaryTrainedDate() {
        return _vcg.getPrimaryTrainedDate();
    }

    /**
    * Sets the primary trained date of this vcg.
    *
    * @param primaryTrainedDate the primary trained date of this vcg
    */
    @Override
    public void setPrimaryTrainedDate(java.util.Date primaryTrainedDate) {
        _vcg.setPrimaryTrainedDate(primaryTrainedDate);
    }

    /**
    * Returns the visitation date of this vcg.
    *
    * @return the visitation date of this vcg
    */
    @Override
    public java.util.Date getVisitationDate() {
        return _vcg.getVisitationDate();
    }

    /**
    * Sets the visitation date of this vcg.
    *
    * @param visitationDate the visitation date of this vcg
    */
    @Override
    public void setVisitationDate(java.util.Date visitationDate) {
        _vcg.setVisitationDate(visitationDate);
    }

    /**
    * Returns the primary ID of this vcg.
    *
    * @return the primary ID of this vcg
    */
    @Override
    public long getPrimaryId() {
        return _vcg.getPrimaryId();
    }

    /**
    * Sets the primary ID of this vcg.
    *
    * @param primaryId the primary ID of this vcg
    */
    @Override
    public void setPrimaryId(long primaryId) {
        _vcg.setPrimaryId(primaryId);
    }

    /**
    * Returns the secondary ID of this vcg.
    *
    * @return the secondary ID of this vcg
    */
    @Override
    public long getSecondaryId() {
        return _vcg.getSecondaryId();
    }

    /**
    * Sets the secondary ID of this vcg.
    *
    * @param secondaryId the secondary ID of this vcg
    */
    @Override
    public void setSecondaryId(long secondaryId) {
        _vcg.setSecondaryId(secondaryId);
    }

    /**
    * Returns the secondary two ID of this vcg.
    *
    * @return the secondary two ID of this vcg
    */
    @Override
    public long getSecondaryTwoId() {
        return _vcg.getSecondaryTwoId();
    }

    /**
    * Sets the secondary two ID of this vcg.
    *
    * @param secondaryTwoId the secondary two ID of this vcg
    */
    @Override
    public void setSecondaryTwoId(long secondaryTwoId) {
        _vcg.setSecondaryTwoId(secondaryTwoId);
    }

    /**
    * Returns the general caregiver of this vcg.
    *
    * @return the general caregiver of this vcg
    */
    @Override
    public boolean getGeneralCaregiver() {
        return _vcg.getGeneralCaregiver();
    }

    /**
    * Returns <code>true</code> if this vcg is general caregiver.
    *
    * @return <code>true</code> if this vcg is general caregiver; <code>false</code> otherwise
    */
    @Override
    public boolean isGeneralCaregiver() {
        return _vcg.isGeneralCaregiver();
    }

    /**
    * Sets whether this vcg is general caregiver.
    *
    * @param generalCaregiver the general caregiver of this vcg
    */
    @Override
    public void setGeneralCaregiver(boolean generalCaregiver) {
        _vcg.setGeneralCaregiver(generalCaregiver);
    }

    /**
    * Returns the primary type of this vcg.
    *
    * @return the primary type of this vcg
    */
    @Override
    public java.lang.String getPrimaryType() {
        return _vcg.getPrimaryType();
    }

    /**
    * Sets the primary type of this vcg.
    *
    * @param primaryType the primary type of this vcg
    */
    @Override
    public void setPrimaryType(java.lang.String primaryType) {
        _vcg.setPrimaryType(primaryType);
    }

    /**
    * Returns the secondary type of this vcg.
    *
    * @return the secondary type of this vcg
    */
    @Override
    public java.lang.String getSecondaryType() {
        return _vcg.getSecondaryType();
    }

    /**
    * Sets the secondary type of this vcg.
    *
    * @param secondaryType the secondary type of this vcg
    */
    @Override
    public void setSecondaryType(java.lang.String secondaryType) {
        _vcg.setSecondaryType(secondaryType);
    }

    /**
    * Returns the secondary two type of this vcg.
    *
    * @return the secondary two type of this vcg
    */
    @Override
    public java.lang.String getSecondaryTwoType() {
        return _vcg.getSecondaryTwoType();
    }

    /**
    * Sets the secondary two type of this vcg.
    *
    * @param secondaryTwoType the secondary two type of this vcg
    */
    @Override
    public void setSecondaryTwoType(java.lang.String secondaryTwoType) {
        _vcg.setSecondaryTwoType(secondaryTwoType);
    }

    /**
    * Returns the primary disposition date of this vcg.
    *
    * @return the primary disposition date of this vcg
    */
    @Override
    public java.util.Date getPrimaryDispositionDate() {
        return _vcg.getPrimaryDispositionDate();
    }

    /**
    * Sets the primary disposition date of this vcg.
    *
    * @param primaryDispositionDate the primary disposition date of this vcg
    */
    @Override
    public void setPrimaryDispositionDate(java.util.Date primaryDispositionDate) {
        _vcg.setPrimaryDispositionDate(primaryDispositionDate);
    }

    /**
    * Returns the secondary disposition date of this vcg.
    *
    * @return the secondary disposition date of this vcg
    */
    @Override
    public java.util.Date getSecondaryDispositionDate() {
        return _vcg.getSecondaryDispositionDate();
    }

    /**
    * Sets the secondary disposition date of this vcg.
    *
    * @param secondaryDispositionDate the secondary disposition date of this vcg
    */
    @Override
    public void setSecondaryDispositionDate(
        java.util.Date secondaryDispositionDate) {
        _vcg.setSecondaryDispositionDate(secondaryDispositionDate);
    }

    /**
    * Returns the secondary two disposition date of this vcg.
    *
    * @return the secondary two disposition date of this vcg
    */
    @Override
    public java.util.Date getSecondaryTwoDispositionDate() {
        return _vcg.getSecondaryTwoDispositionDate();
    }

    /**
    * Sets the secondary two disposition date of this vcg.
    *
    * @param secondaryTwoDispositionDate the secondary two disposition date of this vcg
    */
    @Override
    public void setSecondaryTwoDispositionDate(
        java.util.Date secondaryTwoDispositionDate) {
        _vcg.setSecondaryTwoDispositionDate(secondaryTwoDispositionDate);
    }

    /**
    * Returns the tier level of this vcg.
    *
    * @return the tier level of this vcg
    */
    @Override
    public int getTierLevel() {
        return _vcg.getTierLevel();
    }

    /**
    * Sets the tier level of this vcg.
    *
    * @param tierLevel the tier level of this vcg
    */
    @Override
    public void setTierLevel(int tierLevel) {
        _vcg.setTierLevel(tierLevel);
    }

    /**
    * Returns the tier effective date of this vcg.
    *
    * @return the tier effective date of this vcg
    */
    @Override
    public java.util.Date getTierEffectiveDate() {
        return _vcg.getTierEffectiveDate();
    }

    /**
    * Sets the tier effective date of this vcg.
    *
    * @param tierEffectiveDate the tier effective date of this vcg
    */
    @Override
    public void setTierEffectiveDate(java.util.Date tierEffectiveDate) {
        _vcg.setTierEffectiveDate(tierEffectiveDate);
    }

    /**
    * Returns the veteran disp reason of this vcg.
    *
    * @return the veteran disp reason of this vcg
    */
    @Override
    public java.lang.String getVeteranDispReason() {
        return _vcg.getVeteranDispReason();
    }

    /**
    * Sets the veteran disp reason of this vcg.
    *
    * @param veteranDispReason the veteran disp reason of this vcg
    */
    @Override
    public void setVeteranDispReason(java.lang.String veteranDispReason) {
        _vcg.setVeteranDispReason(veteranDispReason);
    }

    /**
    * Returns the primary disp reason of this vcg.
    *
    * @return the primary disp reason of this vcg
    */
    @Override
    public java.lang.String getPrimaryDispReason() {
        return _vcg.getPrimaryDispReason();
    }

    /**
    * Sets the primary disp reason of this vcg.
    *
    * @param primaryDispReason the primary disp reason of this vcg
    */
    @Override
    public void setPrimaryDispReason(java.lang.String primaryDispReason) {
        _vcg.setPrimaryDispReason(primaryDispReason);
    }

    /**
    * Returns the secondary disp reason of this vcg.
    *
    * @return the secondary disp reason of this vcg
    */
    @Override
    public java.lang.String getSecondaryDispReason() {
        return _vcg.getSecondaryDispReason();
    }

    /**
    * Sets the secondary disp reason of this vcg.
    *
    * @param secondaryDispReason the secondary disp reason of this vcg
    */
    @Override
    public void setSecondaryDispReason(java.lang.String secondaryDispReason) {
        _vcg.setSecondaryDispReason(secondaryDispReason);
    }

    /**
    * Returns the secondary two disp reason of this vcg.
    *
    * @return the secondary two disp reason of this vcg
    */
    @Override
    public java.lang.String getSecondaryTwoDispReason() {
        return _vcg.getSecondaryTwoDispReason();
    }

    /**
    * Sets the secondary two disp reason of this vcg.
    *
    * @param secondaryTwoDispReason the secondary two disp reason of this vcg
    */
    @Override
    public void setSecondaryTwoDispReason(
        java.lang.String secondaryTwoDispReason) {
        _vcg.setSecondaryTwoDispReason(secondaryTwoDispReason);
    }

    /**
    * Returns the primary revocation date of this vcg.
    *
    * @return the primary revocation date of this vcg
    */
    @Override
    public java.util.Date getPrimaryRevocationDate() {
        return _vcg.getPrimaryRevocationDate();
    }

    /**
    * Sets the primary revocation date of this vcg.
    *
    * @param primaryRevocationDate the primary revocation date of this vcg
    */
    @Override
    public void setPrimaryRevocationDate(java.util.Date primaryRevocationDate) {
        _vcg.setPrimaryRevocationDate(primaryRevocationDate);
    }

    /**
    * Returns the secondary revocation date of this vcg.
    *
    * @return the secondary revocation date of this vcg
    */
    @Override
    public java.util.Date getSecondaryRevocationDate() {
        return _vcg.getSecondaryRevocationDate();
    }

    /**
    * Sets the secondary revocation date of this vcg.
    *
    * @param secondaryRevocationDate the secondary revocation date of this vcg
    */
    @Override
    public void setSecondaryRevocationDate(
        java.util.Date secondaryRevocationDate) {
        _vcg.setSecondaryRevocationDate(secondaryRevocationDate);
    }

    /**
    * Returns the secondary two revocation date of this vcg.
    *
    * @return the secondary two revocation date of this vcg
    */
    @Override
    public java.util.Date getSecondaryTwoRevocationDate() {
        return _vcg.getSecondaryTwoRevocationDate();
    }

    /**
    * Sets the secondary two revocation date of this vcg.
    *
    * @param secondaryTwoRevocationDate the secondary two revocation date of this vcg
    */
    @Override
    public void setSecondaryTwoRevocationDate(
        java.util.Date secondaryTwoRevocationDate) {
        _vcg.setSecondaryTwoRevocationDate(secondaryTwoRevocationDate);
    }

    /**
    * Returns the group ID of this vcg.
    *
    * @return the group ID of this vcg
    */
    @Override
    public long getGroupId() {
        return _vcg.getGroupId();
    }

    /**
    * Sets the group ID of this vcg.
    *
    * @param groupId the group ID of this vcg
    */
    @Override
    public void setGroupId(long groupId) {
        _vcg.setGroupId(groupId);
    }

    @Override
    public boolean isNew() {
        return _vcg.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _vcg.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _vcg.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _vcg.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _vcg.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _vcg.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _vcg.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _vcg.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _vcg.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _vcg.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _vcg.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new VcgWrapper((Vcg) _vcg.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.Vcg vcg) {
        return _vcg.compareTo(vcg);
    }

    @Override
    public int hashCode() {
        return _vcg.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.Vcg> toCacheModel() {
        return _vcg.toCacheModel();
    }

    @Override
    public gov.va.caret.model.Vcg toEscapedModel() {
        return new VcgWrapper(_vcg.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.Vcg toUnescapedModel() {
        return new VcgWrapper(_vcg.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _vcg.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _vcg.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _vcg.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof VcgWrapper)) {
            return false;
        }

        VcgWrapper vcgWrapper = (VcgWrapper) obj;

        if (Validator.equals(_vcg, vcgWrapper._vcg)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public Vcg getWrappedVcg() {
        return _vcg;
    }

    @Override
    public Vcg getWrappedModel() {
        return _vcg;
    }

    @Override
    public void resetOriginalValues() {
        _vcg.resetOriginalValues();
    }
}
