package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Vcg service. Represents a row in the &quot;CareT_VCG&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.VcgModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.VcgImpl}.
 * </p>
 *
 * @author caret
 * @see Vcg
 * @see gov.va.caret.model.impl.VcgImpl
 * @see gov.va.caret.model.impl.VcgModelImpl
 * @generated
 */
public interface VcgModel extends BaseModel<Vcg> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a vcg model instance should use the {@link Vcg} interface instead.
     */

    /**
     * Returns the primary key of this vcg.
     *
     * @return the primary key of this vcg
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this vcg.
     *
     * @param primaryKey the primary key of this vcg
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the vcg ID of this vcg.
     *
     * @return the vcg ID of this vcg
     */
    public long getVcgId();

    /**
     * Sets the vcg ID of this vcg.
     *
     * @param vcgId the vcg ID of this vcg
     */
    public void setVcgId(long vcgId);

    /**
     * Returns the veteran ID of this vcg.
     *
     * @return the veteran ID of this vcg
     */
    public long getVeteranId();

    /**
     * Sets the veteran ID of this vcg.
     *
     * @param veteranId the veteran ID of this vcg
     */
    public void setVeteranId(long veteranId);

    /**
     * Returns the status of this vcg.
     *
     * @return the status of this vcg
     */
    @AutoEscape
    public String getStatus();

    /**
     * Sets the status of this vcg.
     *
     * @param status the status of this vcg
     */
    public void setStatus(String status);

    /**
     * Returns the assess completion date of this vcg.
     *
     * @return the assess completion date of this vcg
     */
    public Date getAssessCompletionDate();

    /**
     * Sets the assess completion date of this vcg.
     *
     * @param assessCompletionDate the assess completion date of this vcg
     */
    public void setAssessCompletionDate(Date assessCompletionDate);

    /**
     * Returns the primary trained date of this vcg.
     *
     * @return the primary trained date of this vcg
     */
    public Date getPrimaryTrainedDate();

    /**
     * Sets the primary trained date of this vcg.
     *
     * @param primaryTrainedDate the primary trained date of this vcg
     */
    public void setPrimaryTrainedDate(Date primaryTrainedDate);

    /**
     * Returns the visitation date of this vcg.
     *
     * @return the visitation date of this vcg
     */
    public Date getVisitationDate();

    /**
     * Sets the visitation date of this vcg.
     *
     * @param visitationDate the visitation date of this vcg
     */
    public void setVisitationDate(Date visitationDate);

    /**
     * Returns the primary ID of this vcg.
     *
     * @return the primary ID of this vcg
     */
    public long getPrimaryId();

    /**
     * Sets the primary ID of this vcg.
     *
     * @param primaryId the primary ID of this vcg
     */
    public void setPrimaryId(long primaryId);

    /**
     * Returns the secondary ID of this vcg.
     *
     * @return the secondary ID of this vcg
     */
    public long getSecondaryId();

    /**
     * Sets the secondary ID of this vcg.
     *
     * @param secondaryId the secondary ID of this vcg
     */
    public void setSecondaryId(long secondaryId);

    /**
     * Returns the secondary two ID of this vcg.
     *
     * @return the secondary two ID of this vcg
     */
    public long getSecondaryTwoId();

    /**
     * Sets the secondary two ID of this vcg.
     *
     * @param secondaryTwoId the secondary two ID of this vcg
     */
    public void setSecondaryTwoId(long secondaryTwoId);

    /**
     * Returns the general caregiver of this vcg.
     *
     * @return the general caregiver of this vcg
     */
    public boolean getGeneralCaregiver();

    /**
     * Returns <code>true</code> if this vcg is general caregiver.
     *
     * @return <code>true</code> if this vcg is general caregiver; <code>false</code> otherwise
     */
    public boolean isGeneralCaregiver();

    /**
     * Sets whether this vcg is general caregiver.
     *
     * @param generalCaregiver the general caregiver of this vcg
     */
    public void setGeneralCaregiver(boolean generalCaregiver);

    /**
     * Returns the primary type of this vcg.
     *
     * @return the primary type of this vcg
     */
    @AutoEscape
    public String getPrimaryType();

    /**
     * Sets the primary type of this vcg.
     *
     * @param primaryType the primary type of this vcg
     */
    public void setPrimaryType(String primaryType);

    /**
     * Returns the secondary type of this vcg.
     *
     * @return the secondary type of this vcg
     */
    @AutoEscape
    public String getSecondaryType();

    /**
     * Sets the secondary type of this vcg.
     *
     * @param secondaryType the secondary type of this vcg
     */
    public void setSecondaryType(String secondaryType);

    /**
     * Returns the secondary two type of this vcg.
     *
     * @return the secondary two type of this vcg
     */
    @AutoEscape
    public String getSecondaryTwoType();

    /**
     * Sets the secondary two type of this vcg.
     *
     * @param secondaryTwoType the secondary two type of this vcg
     */
    public void setSecondaryTwoType(String secondaryTwoType);

    /**
     * Returns the primary disposition date of this vcg.
     *
     * @return the primary disposition date of this vcg
     */
    public Date getPrimaryDispositionDate();

    /**
     * Sets the primary disposition date of this vcg.
     *
     * @param primaryDispositionDate the primary disposition date of this vcg
     */
    public void setPrimaryDispositionDate(Date primaryDispositionDate);

    /**
     * Returns the secondary disposition date of this vcg.
     *
     * @return the secondary disposition date of this vcg
     */
    public Date getSecondaryDispositionDate();

    /**
     * Sets the secondary disposition date of this vcg.
     *
     * @param secondaryDispositionDate the secondary disposition date of this vcg
     */
    public void setSecondaryDispositionDate(Date secondaryDispositionDate);

    /**
     * Returns the secondary two disposition date of this vcg.
     *
     * @return the secondary two disposition date of this vcg
     */
    public Date getSecondaryTwoDispositionDate();

    /**
     * Sets the secondary two disposition date of this vcg.
     *
     * @param secondaryTwoDispositionDate the secondary two disposition date of this vcg
     */
    public void setSecondaryTwoDispositionDate(Date secondaryTwoDispositionDate);

    /**
     * Returns the tier level of this vcg.
     *
     * @return the tier level of this vcg
     */
    public int getTierLevel();

    /**
     * Sets the tier level of this vcg.
     *
     * @param tierLevel the tier level of this vcg
     */
    public void setTierLevel(int tierLevel);

    /**
     * Returns the tier effective date of this vcg.
     *
     * @return the tier effective date of this vcg
     */
    public Date getTierEffectiveDate();

    /**
     * Sets the tier effective date of this vcg.
     *
     * @param tierEffectiveDate the tier effective date of this vcg
     */
    public void setTierEffectiveDate(Date tierEffectiveDate);

    /**
     * Returns the veteran disp reason of this vcg.
     *
     * @return the veteran disp reason of this vcg
     */
    @AutoEscape
    public String getVeteranDispReason();

    /**
     * Sets the veteran disp reason of this vcg.
     *
     * @param veteranDispReason the veteran disp reason of this vcg
     */
    public void setVeteranDispReason(String veteranDispReason);

    /**
     * Returns the primary disp reason of this vcg.
     *
     * @return the primary disp reason of this vcg
     */
    @AutoEscape
    public String getPrimaryDispReason();

    /**
     * Sets the primary disp reason of this vcg.
     *
     * @param primaryDispReason the primary disp reason of this vcg
     */
    public void setPrimaryDispReason(String primaryDispReason);

    /**
     * Returns the secondary disp reason of this vcg.
     *
     * @return the secondary disp reason of this vcg
     */
    @AutoEscape
    public String getSecondaryDispReason();

    /**
     * Sets the secondary disp reason of this vcg.
     *
     * @param secondaryDispReason the secondary disp reason of this vcg
     */
    public void setSecondaryDispReason(String secondaryDispReason);

    /**
     * Returns the secondary two disp reason of this vcg.
     *
     * @return the secondary two disp reason of this vcg
     */
    @AutoEscape
    public String getSecondaryTwoDispReason();

    /**
     * Sets the secondary two disp reason of this vcg.
     *
     * @param secondaryTwoDispReason the secondary two disp reason of this vcg
     */
    public void setSecondaryTwoDispReason(String secondaryTwoDispReason);

    /**
     * Returns the primary revocation date of this vcg.
     *
     * @return the primary revocation date of this vcg
     */
    public Date getPrimaryRevocationDate();

    /**
     * Sets the primary revocation date of this vcg.
     *
     * @param primaryRevocationDate the primary revocation date of this vcg
     */
    public void setPrimaryRevocationDate(Date primaryRevocationDate);

    /**
     * Returns the secondary revocation date of this vcg.
     *
     * @return the secondary revocation date of this vcg
     */
    public Date getSecondaryRevocationDate();

    /**
     * Sets the secondary revocation date of this vcg.
     *
     * @param secondaryRevocationDate the secondary revocation date of this vcg
     */
    public void setSecondaryRevocationDate(Date secondaryRevocationDate);

    /**
     * Returns the secondary two revocation date of this vcg.
     *
     * @return the secondary two revocation date of this vcg
     */
    public Date getSecondaryTwoRevocationDate();

    /**
     * Sets the secondary two revocation date of this vcg.
     *
     * @param secondaryTwoRevocationDate the secondary two revocation date of this vcg
     */
    public void setSecondaryTwoRevocationDate(Date secondaryTwoRevocationDate);

    /**
     * Returns the group ID of this vcg.
     *
     * @return the group ID of this vcg
     */
    public long getGroupId();

    /**
     * Sets the group ID of this vcg.
     *
     * @param groupId the group ID of this vcg
     */
    public void setGroupId(long groupId);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Vcg vcg);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Vcg> toCacheModel();

    @Override
    public gov.va.caret.model.Vcg toEscapedModel();

    @Override
    public gov.va.caret.model.Vcg toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
