package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.StiRdLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class StiRdClp extends BaseModelImpl<StiRd> implements StiRd {
    private long _stiRdId;
    private long _vcgAnId;
    private String _cscStatus;
    private Date _cscStatusDate;
    private String _cbopcStatus;
    private Date _cbopcStatusDate;
    private Date _creationDate;
    private long _userId;
    private String _userUuid;
    private long _groupId;
    private BaseModel<?> _stiRdRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public StiRdClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return StiRd.class;
    }

    @Override
    public String getModelClassName() {
        return StiRd.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _stiRdId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setStiRdId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _stiRdId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("stiRdId", getStiRdId());
        attributes.put("vcgAnId", getVcgAnId());
        attributes.put("cscStatus", getCscStatus());
        attributes.put("cscStatusDate", getCscStatusDate());
        attributes.put("cbopcStatus", getCbopcStatus());
        attributes.put("cbopcStatusDate", getCbopcStatusDate());
        attributes.put("creationDate", getCreationDate());
        attributes.put("userId", getUserId());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long stiRdId = (Long) attributes.get("stiRdId");

        if (stiRdId != null) {
            setStiRdId(stiRdId);
        }

        Long vcgAnId = (Long) attributes.get("vcgAnId");

        if (vcgAnId != null) {
            setVcgAnId(vcgAnId);
        }

        String cscStatus = (String) attributes.get("cscStatus");

        if (cscStatus != null) {
            setCscStatus(cscStatus);
        }

        Date cscStatusDate = (Date) attributes.get("cscStatusDate");

        if (cscStatusDate != null) {
            setCscStatusDate(cscStatusDate);
        }

        String cbopcStatus = (String) attributes.get("cbopcStatus");

        if (cbopcStatus != null) {
            setCbopcStatus(cbopcStatus);
        }

        Date cbopcStatusDate = (Date) attributes.get("cbopcStatusDate");

        if (cbopcStatusDate != null) {
            setCbopcStatusDate(cbopcStatusDate);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getStiRdId() {
        return _stiRdId;
    }

    @Override
    public void setStiRdId(long stiRdId) {
        _stiRdId = stiRdId;

        if (_stiRdRemoteModel != null) {
            try {
                Class<?> clazz = _stiRdRemoteModel.getClass();

                Method method = clazz.getMethod("setStiRdId", long.class);

                method.invoke(_stiRdRemoteModel, stiRdId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getVcgAnId() {
        return _vcgAnId;
    }

    @Override
    public void setVcgAnId(long vcgAnId) {
        _vcgAnId = vcgAnId;

        if (_stiRdRemoteModel != null) {
            try {
                Class<?> clazz = _stiRdRemoteModel.getClass();

                Method method = clazz.getMethod("setVcgAnId", long.class);

                method.invoke(_stiRdRemoteModel, vcgAnId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCscStatus() {
        return _cscStatus;
    }

    @Override
    public void setCscStatus(String cscStatus) {
        _cscStatus = cscStatus;

        if (_stiRdRemoteModel != null) {
            try {
                Class<?> clazz = _stiRdRemoteModel.getClass();

                Method method = clazz.getMethod("setCscStatus", String.class);

                method.invoke(_stiRdRemoteModel, cscStatus);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCscStatusDate() {
        return _cscStatusDate;
    }

    @Override
    public void setCscStatusDate(Date cscStatusDate) {
        _cscStatusDate = cscStatusDate;

        if (_stiRdRemoteModel != null) {
            try {
                Class<?> clazz = _stiRdRemoteModel.getClass();

                Method method = clazz.getMethod("setCscStatusDate", Date.class);

                method.invoke(_stiRdRemoteModel, cscStatusDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCbopcStatus() {
        return _cbopcStatus;
    }

    @Override
    public void setCbopcStatus(String cbopcStatus) {
        _cbopcStatus = cbopcStatus;

        if (_stiRdRemoteModel != null) {
            try {
                Class<?> clazz = _stiRdRemoteModel.getClass();

                Method method = clazz.getMethod("setCbopcStatus", String.class);

                method.invoke(_stiRdRemoteModel, cbopcStatus);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCbopcStatusDate() {
        return _cbopcStatusDate;
    }

    @Override
    public void setCbopcStatusDate(Date cbopcStatusDate) {
        _cbopcStatusDate = cbopcStatusDate;

        if (_stiRdRemoteModel != null) {
            try {
                Class<?> clazz = _stiRdRemoteModel.getClass();

                Method method = clazz.getMethod("setCbopcStatusDate", Date.class);

                method.invoke(_stiRdRemoteModel, cbopcStatusDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;

        if (_stiRdRemoteModel != null) {
            try {
                Class<?> clazz = _stiRdRemoteModel.getClass();

                Method method = clazz.getMethod("setCreationDate", Date.class);

                method.invoke(_stiRdRemoteModel, creationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;

        if (_stiRdRemoteModel != null) {
            try {
                Class<?> clazz = _stiRdRemoteModel.getClass();

                Method method = clazz.getMethod("setUserId", long.class);

                method.invoke(_stiRdRemoteModel, userId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;

        if (_stiRdRemoteModel != null) {
            try {
                Class<?> clazz = _stiRdRemoteModel.getClass();

                Method method = clazz.getMethod("setGroupId", long.class);

                method.invoke(_stiRdRemoteModel, groupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getStiRdRemoteModel() {
        return _stiRdRemoteModel;
    }

    public void setStiRdRemoteModel(BaseModel<?> stiRdRemoteModel) {
        _stiRdRemoteModel = stiRdRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _stiRdRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_stiRdRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            StiRdLocalServiceUtil.addStiRd(this);
        } else {
            StiRdLocalServiceUtil.updateStiRd(this);
        }
    }

    @Override
    public StiRd toEscapedModel() {
        return (StiRd) ProxyUtil.newProxyInstance(StiRd.class.getClassLoader(),
            new Class[] { StiRd.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        StiRdClp clone = new StiRdClp();

        clone.setStiRdId(getStiRdId());
        clone.setVcgAnId(getVcgAnId());
        clone.setCscStatus(getCscStatus());
        clone.setCscStatusDate(getCscStatusDate());
        clone.setCbopcStatus(getCbopcStatus());
        clone.setCbopcStatusDate(getCbopcStatusDate());
        clone.setCreationDate(getCreationDate());
        clone.setUserId(getUserId());
        clone.setGroupId(getGroupId());

        return clone;
    }

    @Override
    public int compareTo(StiRd stiRd) {
        long primaryKey = stiRd.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof StiRdClp)) {
            return false;
        }

        StiRdClp stiRd = (StiRdClp) obj;

        long primaryKey = stiRd.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(19);

        sb.append("{stiRdId=");
        sb.append(getStiRdId());
        sb.append(", vcgAnId=");
        sb.append(getVcgAnId());
        sb.append(", cscStatus=");
        sb.append(getCscStatus());
        sb.append(", cscStatusDate=");
        sb.append(getCscStatusDate());
        sb.append(", cbopcStatus=");
        sb.append(getCbopcStatus());
        sb.append(", cbopcStatusDate=");
        sb.append(getCbopcStatusDate());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(31);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.StiRd");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>stiRdId</column-name><column-value><![CDATA[");
        sb.append(getStiRdId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vcgAnId</column-name><column-value><![CDATA[");
        sb.append(getVcgAnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cscStatus</column-name><column-value><![CDATA[");
        sb.append(getCscStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cscStatusDate</column-name><column-value><![CDATA[");
        sb.append(getCscStatusDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cbopcStatus</column-name><column-value><![CDATA[");
        sb.append(getCbopcStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cbopcStatusDate</column-name><column-value><![CDATA[");
        sb.append(getCbopcStatusDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
