package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class FacilSoap implements Serializable {
    private long _facilId;
    private String _facilityNumber;
    private String _location;
    private long _groupId;

    public FacilSoap() {
    }

    public static FacilSoap toSoapModel(Facil model) {
        FacilSoap soapModel = new FacilSoap();

        soapModel.setFacilId(model.getFacilId());
        soapModel.setFacilityNumber(model.getFacilityNumber());
        soapModel.setLocation(model.getLocation());
        soapModel.setGroupId(model.getGroupId());

        return soapModel;
    }

    public static FacilSoap[] toSoapModels(Facil[] models) {
        FacilSoap[] soapModels = new FacilSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static FacilSoap[][] toSoapModels(Facil[][] models) {
        FacilSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new FacilSoap[models.length][models[0].length];
        } else {
            soapModels = new FacilSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static FacilSoap[] toSoapModels(List<Facil> models) {
        List<FacilSoap> soapModels = new ArrayList<FacilSoap>(models.size());

        for (Facil model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new FacilSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _facilId;
    }

    public void setPrimaryKey(long pk) {
        setFacilId(pk);
    }

    public long getFacilId() {
        return _facilId;
    }

    public void setFacilId(long facilId) {
        _facilId = facilId;
    }

    public String getFacilityNumber() {
        return _facilityNumber;
    }

    public void setFacilityNumber(String facilityNumber) {
        _facilityNumber = facilityNumber;
    }

    public String getLocation() {
        return _location;
    }

    public void setLocation(String location) {
        _location = location;
    }

    public long getGroupId() {
        return _groupId;
    }

    public void setGroupId(long groupId) {
        _groupId = groupId;
    }
}
