package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Cesp}.
 * </p>
 *
 * @author caret
 * @see Cesp
 * @generated
 */
public class CespWrapper implements Cesp, ModelWrapper<Cesp> {
    private Cesp _cesp;

    public CespWrapper(Cesp cesp) {
        _cesp = cesp;
    }

    @Override
    public Class<?> getModelClass() {
        return Cesp.class;
    }

    @Override
    public String getModelClassName() {
        return Cesp.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("cespId", getCespId());
        attributes.put("callId", getCallId());
        attributes.put("createdByPersnId", getCreatedByPersnId());
        attributes.put("creationDate", getCreationDate());
        attributes.put("step", getStep());
        attributes.put("status", getStatus());
        attributes.put("referredBy", getReferredBy());
        attributes.put("assignedCslPersnId", getAssignedCslPersnId());
        attributes.put("goals", getGoals());
        attributes.put("planProgressBarrier", getPlanProgressBarrier());
        attributes.put("cespClosed", getCespClosed());
        attributes.put("cespClosedReason", getCespClosedReason());
        attributes.put("goalsReached", getGoalsReached());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long cespId = (Long) attributes.get("cespId");

        if (cespId != null) {
            setCespId(cespId);
        }

        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        Long createdByPersnId = (Long) attributes.get("createdByPersnId");

        if (createdByPersnId != null) {
            setCreatedByPersnId(createdByPersnId);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        String step = (String) attributes.get("step");

        if (step != null) {
            setStep(step);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        String referredBy = (String) attributes.get("referredBy");

        if (referredBy != null) {
            setReferredBy(referredBy);
        }

        String assignedCslPersnId = (String) attributes.get(
                "assignedCslPersnId");

        if (assignedCslPersnId != null) {
            setAssignedCslPersnId(assignedCslPersnId);
        }

        String goals = (String) attributes.get("goals");

        if (goals != null) {
            setGoals(goals);
        }

        String planProgressBarrier = (String) attributes.get(
                "planProgressBarrier");

        if (planProgressBarrier != null) {
            setPlanProgressBarrier(planProgressBarrier);
        }

        String cespClosed = (String) attributes.get("cespClosed");

        if (cespClosed != null) {
            setCespClosed(cespClosed);
        }

        String cespClosedReason = (String) attributes.get("cespClosedReason");

        if (cespClosedReason != null) {
            setCespClosedReason(cespClosedReason);
        }

        String goalsReached = (String) attributes.get("goalsReached");

        if (goalsReached != null) {
            setGoalsReached(goalsReached);
        }
    }

    /**
    * Returns the primary key of this cesp.
    *
    * @return the primary key of this cesp
    */
    @Override
    public long getPrimaryKey() {
        return _cesp.getPrimaryKey();
    }

    /**
    * Sets the primary key of this cesp.
    *
    * @param primaryKey the primary key of this cesp
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _cesp.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the cesp ID of this cesp.
    *
    * @return the cesp ID of this cesp
    */
    @Override
    public long getCespId() {
        return _cesp.getCespId();
    }

    /**
    * Sets the cesp ID of this cesp.
    *
    * @param cespId the cesp ID of this cesp
    */
    @Override
    public void setCespId(long cespId) {
        _cesp.setCespId(cespId);
    }

    /**
    * Returns the call ID of this cesp.
    *
    * @return the call ID of this cesp
    */
    @Override
    public long getCallId() {
        return _cesp.getCallId();
    }

    /**
    * Sets the call ID of this cesp.
    *
    * @param callId the call ID of this cesp
    */
    @Override
    public void setCallId(long callId) {
        _cesp.setCallId(callId);
    }

    /**
    * Returns the created by persn ID of this cesp.
    *
    * @return the created by persn ID of this cesp
    */
    @Override
    public long getCreatedByPersnId() {
        return _cesp.getCreatedByPersnId();
    }

    /**
    * Sets the created by persn ID of this cesp.
    *
    * @param createdByPersnId the created by persn ID of this cesp
    */
    @Override
    public void setCreatedByPersnId(long createdByPersnId) {
        _cesp.setCreatedByPersnId(createdByPersnId);
    }

    /**
    * Returns the creation date of this cesp.
    *
    * @return the creation date of this cesp
    */
    @Override
    public java.util.Date getCreationDate() {
        return _cesp.getCreationDate();
    }

    /**
    * Sets the creation date of this cesp.
    *
    * @param creationDate the creation date of this cesp
    */
    @Override
    public void setCreationDate(java.util.Date creationDate) {
        _cesp.setCreationDate(creationDate);
    }

    /**
    * Returns the step of this cesp.
    *
    * @return the step of this cesp
    */
    @Override
    public java.lang.String getStep() {
        return _cesp.getStep();
    }

    /**
    * Sets the step of this cesp.
    *
    * @param step the step of this cesp
    */
    @Override
    public void setStep(java.lang.String step) {
        _cesp.setStep(step);
    }

    /**
    * Returns the status of this cesp.
    *
    * @return the status of this cesp
    */
    @Override
    public java.lang.String getStatus() {
        return _cesp.getStatus();
    }

    /**
    * Sets the status of this cesp.
    *
    * @param status the status of this cesp
    */
    @Override
    public void setStatus(java.lang.String status) {
        _cesp.setStatus(status);
    }

    /**
    * Returns the referred by of this cesp.
    *
    * @return the referred by of this cesp
    */
    @Override
    public java.lang.String getReferredBy() {
        return _cesp.getReferredBy();
    }

    /**
    * Sets the referred by of this cesp.
    *
    * @param referredBy the referred by of this cesp
    */
    @Override
    public void setReferredBy(java.lang.String referredBy) {
        _cesp.setReferredBy(referredBy);
    }

    /**
    * Returns the assigned csl persn ID of this cesp.
    *
    * @return the assigned csl persn ID of this cesp
    */
    @Override
    public java.lang.String getAssignedCslPersnId() {
        return _cesp.getAssignedCslPersnId();
    }

    /**
    * Sets the assigned csl persn ID of this cesp.
    *
    * @param assignedCslPersnId the assigned csl persn ID of this cesp
    */
    @Override
    public void setAssignedCslPersnId(java.lang.String assignedCslPersnId) {
        _cesp.setAssignedCslPersnId(assignedCslPersnId);
    }

    /**
    * Returns the goals of this cesp.
    *
    * @return the goals of this cesp
    */
    @Override
    public java.lang.String getGoals() {
        return _cesp.getGoals();
    }

    /**
    * Sets the goals of this cesp.
    *
    * @param goals the goals of this cesp
    */
    @Override
    public void setGoals(java.lang.String goals) {
        _cesp.setGoals(goals);
    }

    /**
    * Returns the plan progress barrier of this cesp.
    *
    * @return the plan progress barrier of this cesp
    */
    @Override
    public java.lang.String getPlanProgressBarrier() {
        return _cesp.getPlanProgressBarrier();
    }

    /**
    * Sets the plan progress barrier of this cesp.
    *
    * @param planProgressBarrier the plan progress barrier of this cesp
    */
    @Override
    public void setPlanProgressBarrier(java.lang.String planProgressBarrier) {
        _cesp.setPlanProgressBarrier(planProgressBarrier);
    }

    /**
    * Returns the cesp closed of this cesp.
    *
    * @return the cesp closed of this cesp
    */
    @Override
    public java.lang.String getCespClosed() {
        return _cesp.getCespClosed();
    }

    /**
    * Sets the cesp closed of this cesp.
    *
    * @param cespClosed the cesp closed of this cesp
    */
    @Override
    public void setCespClosed(java.lang.String cespClosed) {
        _cesp.setCespClosed(cespClosed);
    }

    /**
    * Returns the cesp closed reason of this cesp.
    *
    * @return the cesp closed reason of this cesp
    */
    @Override
    public java.lang.String getCespClosedReason() {
        return _cesp.getCespClosedReason();
    }

    /**
    * Sets the cesp closed reason of this cesp.
    *
    * @param cespClosedReason the cesp closed reason of this cesp
    */
    @Override
    public void setCespClosedReason(java.lang.String cespClosedReason) {
        _cesp.setCespClosedReason(cespClosedReason);
    }

    /**
    * Returns the goals reached of this cesp.
    *
    * @return the goals reached of this cesp
    */
    @Override
    public java.lang.String getGoalsReached() {
        return _cesp.getGoalsReached();
    }

    /**
    * Sets the goals reached of this cesp.
    *
    * @param goalsReached the goals reached of this cesp
    */
    @Override
    public void setGoalsReached(java.lang.String goalsReached) {
        _cesp.setGoalsReached(goalsReached);
    }

    @Override
    public boolean isNew() {
        return _cesp.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _cesp.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _cesp.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _cesp.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _cesp.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _cesp.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _cesp.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _cesp.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _cesp.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _cesp.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _cesp.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new CespWrapper((Cesp) _cesp.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.Cesp cesp) {
        return _cesp.compareTo(cesp);
    }

    @Override
    public int hashCode() {
        return _cesp.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.Cesp> toCacheModel() {
        return _cesp.toCacheModel();
    }

    @Override
    public gov.va.caret.model.Cesp toEscapedModel() {
        return new CespWrapper(_cesp.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.Cesp toUnescapedModel() {
        return new CespWrapper(_cesp.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _cesp.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _cesp.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _cesp.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof CespWrapper)) {
            return false;
        }

        CespWrapper cespWrapper = (CespWrapper) obj;

        if (Validator.equals(_cesp, cespWrapper._cesp)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public Cesp getWrappedCesp() {
        return _cesp;
    }

    @Override
    public Cesp getWrappedModel() {
        return _cesp;
    }

    @Override
    public void resetOriginalValues() {
        _cesp.resetOriginalValues();
    }
}
