package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class CallSoap implements Serializable {
    private long _callId;
    private String _callType;
    private String _callerRelationship;
    private long _workPrimaryKey;
    private String _callState;
    private long _callerPersnId;
    private String _callerTitle;
    private String _callerLearnAbout;
    private long _veteranPersnId;
    private String _message;
    private String _summary;
    private String _transferRemarks;
    private String _cespGoal;
    private String _cespOutcome;
    private String _transferredTo;
    private String _otherBenefits;
    private String _contactInfo;
    private String _eraService;
    private String _serviceBranch;
    private String _serviceStatus;
    private boolean _contactInfoProvided;
    private boolean _referralAgreeable;
    private boolean _withoutContact;
    private boolean _hangUp;
    private boolean _wrongNumber;
    private boolean _sameAddress;
    private boolean _enrolled;
    private boolean _dutyDischargeAfter911;
    private boolean _scCondition;
    private boolean _pcafcQaulified;
    private boolean _verified;
    private boolean _anonymous;
    private long _createGroupId;
    private long _userId;
    private Date _creationDate;
    private String _callbackPref;

    public CallSoap() {
    }

    public static CallSoap toSoapModel(Call model) {
        CallSoap soapModel = new CallSoap();

        soapModel.setCallId(model.getCallId());
        soapModel.setCallType(model.getCallType());
        soapModel.setCallerRelationship(model.getCallerRelationship());
        soapModel.setWorkPrimaryKey(model.getWorkPrimaryKey());
        soapModel.setCallState(model.getCallState());
        soapModel.setCallerPersnId(model.getCallerPersnId());
        soapModel.setCallerTitle(model.getCallerTitle());
        soapModel.setCallerLearnAbout(model.getCallerLearnAbout());
        soapModel.setVeteranPersnId(model.getVeteranPersnId());
        soapModel.setMessage(model.getMessage());
        soapModel.setSummary(model.getSummary());
        soapModel.setTransferRemarks(model.getTransferRemarks());
        soapModel.setCespGoal(model.getCespGoal());
        soapModel.setCespOutcome(model.getCespOutcome());
        soapModel.setTransferredTo(model.getTransferredTo());
        soapModel.setOtherBenefits(model.getOtherBenefits());
        soapModel.setContactInfo(model.getContactInfo());
        soapModel.setEraService(model.getEraService());
        soapModel.setServiceBranch(model.getServiceBranch());
        soapModel.setServiceStatus(model.getServiceStatus());
        soapModel.setContactInfoProvided(model.getContactInfoProvided());
        soapModel.setReferralAgreeable(model.getReferralAgreeable());
        soapModel.setWithoutContact(model.getWithoutContact());
        soapModel.setHangUp(model.getHangUp());
        soapModel.setWrongNumber(model.getWrongNumber());
        soapModel.setSameAddress(model.getSameAddress());
        soapModel.setEnrolled(model.getEnrolled());
        soapModel.setDutyDischargeAfter911(model.getDutyDischargeAfter911());
        soapModel.setScCondition(model.getScCondition());
        soapModel.setPcafcQaulified(model.getPcafcQaulified());
        soapModel.setVerified(model.getVerified());
        soapModel.setAnonymous(model.getAnonymous());
        soapModel.setCreateGroupId(model.getCreateGroupId());
        soapModel.setUserId(model.getUserId());
        soapModel.setCreationDate(model.getCreationDate());
        soapModel.setCallbackPref(model.getCallbackPref());

        return soapModel;
    }

    public static CallSoap[] toSoapModels(Call[] models) {
        CallSoap[] soapModels = new CallSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static CallSoap[][] toSoapModels(Call[][] models) {
        CallSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new CallSoap[models.length][models[0].length];
        } else {
            soapModels = new CallSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static CallSoap[] toSoapModels(List<Call> models) {
        List<CallSoap> soapModels = new ArrayList<CallSoap>(models.size());

        for (Call model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new CallSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _callId;
    }

    public void setPrimaryKey(long pk) {
        setCallId(pk);
    }

    public long getCallId() {
        return _callId;
    }

    public void setCallId(long callId) {
        _callId = callId;
    }

    public String getCallType() {
        return _callType;
    }

    public void setCallType(String callType) {
        _callType = callType;
    }

    public String getCallerRelationship() {
        return _callerRelationship;
    }

    public void setCallerRelationship(String callerRelationship) {
        _callerRelationship = callerRelationship;
    }

    public long getWorkPrimaryKey() {
        return _workPrimaryKey;
    }

    public void setWorkPrimaryKey(long workPrimaryKey) {
        _workPrimaryKey = workPrimaryKey;
    }

    public String getCallState() {
        return _callState;
    }

    public void setCallState(String callState) {
        _callState = callState;
    }

    public long getCallerPersnId() {
        return _callerPersnId;
    }

    public void setCallerPersnId(long callerPersnId) {
        _callerPersnId = callerPersnId;
    }

    public String getCallerTitle() {
        return _callerTitle;
    }

    public void setCallerTitle(String callerTitle) {
        _callerTitle = callerTitle;
    }

    public String getCallerLearnAbout() {
        return _callerLearnAbout;
    }

    public void setCallerLearnAbout(String callerLearnAbout) {
        _callerLearnAbout = callerLearnAbout;
    }

    public long getVeteranPersnId() {
        return _veteranPersnId;
    }

    public void setVeteranPersnId(long veteranPersnId) {
        _veteranPersnId = veteranPersnId;
    }

    public String getMessage() {
        return _message;
    }

    public void setMessage(String message) {
        _message = message;
    }

    public String getSummary() {
        return _summary;
    }

    public void setSummary(String summary) {
        _summary = summary;
    }

    public String getTransferRemarks() {
        return _transferRemarks;
    }

    public void setTransferRemarks(String transferRemarks) {
        _transferRemarks = transferRemarks;
    }

    public String getCespGoal() {
        return _cespGoal;
    }

    public void setCespGoal(String cespGoal) {
        _cespGoal = cespGoal;
    }

    public String getCespOutcome() {
        return _cespOutcome;
    }

    public void setCespOutcome(String cespOutcome) {
        _cespOutcome = cespOutcome;
    }

    public String getTransferredTo() {
        return _transferredTo;
    }

    public void setTransferredTo(String transferredTo) {
        _transferredTo = transferredTo;
    }

    public String getOtherBenefits() {
        return _otherBenefits;
    }

    public void setOtherBenefits(String otherBenefits) {
        _otherBenefits = otherBenefits;
    }

    public String getContactInfo() {
        return _contactInfo;
    }

    public void setContactInfo(String contactInfo) {
        _contactInfo = contactInfo;
    }

    public String getEraService() {
        return _eraService;
    }

    public void setEraService(String eraService) {
        _eraService = eraService;
    }

    public String getServiceBranch() {
        return _serviceBranch;
    }

    public void setServiceBranch(String serviceBranch) {
        _serviceBranch = serviceBranch;
    }

    public String getServiceStatus() {
        return _serviceStatus;
    }

    public void setServiceStatus(String serviceStatus) {
        _serviceStatus = serviceStatus;
    }

    public boolean getContactInfoProvided() {
        return _contactInfoProvided;
    }

    public boolean isContactInfoProvided() {
        return _contactInfoProvided;
    }

    public void setContactInfoProvided(boolean contactInfoProvided) {
        _contactInfoProvided = contactInfoProvided;
    }

    public boolean getReferralAgreeable() {
        return _referralAgreeable;
    }

    public boolean isReferralAgreeable() {
        return _referralAgreeable;
    }

    public void setReferralAgreeable(boolean referralAgreeable) {
        _referralAgreeable = referralAgreeable;
    }

    public boolean getWithoutContact() {
        return _withoutContact;
    }

    public boolean isWithoutContact() {
        return _withoutContact;
    }

    public void setWithoutContact(boolean withoutContact) {
        _withoutContact = withoutContact;
    }

    public boolean getHangUp() {
        return _hangUp;
    }

    public boolean isHangUp() {
        return _hangUp;
    }

    public void setHangUp(boolean hangUp) {
        _hangUp = hangUp;
    }

    public boolean getWrongNumber() {
        return _wrongNumber;
    }

    public boolean isWrongNumber() {
        return _wrongNumber;
    }

    public void setWrongNumber(boolean wrongNumber) {
        _wrongNumber = wrongNumber;
    }

    public boolean getSameAddress() {
        return _sameAddress;
    }

    public boolean isSameAddress() {
        return _sameAddress;
    }

    public void setSameAddress(boolean sameAddress) {
        _sameAddress = sameAddress;
    }

    public boolean getEnrolled() {
        return _enrolled;
    }

    public boolean isEnrolled() {
        return _enrolled;
    }

    public void setEnrolled(boolean enrolled) {
        _enrolled = enrolled;
    }

    public boolean getDutyDischargeAfter911() {
        return _dutyDischargeAfter911;
    }

    public boolean isDutyDischargeAfter911() {
        return _dutyDischargeAfter911;
    }

    public void setDutyDischargeAfter911(boolean dutyDischargeAfter911) {
        _dutyDischargeAfter911 = dutyDischargeAfter911;
    }

    public boolean getScCondition() {
        return _scCondition;
    }

    public boolean isScCondition() {
        return _scCondition;
    }

    public void setScCondition(boolean scCondition) {
        _scCondition = scCondition;
    }

    public boolean getPcafcQaulified() {
        return _pcafcQaulified;
    }

    public boolean isPcafcQaulified() {
        return _pcafcQaulified;
    }

    public void setPcafcQaulified(boolean pcafcQaulified) {
        _pcafcQaulified = pcafcQaulified;
    }

    public boolean getVerified() {
        return _verified;
    }

    public boolean isVerified() {
        return _verified;
    }

    public void setVerified(boolean verified) {
        _verified = verified;
    }

    public boolean getAnonymous() {
        return _anonymous;
    }

    public boolean isAnonymous() {
        return _anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        _anonymous = anonymous;
    }

    public long getCreateGroupId() {
        return _createGroupId;
    }

    public void setCreateGroupId(long createGroupId) {
        _createGroupId = createGroupId;
    }

    public long getUserId() {
        return _userId;
    }

    public void setUserId(long userId) {
        _userId = userId;
    }

    public Date getCreationDate() {
        return _creationDate;
    }

    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    public String getCallbackPref() {
        return _callbackPref;
    }

    public void setCallbackPref(String callbackPref) {
        _callbackPref = callbackPref;
    }
}
