package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the BlsAe service. Represents a row in the &quot;CARET_BLS_AREA&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.BlsAeModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.BlsAeImpl}.
 * </p>
 *
 * @author caret
 * @see BlsAe
 * @see gov.va.caret.model.impl.BlsAeImpl
 * @see gov.va.caret.model.impl.BlsAeModelImpl
 * @generated
 */
public interface BlsAeModel extends BaseModel<BlsAe> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a bls ae model instance should use the {@link BlsAe} interface instead.
     */

    /**
     * Returns the primary key of this bls ae.
     *
     * @return the primary key of this bls ae
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this bls ae.
     *
     * @param primaryKey the primary key of this bls ae
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the bls ae ID of this bls ae.
     *
     * @return the bls ae ID of this bls ae
     */
    public long getBlsAeId();

    /**
     * Sets the bls ae ID of this bls ae.
     *
     * @param blsAeId the bls ae ID of this bls ae
     */
    public void setBlsAeId(long blsAeId);

    /**
     * Returns the area name of this bls ae.
     *
     * @return the area name of this bls ae
     */
    @AutoEscape
    public String getAreaName();

    /**
     * Sets the area name of this bls ae.
     *
     * @param areaName the area name of this bls ae
     */
    public void setAreaName(String areaName);

    /**
     * Returns the area number of this bls ae.
     *
     * @return the area number of this bls ae
     */
    public int getAreaNumber();

    /**
     * Sets the area number of this bls ae.
     *
     * @param areaNumber the area number of this bls ae
     */
    public void setAreaNumber(int areaNumber);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.BlsAe blsAe);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.BlsAe> toCacheModel();

    @Override
    public gov.va.caret.model.BlsAe toEscapedModel();

    @Override
    public gov.va.caret.model.BlsAe toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
