package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.BlsAeLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class BlsAeClp extends BaseModelImpl<BlsAe> implements BlsAe {
    private long _blsAeId;
    private String _areaName;
    private int _areaNumber;
    private BaseModel<?> _blsAeRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public BlsAeClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return BlsAe.class;
    }

    @Override
    public String getModelClassName() {
        return BlsAe.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _blsAeId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBlsAeId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _blsAeId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("blsAeId", getBlsAeId());
        attributes.put("areaName", getAreaName());
        attributes.put("areaNumber", getAreaNumber());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long blsAeId = (Long) attributes.get("blsAeId");

        if (blsAeId != null) {
            setBlsAeId(blsAeId);
        }

        String areaName = (String) attributes.get("areaName");

        if (areaName != null) {
            setAreaName(areaName);
        }

        Integer areaNumber = (Integer) attributes.get("areaNumber");

        if (areaNumber != null) {
            setAreaNumber(areaNumber);
        }
    }

    @Override
    public long getBlsAeId() {
        return _blsAeId;
    }

    @Override
    public void setBlsAeId(long blsAeId) {
        _blsAeId = blsAeId;

        if (_blsAeRemoteModel != null) {
            try {
                Class<?> clazz = _blsAeRemoteModel.getClass();

                Method method = clazz.getMethod("setBlsAeId", long.class);

                method.invoke(_blsAeRemoteModel, blsAeId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getAreaName() {
        return _areaName;
    }

    @Override
    public void setAreaName(String areaName) {
        _areaName = areaName;

        if (_blsAeRemoteModel != null) {
            try {
                Class<?> clazz = _blsAeRemoteModel.getClass();

                Method method = clazz.getMethod("setAreaName", String.class);

                method.invoke(_blsAeRemoteModel, areaName);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public int getAreaNumber() {
        return _areaNumber;
    }

    @Override
    public void setAreaNumber(int areaNumber) {
        _areaNumber = areaNumber;

        if (_blsAeRemoteModel != null) {
            try {
                Class<?> clazz = _blsAeRemoteModel.getClass();

                Method method = clazz.getMethod("setAreaNumber", int.class);

                method.invoke(_blsAeRemoteModel, areaNumber);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getBlsAeRemoteModel() {
        return _blsAeRemoteModel;
    }

    public void setBlsAeRemoteModel(BaseModel<?> blsAeRemoteModel) {
        _blsAeRemoteModel = blsAeRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _blsAeRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_blsAeRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            BlsAeLocalServiceUtil.addBlsAe(this);
        } else {
            BlsAeLocalServiceUtil.updateBlsAe(this);
        }
    }

    @Override
    public BlsAe toEscapedModel() {
        return (BlsAe) ProxyUtil.newProxyInstance(BlsAe.class.getClassLoader(),
            new Class[] { BlsAe.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        BlsAeClp clone = new BlsAeClp();

        clone.setBlsAeId(getBlsAeId());
        clone.setAreaName(getAreaName());
        clone.setAreaNumber(getAreaNumber());

        return clone;
    }

    @Override
    public int compareTo(BlsAe blsAe) {
        int value = 0;

        if (getAreaNumber() < blsAe.getAreaNumber()) {
            value = -1;
        } else if (getAreaNumber() > blsAe.getAreaNumber()) {
            value = 1;
        } else {
            value = 0;
        }

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BlsAeClp)) {
            return false;
        }

        BlsAeClp blsAe = (BlsAeClp) obj;

        long primaryKey = blsAe.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(7);

        sb.append("{blsAeId=");
        sb.append(getBlsAeId());
        sb.append(", areaName=");
        sb.append(getAreaName());
        sb.append(", areaNumber=");
        sb.append(getAreaNumber());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(13);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BlsAe");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>blsAeId</column-name><column-value><![CDATA[");
        sb.append(getBlsAeId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>areaName</column-name><column-value><![CDATA[");
        sb.append(getAreaName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>areaNumber</column-name><column-value><![CDATA[");
        sb.append(getAreaNumber());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
