package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.BgNumLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class BgNumClp extends BaseModelImpl<BgNum> implements BgNum {
    private long _bgNumId;
    private long _ownerId;
    private long _boxGpId;
    private double _value;
    private BaseModel<?> _bgNumRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public BgNumClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return BgNum.class;
    }

    @Override
    public String getModelClassName() {
        return BgNum.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _bgNumId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBgNumId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _bgNumId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("bgNumId", getBgNumId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("boxGpId", getBoxGpId());
        attributes.put("value", getValue());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long bgNumId = (Long) attributes.get("bgNumId");

        if (bgNumId != null) {
            setBgNumId(bgNumId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        Long boxGpId = (Long) attributes.get("boxGpId");

        if (boxGpId != null) {
            setBoxGpId(boxGpId);
        }

        Double value = (Double) attributes.get("value");

        if (value != null) {
            setValue(value);
        }
    }

    @Override
    public long getBgNumId() {
        return _bgNumId;
    }

    @Override
    public void setBgNumId(long bgNumId) {
        _bgNumId = bgNumId;

        if (_bgNumRemoteModel != null) {
            try {
                Class<?> clazz = _bgNumRemoteModel.getClass();

                Method method = clazz.getMethod("setBgNumId", long.class);

                method.invoke(_bgNumRemoteModel, bgNumId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _ownerId = ownerId;

        if (_bgNumRemoteModel != null) {
            try {
                Class<?> clazz = _bgNumRemoteModel.getClass();

                Method method = clazz.getMethod("setOwnerId", long.class);

                method.invoke(_bgNumRemoteModel, ownerId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getBoxGpId() {
        return _boxGpId;
    }

    @Override
    public void setBoxGpId(long boxGpId) {
        _boxGpId = boxGpId;

        if (_bgNumRemoteModel != null) {
            try {
                Class<?> clazz = _bgNumRemoteModel.getClass();

                Method method = clazz.getMethod("setBoxGpId", long.class);

                method.invoke(_bgNumRemoteModel, boxGpId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public double getValue() {
        return _value;
    }

    @Override
    public void setValue(double value) {
        _value = value;

        if (_bgNumRemoteModel != null) {
            try {
                Class<?> clazz = _bgNumRemoteModel.getClass();

                Method method = clazz.getMethod("setValue", double.class);

                method.invoke(_bgNumRemoteModel, value);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getBgNumRemoteModel() {
        return _bgNumRemoteModel;
    }

    public void setBgNumRemoteModel(BaseModel<?> bgNumRemoteModel) {
        _bgNumRemoteModel = bgNumRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _bgNumRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_bgNumRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            BgNumLocalServiceUtil.addBgNum(this);
        } else {
            BgNumLocalServiceUtil.updateBgNum(this);
        }
    }

    @Override
    public BgNum toEscapedModel() {
        return (BgNum) ProxyUtil.newProxyInstance(BgNum.class.getClassLoader(),
            new Class[] { BgNum.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        BgNumClp clone = new BgNumClp();

        clone.setBgNumId(getBgNumId());
        clone.setOwnerId(getOwnerId());
        clone.setBoxGpId(getBoxGpId());
        clone.setValue(getValue());

        return clone;
    }

    @Override
    public int compareTo(BgNum bgNum) {
        long primaryKey = bgNum.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BgNumClp)) {
            return false;
        }

        BgNumClp bgNum = (BgNumClp) obj;

        long primaryKey = bgNum.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{bgNumId=");
        sb.append(getBgNumId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", boxGpId=");
        sb.append(getBoxGpId());
        sb.append(", value=");
        sb.append(getValue());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BgNum");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>bgNumId</column-name><column-value><![CDATA[");
        sb.append(getBgNumId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>boxGpId</column-name><column-value><![CDATA[");
        sb.append(getBoxGpId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>value</column-name><column-value><![CDATA[");
        sb.append(getValue());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
