/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.BgMemLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;

/**
 * @author caret
 */
public class BgMemClp extends BaseModelImpl<BgMem> implements BgMem {
	public BgMemClp() {
	}

	@Override
	public Class<?> getModelClass() {
		return BgMem.class;
	}

	@Override
	public String getModelClassName() {
		return BgMem.class.getName();
	}

	@Override
	public long getPrimaryKey() {
		return _bgMemId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setBgMemId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _bgMemId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("bgMemId", getBgMemId());
		attributes.put("ownerId", getOwnerId());
		attributes.put("boxGpId", getBoxGpId());
		attributes.put("mediumText", getMediumText());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long bgMemId = (Long)attributes.get("bgMemId");

		if (bgMemId != null) {
			setBgMemId(bgMemId);
		}

		Long ownerId = (Long)attributes.get("ownerId");

		if (ownerId != null) {
			setOwnerId(ownerId);
		}

		Long boxGpId = (Long)attributes.get("boxGpId");

		if (boxGpId != null) {
			setBoxGpId(boxGpId);
		}

		String mediumText = (String)attributes.get("mediumText");

		if (mediumText != null) {
			setMediumText(mediumText);
		}
	}

	@Override
	public long getBgMemId() {
		return _bgMemId;
	}

	@Override
	public void setBgMemId(long bgMemId) {
		_bgMemId = bgMemId;

		if (_bgMemRemoteModel != null) {
			try {
				Class<?> clazz = _bgMemRemoteModel.getClass();

				Method method = clazz.getMethod("setBgMemId", long.class);

				method.invoke(_bgMemRemoteModel, bgMemId);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public long getOwnerId() {
		return _ownerId;
	}

	@Override
	public void setOwnerId(long ownerId) {
		_ownerId = ownerId;

		if (_bgMemRemoteModel != null) {
			try {
				Class<?> clazz = _bgMemRemoteModel.getClass();

				Method method = clazz.getMethod("setOwnerId", long.class);

				method.invoke(_bgMemRemoteModel, ownerId);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public long getBoxGpId() {
		return _boxGpId;
	}

	@Override
	public void setBoxGpId(long boxGpId) {
		_boxGpId = boxGpId;

		if (_bgMemRemoteModel != null) {
			try {
				Class<?> clazz = _bgMemRemoteModel.getClass();

				Method method = clazz.getMethod("setBoxGpId", long.class);

				method.invoke(_bgMemRemoteModel, boxGpId);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public String getMediumText() {
		return _mediumText;
	}

	@Override
	public void setMediumText(String mediumText) {
		_mediumText = mediumText;

		if (_bgMemRemoteModel != null) {
			try {
				Class<?> clazz = _bgMemRemoteModel.getClass();

				Method method = clazz.getMethod("setMediumText", String.class);

				method.invoke(_bgMemRemoteModel, mediumText);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	public BaseModel<?> getBgMemRemoteModel() {
		return _bgMemRemoteModel;
	}

	public void setBgMemRemoteModel(BaseModel<?> bgMemRemoteModel) {
		_bgMemRemoteModel = bgMemRemoteModel;
	}

	public Object invokeOnRemoteModel(String methodName,
		Class<?>[] parameterTypes, Object[] parameterValues)
		throws Exception {
		Object[] remoteParameterValues = new Object[parameterValues.length];

		for (int i = 0; i < parameterValues.length; i++) {
			if (parameterValues[i] != null) {
				remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
			}
		}

		Class<?> remoteModelClass = _bgMemRemoteModel.getClass();

		ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

		Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

		for (int i = 0; i < parameterTypes.length; i++) {
			if (parameterTypes[i].isPrimitive()) {
				remoteParameterTypes[i] = parameterTypes[i];
			}
			else {
				String parameterTypeName = parameterTypes[i].getName();

				remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
			}
		}

		Method method = remoteModelClass.getMethod(methodName,
				remoteParameterTypes);

		Object returnValue = method.invoke(_bgMemRemoteModel,
				remoteParameterValues);

		if (returnValue != null) {
			returnValue = ClpSerializer.translateOutput(returnValue);
		}

		return returnValue;
	}

	@Override
	public void persist() throws SystemException {
		if (this.isNew()) {
			BgMemLocalServiceUtil.addBgMem(this);
		}
		else {
			BgMemLocalServiceUtil.updateBgMem(this);
		}
	}

	@Override
	public BgMem toEscapedModel() {
		return (BgMem)ProxyUtil.newProxyInstance(BgMem.class.getClassLoader(),
			new Class[] { BgMem.class }, new AutoEscapeBeanHandler(this));
	}

	@Override
	public Object clone() {
		BgMemClp clone = new BgMemClp();

		clone.setBgMemId(getBgMemId());
		clone.setOwnerId(getOwnerId());
		clone.setBoxGpId(getBoxGpId());
		clone.setMediumText(getMediumText());

		return clone;
	}

	@Override
	public int compareTo(BgMem bgMem) {
		long primaryKey = bgMem.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof BgMemClp)) {
			return false;
		}

		BgMemClp bgMem = (BgMemClp)obj;

		long primaryKey = bgMem.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	public Class<?> getClpSerializerClass() {
		return _clpSerializerClass;
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(9);

		sb.append("{bgMemId=");
		sb.append(getBgMemId());
		sb.append(", ownerId=");
		sb.append(getOwnerId());
		sb.append(", boxGpId=");
		sb.append(getBoxGpId());
		sb.append(", mediumText=");
		sb.append(getMediumText());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(16);

		sb.append("<model><model-name>");
		sb.append("gov.va.caret.model.BgMem");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>bgMemId</column-name><column-value><![CDATA[");
		sb.append(getBgMemId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ownerId</column-name><column-value><![CDATA[");
		sb.append(getOwnerId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>boxGpId</column-name><column-value><![CDATA[");
		sb.append(getBoxGpId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>mediumText</column-name><column-value><![CDATA[");
		sb.append(getMediumText());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private long _bgMemId;
	private long _ownerId;
	private long _boxGpId;
	private String _mediumText;
	private BaseModel<?> _bgMemRemoteModel;
	private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;
}