package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the BgLae service. Represents a row in the &quot;CARET_BOXED_GROUP_CHAR&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.BgLaeModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.BgLaeImpl}.
 * </p>
 *
 * @author caret
 * @see BgLae
 * @see gov.va.caret.model.impl.BgLaeImpl
 * @see gov.va.caret.model.impl.BgLaeModelImpl
 * @generated
 */
public interface BgLaeModel extends BaseModel<BgLae> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a bg lae model instance should use the {@link BgLae} interface instead.
     */

    /**
     * Returns the primary key of this bg lae.
     *
     * @return the primary key of this bg lae
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this bg lae.
     *
     * @param primaryKey the primary key of this bg lae
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the bg lae ID of this bg lae.
     *
     * @return the bg lae ID of this bg lae
     */
    public long getBgLaeId();

    /**
     * Sets the bg lae ID of this bg lae.
     *
     * @param bgLaeId the bg lae ID of this bg lae
     */
    public void setBgLaeId(long bgLaeId);

    /**
     * Returns the owner ID of this bg lae.
     *
     * @return the owner ID of this bg lae
     */
    public long getOwnerId();

    /**
     * Sets the owner ID of this bg lae.
     *
     * @param ownerId the owner ID of this bg lae
     */
    public void setOwnerId(long ownerId);

    /**
     * Returns the box gp ID of this bg lae.
     *
     * @return the box gp ID of this bg lae
     */
    public long getBoxGpId();

    /**
     * Sets the box gp ID of this bg lae.
     *
     * @param boxGpId the box gp ID of this bg lae
     */
    public void setBoxGpId(long boxGpId);

    /**
     * Returns the large text of this bg lae.
     *
     * @return the large text of this bg lae
     */
    @AutoEscape
    public String getLargeText();

    /**
     * Sets the large text of this bg lae.
     *
     * @param largeText the large text of this bg lae
     */
    public void setLargeText(String largeText);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.BgLae bgLae);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.BgLae> toCacheModel();

    @Override
    public gov.va.caret.model.BgLae toEscapedModel();

    @Override
    public gov.va.caret.model.BgLae toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
