package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class BgAsnSoap implements Serializable {
    private long _bgAsnId;
    private long _ownerId;
    private long _boxGpId;
    private boolean _selected;

    public BgAsnSoap() {
    }

    public static BgAsnSoap toSoapModel(BgAsn model) {
        BgAsnSoap soapModel = new BgAsnSoap();

        soapModel.setBgAsnId(model.getBgAsnId());
        soapModel.setOwnerId(model.getOwnerId());
        soapModel.setBoxGpId(model.getBoxGpId());
        soapModel.setSelected(model.getSelected());

        return soapModel;
    }

    public static BgAsnSoap[] toSoapModels(BgAsn[] models) {
        BgAsnSoap[] soapModels = new BgAsnSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static BgAsnSoap[][] toSoapModels(BgAsn[][] models) {
        BgAsnSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new BgAsnSoap[models.length][models[0].length];
        } else {
            soapModels = new BgAsnSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static BgAsnSoap[] toSoapModels(List<BgAsn> models) {
        List<BgAsnSoap> soapModels = new ArrayList<BgAsnSoap>(models.size());

        for (BgAsn model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new BgAsnSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _bgAsnId;
    }

    public void setPrimaryKey(long pk) {
        setBgAsnId(pk);
    }

    public long getBgAsnId() {
        return _bgAsnId;
    }

    public void setBgAsnId(long bgAsnId) {
        _bgAsnId = bgAsnId;
    }

    public long getOwnerId() {
        return _ownerId;
    }

    public void setOwnerId(long ownerId) {
        _ownerId = ownerId;
    }

    public long getBoxGpId() {
        return _boxGpId;
    }

    public void setBoxGpId(long boxGpId) {
        _boxGpId = boxGpId;
    }

    public boolean getSelected() {
        return _selected;
    }

    public boolean isSelected() {
        return _selected;
    }

    public void setSelected(boolean selected) {
        _selected = selected;
    }
}
