<%@include file="/jsp/init.jsp" %>

<style>
	.sectionHeading{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.section{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.summaryTable table, th, td{
	    border: thin solid #d9d9d9;
	    border-collapse: collapse;
	    margin: 12px;
	    padding: 5px;
	    text-align: center;
	}
	.summaryTable tr:hover {
		background-color: #f5f5f5;
	}
	.summaryTable th {
	    background-color: #f0efef;
	}
	.manage-layout-td text{
		/* width: 840px; */
		width: 67px;
		padding-left: 10px;
	}
	.manage-layout-td textarea{
		/* width: 840px; */
		width: 767px;
		padding-left: 10px;
	}
</style>	
 	
	<c:set var="form_" value="${caretMap_['form_']}" />
 	
 	<c:set var="vcgAn" value="${form_['vcgAn']}" />
 	<c:set var="vcg" value="${form_['vcg']}" />
 	<c:set var="veteranPersn" value="${form_['veteranPersn']}" />
 	<c:set var="primaryPersn" value="${form_['primaryPersn']}" />
 	<c:set var="secondaryPersn" value="${form_['secondaryPersn']}" />
 	<c:set var="secondaryTwoPersn" value="${form_['secondaryTwoPersn']}" />
 	
	<c:set var="editAction" value="edit-vcg-entry icon-pencil" />
	<c:set var="auditLog" value="audit-vcg-entry icon-time" />
	<c:set var="title" value="click-to-begin-changes" />
	<c:set var="message" value="edit-vcg" />
	

 	<c:set var="veteranId" value="${form_['veteranId']}" />
 	<c:set var="primaryValidAppDate" value="${form_['primaryValidAppDate']}" />
 	<c:set var="secondaryValidAppDate" value="${form_['secondaryValidAppDate']}" />
 	<c:set var="secondaryTwoValidAppDate" value="${form_['secondaryTwoValidAppDate']}" />
 	<c:set var="primaryApplicationId" value="${form_['primaryApplicationId']}" />
 	<c:set var="secondaryApplicationId" value="${form_['secondaryApplicationId']}" />
 	<c:set var="secondaryTwoApplicationId" value="${form_['secondaryTwoApplicationId']}" />
	
	
	
<div class="menu-wrapper">
<aui:nav cssClass="menu-field">
     <aui:nav-item href="javascript:" iconCssClass="icon-plus" label="new-assessment" id="scheduleAssessment" >
     </aui:nav-item>
</aui:nav>
</div>	
	
<div class="vcg-record">
<fieldset>
<legend>VCG Record</legend>
 	<div class="select-caregiver" >
		<div class="person-selection">
			<div class="vcg-entry-menu" id="${veteranPersn.primaryKey}" >
				<div class="float-left">
					<a class="btn-link ${editAction} btn-primary" title="<liferay-ui:message key="${title}" />" >&nbsp;<liferay-ui:message key="edit-vcg-veteran" /></a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title="<liferay-ui:message key="audit-log" />" >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<div class="center-position">
				<div class="care-giver-name" id="update_veteran">
					<c:if test="${! empty veteranPersn}">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			${veteranPersn.lastName}, ${veteranPersn.firstName} ${veteranPersn.middleName} 
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			Facility: ${veteranPersn.facilityName} 
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			Status:<liferay-ui:message key="${vcg.veteranDispReason}" />
				    			</div>
				    			<hr/>
				    			<div class="selected-vcg-row">
				    	 			Gender: <liferay-ui:message key="${veteranPersn.gender}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			ICN:${veteranPersn.icn}
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			SSN: ${veteranPersn.ssn}
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<fmt:formatDate value="${veteranPersn.birthDate}" var="vbday" type="date" pattern="MM/dd/yyyy"/>
				    	 			DOB: ${vbday}
				    			</div>
				    			<div class="selected-vcg-row">
				    				VA Health Enrolled: <liferay-ui:message key="${vcgAn['vaHealthEnrolled']}-yes" />
				    			</div>
				    			<hr/>
				    			<div class="selected-vcg-row">
				    				${veteranPersn.address}
				    			</div>
				    			<div class="selected-vcg-row">
				    				${veteranPersn.city}, ${veteranPersn.state} ${veteranPersn.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				${veteranPersn.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				${veteranPersn.phone}  ${veteranPersn.phone2} 
				    			</div>
				    		</div>
			    		</div>
		    		</c:if>
				</div>
			</div>
		</div>
	</div>
	
	<div class="select-caregiver" >
		<div class="person-selection">
			<div class="vcg-entry-menu" id="${primaryPersn.primaryKey}" >
				<div class="float-left">
					<a class="btn-link ${editAction} btn-primary" title="<liferay-ui:message key="${title}" />" >&nbsp;
						<c:choose>
							<c:when test="${vcg.generalCaregiver}">
								<liferay-ui:message key="edit-vcg-general" />
							</c:when>
							<c:otherwise>
								<liferay-ui:message key="edit-vcg-primary" />
							</c:otherwise>
						</c:choose>
					</a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title="<liferay-ui:message key="audit-log" />"  >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<div class="center-position">
				<div class="care-giver-name" id="update_primary">
					<c:if test="${! empty primaryPersn}">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			${primaryPersn.lastName}, ${primaryPersn.firstName} ${primaryPersn.middleName} 
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			Relationship to Veteran:<liferay-ui:message key="${vcg.primaryType}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			Tier:<liferay-ui:message key="tier-level-${vcg.tierLevel}" /> ${vcg.tierEffectiveDate}
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			Status:<liferay-ui:message key="status-${vcg.primaryDispReason}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			General Caregiver:<liferay-ui:message key="${vcg.generalCaregiver ? 'Yes' : 'No'}" />
				    			</div>
				    			<hr/>
				    			<div class="selected-vcg-row">
				    	 			Gender: <liferay-ui:message key="${primaryPersn.gender}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			ICN:${primaryPersn.icn}
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			SSN: ${primaryPersn.ssn} 
				    			</div>
				    			<div class="selected-vcg-row">
				    			<fmt:formatDate value="${primaryPersn.birthDate}" var="pbday" type="date" pattern="MM/dd/yyyy"/>
				    	 			DOB: ${pbday}
				    			</div>
				    			<div class="selected-vcg-row">
				    				Medicare Enrolled: <liferay-ui:message key="${vcgAn['mediEnrolled']}-yes" />
				    			</div>
				    			<div class="selected-vcg-row">
				    				Other Insurance: ${primaryPersn.otherHealthInsurance}
				    			</div>
				    			<hr/>
				    			<div class="selected-vcg-row">
				    				${primaryPersn.address}
				    			</div>
				    			<div class="selected-vcg-row">
				    				${primaryPersn.city}, ${primaryPersn.state} ${primaryPersn.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				${primaryPersn.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				${primaryPersn.phone}  ${primaryPersn.phone2} 
				    			</div>
				    		</div>
			    		</div>
		    		</c:if>
				</div>
			</div>
		</div>
	</div>
	


					<c:if test="${! empty secondaryPersn}">
					
<div class="select-caregiver" >
		<div class="person-selection">
			<div class="vcg-entry-menu" id="${secondaryPersn.primaryKey}">
				<div class="float-left">
					<a class="btn-link ${editAction} btn-primary" title="<liferay-ui:message key="${title}" />"  >&nbsp;<liferay-ui:message key="edit-vcg-secondary" /></a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title="<liferay-ui:message key="audit-log" />" >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<div class="center-position">
				<div class="care-giver-name" id="update_secondary">
					
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			${secondaryPersn.lastName}, ${secondaryPersn.firstName} ${secondaryPersn.middleName}  
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			Relationship to Veteran:<liferay-ui:message key="${vcg.secondaryType}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			Status:<liferay-ui:message key="status-${vcg.secondaryDispReason}" />
				    			</div>
				    			<hr>
				    			<div class="selected-vcg-row">
				    	 			Gender: <liferay-ui:message key="${secondaryPersn.gender}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			ICN: ${secondaryPersn.icn}
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			SSN: ${secondaryPersn.ssn}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<fmt:formatDate value="${secondaryPersn.birthDate}" var="sbday" type="date" pattern="MM/dd/yyyy"/>
				    	 			DOB: ${sbday}
				    			</div>
				    			<hr>
				    			<div class="selected-vcg-row">
				    				${secondaryPersn.address}
				    			</div>
				    			<div class="selected-vcg-row">
				    				${secondaryPersn.city}, ${secondaryPersn.state} ${secondaryPersn.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				${secondaryPersn.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				${secondaryPersn.phone}  ${secondaryPersn.phone2} 
				    			</div>
				    		</div>
			    		</div>
			    		
				</div>
			</div>
		</div>
	</div>
			    	</c:if>


					<c:if test="${! empty secondaryTwoPersn}">
<div class="select-caregiver" >
		<div class="person-selection">
			<div class="vcg-entry-menu" id="${secondaryTwoPersn.primaryKey}" >
				<div class="float-left">
					<a class="btn-link ${editAction} btn-primary" title="<liferay-ui:message key="${title}" />"  >&nbsp;<liferay-ui:message key="edit-vcg-secondaryTwo" /></a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title="<liferay-ui:message key="audit-log" />"  >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<div class="center-position">
				<div class="care-giver-name" id="update_secondaryTwo">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			${secondaryTwoPersn.lastName}, ${secondaryTwoPersn.firstName} ${secondaryTwoPersn.middleName}  
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			Relationship to Veteran:<liferay-ui:message key="${vcg.secondaryTwoType}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			Status:<liferay-ui:message key="status-${vcg.secondaryTwoDispReason}" />
				    			</div>
				    			<hr>
				    			<div class="selected-vcg-row">
				    	 			Gender: <liferay-ui:message key="${secondaryTwoPersn.gender}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			ICN: ${secondaryTwoPersn.icn}
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			SSN: ${secondaryTwoPersn.ssn} 
				    			</div>
				    			<div class="selected-vcg-row">
				    				<fmt:formatDate value="${secondaryTwoPersn.birthDate}" var="s2bday" type="date" pattern="MM/dd/yyyy"/>
				    	 			DOB: ${s2bday}
				    			</div>
				    			<hr>
				    			<div class="selected-vcg-row">
				    				${secondaryTwoPersn.address}
				    			</div>
				    			<div class="selected-vcg-row">
				    				${secondaryTwoPersn.city}, ${secondaryTwoPersn.state} ${secondaryTwoPersn.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				${secondaryTwoPersn.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				${secondaryTwoPersn.phone}  ${secondaryTwoPersn.phone2} 
				    			</div>
				    		</div>
			    		</div>
				</div>
			</div>
		</div>
	</div>
			    	</c:if>
	
</fieldset>
</div>	

<div class="supporting-docs">
	<fieldset>
	<legend class="header">Supporting Documents</legend>
	<div class="clear-both" id="<portlet:namespace/>supportDocs" >
		<c:forEach var="doc" items="${form_['supportDocs']}">
			<portlet:resourceURL var="getDocum">
				<portlet:param name="action" value="getDocum"/>
				<portlet:param name="documId" value="${doc.documId}"/>
			</portlet:resourceURL>
			
			<div class="poa-docum manage-layout" >
				<a href="${getDocum}" target="_blank" ><i class="close-window btn btn-primary icon-download" >&nbsp; ${doc.name}</i></a>
			</div>
		
		</c:forEach>
	</div>
	</fieldset>
</div>	


<div class="training-logs">
	<fieldset>
	<legend class="header">Training Log</legend>
	<div class="clear-both" id="<portlet:namespace/>trainingLog" >
		
	</div>
	</fieldset>
</div>


<div class="initial-assessments">
	<fieldset>	
		<legend class="header">Assessments/Training (Initial)</legend>
		<div class="sectionHeading">Primary Caregiver</div>		
		<div class="summaryTable">
		<table style="width:90%">
			<tr>
			  <td width="100%" colspan='4' style="text-align:left;">Valid Application Received Date - ${primaryValidAppDate}</td> 
			</tr>

			<tr>
			  <th width="30%">Assessment</th> 
			  <th width="15%">* Completion Date</th> 	  
			  <th width="40%">Comment/Note</th> 
			  <th width="15%">Action</th>
			</tr>
	
			<c:forEach var="oneAssessment" items="${form_['primaryAssessmentList']}" >	
			<c:set var="isDisabled" value="false"/>
			<!-- Disable when in_process app id is empty or caregiver slot is empty or assessment is already there -->
			<c:if test="${empty primaryApplicationId || vcg.primaryId le 0 || oneAssessment.assessment.assmtId gt 0}"><c:set var="isDisabled" value="true"/></c:if>
			<tr>
			    <td>
				    <input type="hidden" name="${oneAssessment.assessment.type}_caregiverId" value="${vcg.primaryId}" id="${oneAssessment.assessment.type}_caregiverId"/>
				    <input type="hidden" name="${oneAssessment.assessment.type}_assessmentId" value="${oneAssessment.assessment.assmtId}" id="${oneAssessment.assessment.type}_assessmentId"/>
				    <liferay-ui:message key="${oneAssessment.assessment.type}" />
				</td>
			    <td>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass['comletionDate']}"  >
						<aui:input label="" name="${oneAssessment.assessment.type}_completionDate" value="${oneAssessment.formattedcompletionDate}" cssClass="date-field" type="text" id="${oneAssessment.assessment.type}_completionDate" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			  		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass}"  >
				 		<aui:input label="" name="${oneAssessment.assessment.type}_comment" value="${oneAssessment.assessment.comment}" type="textarea" id="${oneAssessment.assessment.type}_comment" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			    	<!-- show only when in_process application and caregiver exist for the slot -->
			    	<c:if test="${not empty primaryApplicationId && vcg.primaryId gt 0}">
			    	<div id="action_${oneAssessment.assessment.type}">			    	
				    	<a class="btn-primary save-assessment" id="save_${oneAssessment.assessment.type}" style="${isDisabled ? 'display: none' : ''}"><i class="close-window btn btn-primary" >Save</i></a>
				    	<a class="btn-primary edit-assessment" id="edit_${oneAssessment.assessment.type}" style="${isDisabled ? '' : 'display: none'}"><i class="close-window btn btn-primary" >Edit</i></a>			    	
			    	</div>
			    	</c:if>
		    	</td>
			</tr>
			</c:forEach>
		</table>
		</div>
		
		<div class="sectionHeading">Secondary Caregiver</div>
		<div class="summaryTable">
		<table style="width:90%">
			<tr>
			  <td width="100%" colspan='4' style="text-align:left;">Valid Application Received Date - ${secondaryValidAppDate}</td> 
			</tr>

			<tr>
			  <th width="30%">Assessment</th> 
			  <th width="15%">* Completion Date</th> 	  
			  <th width="40%">Comment/Note</th> 
			  <th width="15%">Action</th>
			</tr>
	
			<c:forEach var="oneAssessment" items="${form_['secondaryAssessmentList']}" >
			<c:set var="isDisabled" value="false"/>
			<c:if test="${empty secondaryApplicationId || vcg.secondaryId le 0 || oneAssessment.assessment.assmtId gt 0}"><c:set var="isDisabled" value="true"/></c:if>
			<tr>
			    <td>
				    <input type="hidden" name="${oneAssessment.assessment.type}_caregiverId" value="${vcg.secondaryId}" id="${oneAssessment.assessment.type}_caregiverId"/>
				    <input type="hidden" name="${oneAssessment.assessment.type}_assessmentId" value="${oneAssessment.assessment.assmtId}" id="${oneAssessment.assessment.type}_assessmentId"/>
				    <liferay-ui:message key="${oneAssessment.assessment.type}" />
				</td>
			    <td>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass['comletionDate']}"  >
						<aui:input label="" name="${oneAssessment.assessment.type}_completionDate" value="${oneAssessment.formattedcompletionDate}" cssClass="date-field" type="text" id="${oneAssessment.assessment.type}_completionDate" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			  		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass}"  >
				 		<aui:input label="" name="${oneAssessment.assessment.type}_comment" value="${oneAssessment.assessment.comment}" type="textarea" id="${oneAssessment.assessment.type}_comment" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			    	<c:if test="${not empty secondaryApplicationId && vcg.secondaryId gt 0}">
			    	<div id="action_${oneAssessment.assessment.type}">			    	
				    	<a class="btn-primary save-assessment" id="save_${oneAssessment.assessment.type}" style="${isDisabled ? 'display: none' : ''}"><i class="close-window btn btn-primary" >Save</i></a>
				    	<a class="btn-primary edit-assessment" id="edit_${oneAssessment.assessment.type}" style="${isDisabled ? '' : 'display: none'}"><i class="close-window btn btn-primary" >Edit</i></a>			    	
			    	</div>
			    	</c:if>
		    	</td>
			</tr>
			</c:forEach>
		</table>
		</div>
		
		<div class="sectionHeading">Secondary Two Caregiver</div>
		<div class="summaryTable">
		<table style="width:90%">
			<tr>
			  <td width="100%" colspan='4' style="text-align:left;">Valid Application Received Date - ${secondaryTwoValidAppDate}</td> 
			</tr>

			<tr>
			  <th width="30%">Assessment</th> 
			  <th width="15%">* Completion Date</th> 	  
			  <th width="40%">Comment/Note</th> 
			  <th width="15%">Action</th>
			</tr>
	
			<c:forEach var="oneAssessment" items="${form_['secondaryTwoAssessmentList']}" >
			<c:set var="isDisabled" value="false"/>
			<c:if test="${empty secondaryTwoApplicationId || vcg.secondaryTwoId le 0 || oneAssessment.assessment.assmtId gt 0}"><c:set var="isDisabled" value="true"/></c:if>
			<tr>
			    <td>
				    <input type="hidden" name="${oneAssessment.assessment.type}_caregiverId" value="${vcg.secondaryTwoId}" id="${oneAssessment.assessment.type}_caregiverId"/>
				    <input type="hidden" name="${oneAssessment.assessment.type}_assessmentId" value="${oneAssessment.assessment.assmtId}" id="${oneAssessment.assessment.type}_assessmentId"/>
				    <liferay-ui:message key="${oneAssessment.assessment.type}" />
				</td>
			    <td>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass['comletionDate']}"  >
						<aui:input label="" name="${oneAssessment.assessment.type}_completionDate" value="${oneAssessment.formattedcompletionDate}" cssClass="date-field" type="text" id="${oneAssessment.assessment.type}_completionDate" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			  		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass}"  >
				 		<aui:input label="" name="${oneAssessment.assessment.type}_comment" value="${oneAssessment.assessment.comment}" type="textarea" id="${oneAssessment.assessment.type}_comment" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			    	<c:if test="${not empty secondaryTwoApplicationId && vcg.secondaryTwoId gt 0}">
			    	<div id="action_${oneAssessment.assessment.type}">			    	
				    	<a class="btn-primary save-assessment" id="save_${oneAssessment.assessment.type}" style="${isDisabled ? 'display: none' : ''}"><i class="close-window btn btn-primary" >Save</i></a>
				    	<a class="btn-primary edit-assessment" id="edit_${oneAssessment.assessment.type}" style="${isDisabled ? '' : 'display: none'}"><i class="close-window btn btn-primary" >Edit</i></a>			    	
			    	</div>
			    	</c:if>
		    	</td>
			</tr>
			</c:forEach>
		</table>
		</div>
		
</fieldset>


<div class="ongoing-assessments">
	<fieldset>		
		<legend class="header">Assessments/Training (Ongoing)</legend>
	</fieldset>
</div>
	
</div>		
	
	<input type="hidden" id="<portlet:namespace/>placeHolder" />
	
	<div class="manage-layout manage-layout-shim">
		<c:if test="${! empty form_['documId'] and form_['documId'] gt 0}">
			<portlet:resourceURL var="getDocum">
				<portlet:param name="action" value="getDocum"/>
				<portlet:param name="documId" value="${form_['documId']}"/>
			</portlet:resourceURL>
			
			<div class="poa-docum manage-layout" >
				<a href="${getDocum}" target="_blank" ><i class="icon-download" >&nbsp; ${form_['documName']}</i></a>
			</div>
		</c:if>
	</div>
	
	
	
<portlet:actionURL var="saveEntry">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="saveEntry"/>
	<portlet:param name="entry" value="vcg" />
</portlet:actionURL>

<div class="yui3-skin-sam">
	<aui:form name="sign_fm" method="post"  action="${saveEntry}"  >
		<input type="hidden" name="vcgId" value="${vcg.vcgId}" >
    	<div id="modalUpdateVcg">
    	</div>
    </aui:form>
</div>
 <div id="edit_vcg_entry">
</div>


<div class="yui3-skin-sam">
   	<div id="modalAuditVcg">
   	</div>
</div>
 <div id="audit_vcg_entry">
</div>
	
	
	
	<aui:script use="aui-tooltip,aui-modal,io-form,querystring-stringify">
			new A.TooltipDelegate( { trigger: '.person-selection .icon-pencil, .person-selection .icon-ok' } );
			
			
			var assessmentCount = ${form_['assessments'].size()};
			
			A.one('#<portlet:namespace/>scheduleAssessment').on(
				      'click',
		      	function( ) {
		    		var newAssessments = 1 + Number( A.one('#<portlet:namespace/>newAssessments').val() );
		    		var nextAssessment = A.one('#<portlet:namespace/>assessmentNext'+ newAssessments );
		    		if ( nextAssessment.hasClass('hidden-element') ){
			    		nextAssessment.removeClass('hidden-element');
		    		} else {
		    			return false;
		    		}
		    		A.one('#<portlet:namespace/>newAssessments').val( newAssessments );
		    		nextAssessment.addClass('active-element');
		     	}
		    );
			
			
			var modal = new A.Modal({
				headerContent: '<h4><liferay-ui:message key="update-vcg-entry-header" /></h4>',
		        bodyContent: A.one("#edit_vcg_entry"),
		        centered: true,
		        destroyOnHide: false,
		        modal: true,
		        render: '#modalUpdateVcg',
		        resizable: {
		          handles: 'b, r'
		        },
		        visible: false,
		        width: 1000
		    });
			
			modal.addToolbar([
			                         {
			                           label: 'Cancel',
			                           on: {
			                             click: function() {
			                            	 modal.hide();
			                             }
			                           }
			                         },{
			                           label: 'Update',
			                           on: {
			                             click: function() {
                            		    	validateFields( function ( message ) {
                            		    		var validationNotice = A.one ('#_validationResult');
                           			    		if ( message.length > 0 ){
                           		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
                           		    				validationNotice.html(msg);
                           		    				modal.footerNode.insert(validationNotice);
                           				    		return false;	
                           			    		}
				                            	A.one('#<portlet:namespace/>sign_fm').submit();	
                            		    	});

			                             }
			                           }
			                         }
			                    ]);
		    
			
			A.all('.edit-vcg-entry').on(
				      'click',
				      function( event ) {
				    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadVcgEntry" /><portlet:param name="page" value="editVcgEntry"/></portlet:resourceURL>', 'html', 
									{ persnId: event.currentTarget.ancestor('.vcg-entry-menu').attr('id'),
				    	  				vcgId: '${vcg.vcgId}'
									},
									function( data ){
										overwrite( A.one( '#edit_vcg_entry' ), data );
										
										modal.footerNode.all('.portlet-msg-alert').each( function (msg){
											msg.hide();	
										});
										modal.render();
							        	modal.show();
							        	window.enforceFormats();
							        	try{
								        	A.one(".btn-link.short-facility-list.btn-primary.facil-magnet").setStyle('margin-top', '-30px');
							        	} catch(e){}
									} 
							);
				     }
				 );
			
			var modalH = new A.Modal({
				headerContent: '<h4><liferay-ui:message key="audit-vcg-entry-header" /></h4>',
		        bodyContent: A.one("#audit_vcg_entry"),
		        centered: true,
		        destroyOnHide: false,
		        modal: true,
		        render: '#modalAuditVcg',
		        resizable: {
		          handles: 'b, r'
		        },
		        visible: false,
		        width: 1000
		    });
			
			A.all('.audit-vcg-entry').on(
				      'click',
				      function( event ) {
				    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="persnAudit"/></portlet:resourceURL>', 'html', 
									{ persnId: event.currentTarget.ancestor('.vcg-entry-menu').attr('id'),
				    	  				vcgId: '${vcg.vcgId}'
									},
									function( data ){
										overwrite( A.one( '#audit_vcg_entry' ), data );
										modalH.render();
										modalH.show();
									} 
							);
				     }
				 );
			
			var needServiceCall = true;
			
			var validateFields = function ( anotherCallback ){
				  
				  var count = 0;
				  var inputNodes = A.all('.required-input input, .required-input select');
				  var fields = "";
				  for ( var i = 0; i < inputNodes.size() ; i++ ){
					  var node = A.one(inputNodes._nodes[i]);
					  if (node == undefined  || node.attr('disabled') == true ) continue;
						if ( 'select-one' == node.attr('type') ){
			    			if ( node.val() == "" || node.val() == "0" ){
			    				 node.addClass( 'missing-required-input' );
			    				 fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
			    				 count++;
			    			} else {
			    				if ( node.hasClass('missing-required-input') ){
			    					node.removeClass( 'missing-required-input' );
			    				}
			    			}
			    		}
						if ( 'text' == node.attr('type') ){
							if ( node.val() == ""   
								|| ( node.hasClass('date-field') && node.val() == 'MM/DD/YYYY' )
								|| ( node.hasClass('ssn-field') && node.val() == '###-##-####' )
								|| ( node.hasClass('phone-field') && node.val() == '(###) ###-####' ) ){
			   					node.addClass( 'missing-required-input' );
			   					fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
			   					count++;
				   			} else {
				   				if ( node.hasClass('missing-required-input') ){
				   					node.removeClass( 'missing-required-input' );
				   				}
							}
				    	}
				    }

				   	if ( needServiceCall ){
				   		
					   	//USPS Address validation
					    return validateUSPSAddress( function ( validationStatus , correctAdd) {
						    
					    	var msg = '';
						    if( validationStatus == "invalid" ){
						    	if(correctAdd==null){
						    		correctAdd = "";
						    	}					
						    	msg = "<li> Address entered is not a valid USPS address. Please enter a valid USPS address. "+correctAdd+"</li>"			        
						        needServiceCall = true;
						    }else if( validationStatus == "unavailable" ){
						        msg = "<li> USPS Address Validation Service Unavailable at this time. </li>";
						        needServiceCall = true;
						    } else {
						    	needServiceCall = false;
						    }
							
						  	return anotherCallback( fields + msg );
					    });
				   	} else {
				   		anotherCallback( fields );
				   	}
				        
			  }
			
			
	</aui:script>
	
	<aui:script use="aui-base">
	
	 window.modalAssmtDataValidation = new A.Modal({
		    headerContent: '<h4><liferay-ui:message key="data-validation-header" /> </h4>',
		    bodyContent: A.one("#assmtValidationDiv"),
		    centered: true,
		    destroyOnHide: false,
		    modal: true,
		    render: '#assmtValidationModal',
		    resizable: {
		      handles: 'b, r'
		    },
		    visible: false,
		    width: 600
	});
	
	
	A.all('.save-assessment').on('click',function( event ) {
		var message = "";		
		var vcgId = '${vcg.vcgId}';
	 	var id = event.currentTarget.attr('id');	 	   
	 	var type = id.substring(5);
		var assessmentId = A.one('#'+type+'_assessmentId').val();
		var completionDate = A.one('#<portlet:namespace/>'+type+'_completionDate').val();
		var comment = A.one('#<portlet:namespace/>'+type+'_comment').val();
		var caregiverId = A.one('#'+type+'_caregiverId').val();

		var typeList = [ "primaryClinical", "primaryAssessment", "primaryTraining", "primaryInHome", "secondaryClinical", "secondaryAssessment", "secondaryTraining", "secondaryTwoClinical", "secondaryTwoAssessment", "secondaryTwoTraining" ]
		var arrayLength = typeList.length;
		for (var i = 0; i < arrayLength; i++) {
		    A.one('#<portlet:namespace/>'+typeList[i]+'_completionDate').removeClass( 'missing-required-input' );
		}		
		
		if(completionDate==null || completionDate=='MM/DD/YYYY' ){
			message = "<li>Completion Date is required</li>";
			A.one('#<portlet:namespace/>'+type+'_completionDate').addClass( 'missing-required-input' );
		}	

		if(type == 'primaryAssessment'){
			var completionDateCompare = new Date(completionDate);
			var appReceiveDate = new Date('${primaryValidAppDate}');
			
			if(completionDateCompare.valueOf() < appReceiveDate.valueOf()){
				message = message + "<li>Caregiver Assessment date cannot be before the Valid Application Received Date</li>";
				A.one('#<portlet:namespace/>primaryAssessment_completionDate').addClass( 'missing-required-input' );
			}
		}
		
		if(type == 'secondaryAssessment'){
			var completionDateCompare = new Date(completionDate);
			var appReceiveDate = new Date('${secondaryValidAppDate}');
			
			if(completionDateCompare.valueOf() < appReceiveDate.valueOf()){
				message = message + "<li>Secondary Caregiver Assessment date cannot be before the Valid Application Received Date</li>";
				A.one('#<portlet:namespace/>secondaryAssessment_completionDate').addClass( 'missing-required-input' );
			}
		}

		if(type == 'secondaryTwoAssessment'){
			var completionDateCompare = new Date(completionDate);
			var appReceiveDate = new Date('${secondaryTwoValidAppDate}');
			
			if(completionDateCompare.valueOf() < appReceiveDate.valueOf()){
				message = message + "<li>Secondary Two Caregiver Assessment date cannot be before the Valid Application Received Date</li>";
				A.one('#<portlet:namespace/>secondaryAssessment_completionDate').addClass( 'missing-required-input' );
			}			
		}

		
	
		if ( message.length > 0 ){
			modalAssmtDataValidation.render();
			modalAssmtDataValidation.show();
			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
			A.one ('#assmtValidationResult').html(msg);
		}else{
			window.caretIo( '<portlet:resourceURL><portlet:param name="javax.portlet.action" value="doAction"/><portlet:param name="action" value="saveAssessment"/></portlet:resourceURL>', 'json',
		    {
				vcgId:'${vcg.vcgId}',
				type: type,
				assessmentId: A.one('#'+type+'_assessmentId').val(),
				completionDate: A.one('#<portlet:namespace/>'+type+'_completionDate').val(),
				comment: A.one('#<portlet:namespace/>'+type+'_comment').val(),
				caregiverId: A.one('#'+type+'_caregiverId').val(),
				veteranId: '${veteranId}'
	        },
	        function( data ) {
	    	   	var assessmentId = data.assessmentId;
	    	   	A.one('#'+type+'_assessmentId').attr('value',assessmentId);
	    	   	A.one('#<portlet:namespace/>'+type+'_completionDate').attr('disabled',true);
	    	   	A.one('#<portlet:namespace/>'+type+'_comment').attr('disabled',true);
	    	   	document.getElementById('edit_'+type).style.display = '';
	    	   	document.getElementById('save_'+type).style.display = 'none';
	       	});
		}
	});
	
	A.all('.edit-assessment').on('click',function( event ) {
		var id = event.currentTarget.attr('id');	 	   
	 	var type = id.substring(5);

		A.one('#<portlet:namespace/>'+type+'_completionDate').attr('disabled',false);
	   	A.one('#<portlet:namespace/>'+type+'_comment').attr('disabled',false);	  
	   	document.getElementById('save_'+type).style.display = '';
	    document.getElementById('edit_'+type).style.display = 'none';
	});

	</aui:script>

	<div class="yui3-skin-sam">
		<div id="assmtValidationModal"></div>
	</div>

	<div id="assmtValidationDiv" class="yui3-skin-sam">	
		<div id="assmtValidationResult"></div>
	</div>
	
		
	<%@include file="/jsp/version.jsp" %>	
	