
<%@ include file="/jsp/init.jsp" %>



<aui:nav cssClass="form-menu">
     <aui:nav-item href="javascript:" iconCssClass="icon-plus" label="new-assessment" id="scheduleAssessment" >
     </aui:nav-item>
</aui:nav>

<portlet:actionURL var="createVcg">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="createVcg"/>
</portlet:actionURL>

<div class="caret-form clear-both" >
<form name="createVcg" method="post" action="${createVcg}" >
	<fieldset>
	<legend class="header"><liferay-ui:message key="process-application" /></legend>
	<c:set var="form_" value="${caretMap_['form_']}" />
	<c:set var="vcgAn" value="${form_['vcgAn']}" />
	<c:set var="worImId" value="${form_['worImId']}" />
 	<c:set var="veteran" value="${form_['veteranPersn']}" />
 	<c:set var="primary" value="${form_['primaryPersn']}" />
 	<c:set var="secondary" value="${form_['secondaryPersn']}" />
 	<c:set var="secondaryTwo" value="${form_['secondaryTwoPersn']}" />
 	<c:set var="cssClass" value="${form_['required']}" />

 	<c:set var="ndx" value="veteranPersn" />
	
 	<input type="hidden" name="TRACKER" value="${TRACKER}" >
	<input type="hidden" name="<portlet:namespace/>vcgAnId" value="${vcgAn.vcgAnId}">
	
	<input type="hidden" name="mvcPath" id="mvcPath" />

	<input type="hidden" name="worImId" id="<portlet:namespace/>worImId" value="${worImId}">
	<input type="hidden" name="ndx0" value="${vcgAn.vcgAnId}" />
	<input type="hidden" name="vcg_veteranId" id="<portlet:namespace/>use_found_0" >
	<input type="hidden" name="vcg_primaryId" id="<portlet:namespace/>use_found_1" value="${vcgAn.primaryId}" >
	<input type="hidden" name="vcg_secondaryId" id="<portlet:namespace/>use_found_2" value="${vcgAn.secondaryId}" >
	<input type="hidden" name="vcg_secondaryTwoId" id="<portlet:namespace/>use_found_3" value="${vcgAn.secondaryTwoId}" >

	<div class="vcg-box" >
	
		<div class="vcg-header column-float" >
			VA Form 10 10CG
		</div>
		<div class="vcg-header column-float" >
			&nbsp;
		</div>
		<div class="vcg-header column-last" >
			System Profile
		</div>
		<hr/>
		<div class="vcg-row column-float" >
			<div class="next-line">${veteran.fullName}</div>
			<div class="next-line">${veteran.address}</div>
			<div class="next-line">${veteran.ssn}</div>
			<fmt:formatDate var="someDate" pattern="MM/dd/yyyy" value="${veteran.birthDate}"/>
			<div class="next-line">${someDate}</div>			
		</div>
		<div class="vcg-row column-float" >
			Veteran
		</div>
		<div class="vcg-row column-last" >
			<a class="btn-link search-vcg-action btn-primary icon-search" id="found_0">&nbsp;Find Match</a>
			<div class="care-giver-name" id="search_found_0" >
				<!-- 
				<i>${veteran.fullName}</i>
				<i>${veteran.ssn}</i>
				<i>${veteran.birthDate}</i>
				<i>${veteran.address}</i>
				 -->
			</div>
		</div>
		<input type="hidden" id="<portlet:namespace/>veteranAcc" name="veteranStatus" value="" />
		<hr/>
		<c:if test="${! empty primary}">
			<div class="vcg-row column-float" >
				<div class="next-line">${primary.fullName}</div>
				<div class="next-line">${primary.address}</div>
				<div class="next-line">${primary.ssn}</div>
				<fmt:formatDate var="someDate" pattern="MM/dd/yyyy" value="${primary.birthDate}"/>
				<div class="next-line">${someDate}</div>						
			</div>
			<div class="vcg-row column-float" >
				Primary CG
			</div>
			<div class="vcg-row column-last" >
				<a class="btn-link search-vcg-action btn-primary icon-search" id="found_1">&nbsp;Find Match</a>
				<div class="care-giver-name" id="search_found_1" >
					<!-- 
					<i>${primary.fullName}</i>
					<i>${primary.ssn}</i>
					<i>${primary.birthDate}</i>
					<i>${primary.address}</i>
					 -->
				</div>
			</div>
			<input type="hidden" id="<portlet:namespace/>primaryAcc" name="primaryStatus" value="" />
			<hr/>
		</c:if>
		<c:if test="${! empty secondary}">  
			<div class="vcg-row column-float" >
				<div class="next-line">${secondary.fullName}</div>
				<div class="next-line">${secondary.address}</div>
				<div class="next-line">${secondary.ssn}</div>
				<fmt:formatDate var="someDate" pattern="MM/dd/yyyy" value="${secondary.birthDate}"/>
				<div class="next-line">${someDate}</div>					
			</div>
			<div class="vcg-row column-float" >
				Secondary CG
			</div>
			<div class="vcg-row column-last" >
				<a class="btn-link search-vcg-action btn-primary icon-search" id="found_2">&nbsp;Find Match</a>
				<div class="care-giver-name" id="search_found_2" >
					<!-- 
					<i>${secondary.fullName}</i>
					<i>${secondary.ssn}</i>
					<i>${secondary.birthDate}</i>
					<i>${secondary.address}</i>
					 -->
				</div>
			</div>
			<input type="hidden" id="<portlet:namespace/>secondaryAcc" name="secondaryStatus" value="" />
			<hr/>
		</c:if>
		<c:if test="${! empty secondaryTwo}">
			<div class="vcg-row column-float" >
				<div class="next-line">${secondaryTwo.fullName}</div>
				<div class="next-line">${secondaryTwo.address}</div>
				<div class="next-line">${secondaryTwo.ssn}</div>
				<fmt:formatDate var="someDate" pattern="MM/dd/yyyy" value="${secondaryTwo.birthDate}"/>
				<div class="next-line">${someDate}</div>						
			</div>
			<div class="vcg-row column-float" >
				Secondary CG #2
			</div>
			<div class="vcg-row column-last" >
				<a class="btn-link search-vcg-action btn-primary icon-search" id="found_3">&nbsp;Find Match</a>
				<div class="care-giver-name" id="search_found_3" >
				<!-- 
					<i>${secondaryTwo.fullName}</i>
					<i>${secondaryTwo.ssn}</i>
					<i>${secondaryTwo.birthDate}</i>
					<i>${secondaryTwo.address}</i>
				 -->
				</div>
			</div>
			<input type="hidden" id="<portlet:namespace/>secondaryTwoAcc" name="secondaryTwoStatus" value="" />
		</c:if>
		<input type="hidden" id="<portlet:namespace/>worIm_comment" name="worIm_comments" value="" />		
	</div>
	</fieldset>
	
	<fieldset>
	<legend class="header">Supporting Documents</legend>
	<div class="clear-both" id="<portlet:namespace/>supportDocs" >
		<c:forEach var="doc" items="${form_['supportDocs']}">
			<portlet:resourceURL var="getDocum">
				<portlet:param name="action" value="getDocum"/>
				<portlet:param name="documId" value="${doc.documId}"/>
			</portlet:resourceURL>
			
			<div class="poa-docum manage-layout" >
				<a href="${getDocum}" target="_blank" ><i class="close-window btn btn-primary icon-download" >&nbsp; ${doc.name}</i></a>
			</div>
		
		</c:forEach>
	</div>
	</fieldset>
		
	<fieldset>
		
		<legend class="header">Monitoring Assessments</legend>
		<div class="clear-both" id="<portlet:namespace/>assessmentDiv" >
			<input type="hidden" name="<portlet:namespace/>newAssessments" id="<portlet:namespace/>newAssessments" value="0" />
			
			<c:forEach var="assmt" items="${form_['assessments']}" varStatus="assessmentCount" >
				<aui:row cssClass="assmt-row">
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >		
						<aui:select disabled="${isDisabled}" label="assessment-type" name="assmt${assmt.assmtId}_type"  >
							<option value="">Select Assesment Type</option>
							<option value="home-visit">In-Home Visit</option>
							<c:if test="${assessmentCount % 4 > 0}">
								<option value="telephone">Telephone</option>
								<option value="telehealth">Telehealth</option>
								<option value="facility">Facility Visit</option>
							</c:if>
							<option value="notCompleted">Not Completed</option>
						</aui:select>
					</aui:field-wrapper>
					<div class="dobDelegate control-group control-group-inline form-inline field-wrapper manage-layout" >
						<fmt:formatDate var="someDate" pattern="MM/dd/yyyy" value="${assmt.scheduleDate}"/>
						<aui:input label="scheduled-date" name="assmt${assmt.assmtId}_scheduleDate" cssClass="date-field" disabled="true" type="text" size="25" value="${someDate}" />
					</div>
					<aui:input type="hidden" name="assmt${assmt.assmtId}_completionDate" id="assmt${assmt.assmtId}_completionDate" value="${assmt.completionDate}" />
					<aui:input type="hidden" name="assmt${assmt.assmtId}_completionNote" id="assmt${assmt.assmtId}_completionNote" value="" />
				</aui:row>
			</c:forEach>


			<c:forEach var="assessmentCount" begin="${1 + form_['assessments'].size()}" end="${4 + form_['assessments'].size()}" >
				<aui:row cssClass="assmt-row hidden-element" id="assessmentNext${assessmentCount}" >
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >		
						<aui:select disabled="${isDisabled}" label="assessment-type" name="assmt${assessmentCount}_type"  >
							<option value="">Select Assesment Type</option>
							<option value="home-visit">In-Home Visit</option>
							<c:if test="${assessmentCount % 4 != 0}">
								<option value="telephone">Telephone</option>
								<option value="telehealth">Telehealth</option>
								<option value="facility">Facility Visit</option>
							</c:if>
								<option value="notCompleted">Not Completed</option>
						</aui:select>
					</aui:field-wrapper>
					<div class="required-date control-group control-group-inline form-inline field-wrapper manage-layout" >
						<aui:input label="scheduled-date" name="assmt${assessmentCount}_scheduleDate" cssClass="date-field scheduled-date" disabled="${isDisabled}" type="text" size="25"  />
					</div>
					<label id="assmt${assmt.assmtId}_" title='<liferay-ui:message key="assess-completed" />' class="control-label assess-completed-action icon-calendar" for='<portlet:namespace/>${ndx}_lastName' >
						<liferay-ui:message key="last-name" />
					</label>
					<aui:input type="hidden" name="assmt${assmt.assmtId}_completionDate" id="assmt${assmt.assmtId}_completionDate" value="${assmt.completionDate}" />
					<aui:input type="hidden" name="assmt${assmt.assmtId}_completionNote" id="assmt${assmt.assmtId}_completionNote" value="" />
				</aui:row>
			</c:forEach>
		</div>	
	</fieldset>		
	
<!-- div class="hidden-element"  -->
	<div id="signDisposition">
	
	
	<c:if test="${! empty veteran}">
	<div class="disp-next-line">
		<div class="disp-persn">Veteran: ${veteran.fullName}</div>
		<div class="disp-answer">
			<aui:input label="accept" name="veteranAcc" type="radio" value="true"  />
			<aui:input label="reject" name="veteranAcc" type="radio" value="false" />
		</div>
		</div>
	</c:if>
	
	<c:if test="${! empty primary}">
	<div class="disp-next-line">
		<hr/>
		<div class="disp-persn">Primary CG: ${primary.fullName}</div>
		<div class="disp-answer">
			<aui:input label="accept" name="primaryAcc" type="radio" value="true"  />
			<aui:input label="reject" name="primaryAcc" type="radio" value="false" />
		</div>
		</div>
	</c:if>
	
	<c:if test="${! empty secondary}">
	<div class="disp-next-line">
		<hr/>
		<div class="disp-persn">Secondary CG: ${secondary.fullName}</div>
		<div class="disp-answer">
			<aui:input label="accept" name="secondaryAcc" type="radio" value="true"  />
			<aui:input label="reject" name="secondaryAcc" type="radio" value="false" />
		</div>
		</div>
	</c:if>
	
	<c:if test="${! empty secondaryTwo}">
		<hr/>
		<div class="disp-next-line">
			<div class="disp-persn">Secondary 2 CG: ${secondaryTwo.fullName}</div>
			<div class="disp-answer">
				<aui:input label="accept" name="secondaryTwoAcc" type="radio" value="true"  />
				<aui:input label="reject" name="secondaryTwoAcc" type="radio" value="false" />
			</div>
		</div>
	</c:if>
	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="disp-answer manage-layout-medium-input ${cssClass}"  >
 		<aui:input label="comments" id="worIm_comment0" name="notUsed" size="25" type="textarea"  />
	</aui:field-wrapper>
		
	</div>
<!-- > /div -->
	
	
	<!-- div class="hidden-element"  -->
	<div id="signAssessment">
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >		
			<aui:select disabled="${isDisabled}" label="assessment-type" name="assmt${assmt.assmtId}_type"  >
				<option value="">Select Assesment Type</option>
				<option value="home-visit">In-Home Visit</option>
					<option value="telephone" class="can-select" >Telephone</option>
					<option value="telehealth">Telehealth</option>
					<option value="facility">Facility Visit</option>
				<option value="notCompleted">Not Completed</option>
			</aui:select>
		</aui:field-wrapper>
		<div class="dobDelegate control-group control-group-inline form-inline field-wrapper manage-layout" >
			<fmt:formatDate var="someDate" pattern="MM/dd/yyyy" value="${assmt.scheduleDate}"/>
			<aui:input label="scheduled-date" name="assmt${assmt.assmtId}_scheduleDate" cssClass="date-field" disabled="true" type="text" size="25" value="${someDate}" />
		</div>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="disp-answer manage-layout-medium-input ${cssClass}"  >
	 		<aui:input label="comments" name="worIm_comment9"  id="worIm_comment9"  size="25" type="textarea"  />
		</aui:field-wrapper>
	</div>
	
	
</form>
	<input type="hidden" id="<portlet:namespace/>placeHolder" />
	
	<div class="manage-layout manage-layout-shim">
		<c:if test="${! empty form_['documId'] and form_['documId'] gt 0}">
			<portlet:resourceURL var="getDocum">
				<portlet:param name="action" value="getDocum"/>
				<portlet:param name="documId" value="${form_['documId']}"/>
			</portlet:resourceURL>
			
			<div class="poa-docum manage-layout" >
				<a href="${getDocum}" target="_blank" ><i class="icon-download" >&nbsp; ${form_['documName']}</i></a>
			</div>
		</c:if>
	</div>
	
	

<div class="yui3-skin-sam">
    <div id="modalSelectCg"></div>
</div>

	 <div id="search_vcg">
	 	<c:set var="ssnType" value="text" />
	 	<c:set var="person" value="${defaultUser}" />
	 	<c:set var="ndx" value="srch" />
		<%@include file="/jsp/internal/person.jsp" %>
		<!-- 
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
			<aui:input label="address" name="address_${person.userId}" type="text" size="25"  />
		</aui:field-wrapper>
		-->
	   	<br class="clear-both" />
	   	<div class="submit-vcg-search">
			<button id="searchVcg" class="btn btn-primary" type="button" >Search</button>
		</div>
	   	
	   	<div id="cgSearchResults"></div>
	</div>
   	
	<div class="caret-submit-form">
		<a href="<portlet:actionURL/>" id="cancelSearch" class="btn btn-primary" >
				<liferay-ui:message key="cancel" />
		</a>
		<a href="javascript:" id="dispoForm" class="btn btn-primary" >
			<liferay-ui:message key="submit" />
		</a>
		
	</div>

<div class="clear-both my-shim"></div>


</div>

<div class="yui3-skin-sam">
	<div id="modalDispo"></div>
</div>


<aui:script use="aui-modal">



var modalVcg = new A.Modal({
	headerContent: "<h4><liferay-ui:message key='search-verified-identity' /></h4>",
    bodyContent: A.one("#search_vcg"),
    centered: true,
    destroyOnHide: false,
    modal: true,
    render: '#modalSelectCg',
    resizable: {
      handles: 'b, r'
    },
    visible: false,
    width: 870
});
A.one('#searchVcg').on('click',
	      function( event ) {
			window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="searchVcg" /></portlet:resourceURL>', 'json', 
					{ mviInclusion : 'true',
				firstName: A.one('#<portlet:namespace/>srch_firstName' ).val(),
				lastName: A.one('#<portlet:namespace/>srch_lastName').val(),
			  		ssn:   A.one('#<portlet:namespace/>srch_ssn').val(),
			  		birthdate: A.one('#<portlet:namespace/>srch_ssn').val(), 
			  		gender: A.one('#<portlet:namespace/>srch_gender' ).val() 
					},
					function( data ){
					  if ( data.size > 0 ){
						  var anode = A.one ( '#cgSearchResults' );
						  anode.html('');
						  var insertHtml = '<hr/>';
						  var start = "<div class='veteran-name' onclick='useVcg(this);' json='";
						  var end = "' ><i class='cg-entry' >";
						  for ( var i = 0; i < data.vcgs.length; i++ ){
							  var person = data.vcgs[i];
							  var stringify = JSON.stringify(person);
						       insertHtml = insertHtml + start + stringify + end + person.fullName + '</i><i class="cg-entry" >';
						       insertHtml = insertHtml + 
						       (person.ssn ? person.ssn : '') + '</i><i class="cg-entry" >' + 
						       (person.bdayStr? person.bdayStr  : '') + '</i><i class="cg-entry" >' + 
						       (person.address? person.address  : '') + '</i><i class="cg-entry">' + 
						       (person.city ? person.city : '') + ', ' + 
						       (person.state ? person.state : '') + ' ' + 
						       (person.zip ? person.zip : '') + '</i><i class="cg-entry">' +  
						       (person.phone ? person.phone : '') + ' ' +  
						       (person.phone2 ? person.phone2 : '') + '</i><i class="cg-entry">' + 
						       (person.email ? person.email: '') + ' ' +  
						       (person.email2 ? person.email2 : '') + '</i></div><hr/>';
						       anode.html( insertHtml );
						  }
					  } else {
						  anode.html('<div id="myAlert" class="portlet-msg-alert hidden-msg" >No profiles were found.</div>');
					  }
					} 
				);	
	      }
	 );

	 
		A.all('.disp-answer .field').on(
	      'change',
	      function(e) {
	    	  A.one('#' + e.currentTarget.getDOM().name ).val( e.currentTarget.getDOM().value );
	      });
		
		A.all('.assess-answer .field').on(
	      'change',
	      function(e) {
	    	  A.one('#' + e.currentTarget.getDOM().name ).val( e.currentTarget.getDOM().value );
	     });
	      
	 
		A.all('.search-vcg-action').on(
	      'click',
	      function(e) {	
	        	A.one ( '#cgSearchResults' ).html('');
		        A.one ('#<portlet:namespace/>placeHolder').val( e.currentTarget.attr('id') );
	        	A.one('#<portlet:namespace/>srch_lastName' ).val('');
				A.one('#<portlet:namespace/>srch_firstName' ).val('');
				A.one('#<portlet:namespace/>srch_middleName' ).val('');
				A.one('#<portlet:namespace/>srch_ssn').val('');
				A.one('#<portlet:namespace/>srch_birthDate' ).val('');
				A.one('#<portlet:namespace/>srch_gender' ).val('');
				modalVcg.render();
	        	modalVcg.show();
	      }
	    );
		
		window.useVcg = function( src ) {
			
		    var someVal = A.one ('#<portlet:namespace/>placeHolder').val();
		    var anode = A.one ( '#search_' + someVal ); 
		    anode.html( src.innerHTML );
		    var jsonObj = JSON.parse( src.getAttribute('json') );
		    A.one( "#<portlet:namespace/>use_" + someVal ).val( jsonObj.primaryKey );
			modalVcg.hide();
		}

	    window.removeUser = function (e, someVal){
			e.previousSibling.remove();
			e.remove();
			A.one( "#<portlet:namespace/>use_" + someVal.id ).val("");
		};
		
		var assessmentCount = ${form_['assessments'].size()};
		
		A.one('#<portlet:namespace/>scheduleAssessment').on(
			      'click',
	      	function( ) {
	    		var newAssessments = 1 + Number( A.one('#<portlet:namespace/>newAssessments').val() );
	    		var nextAssessment = A.one('#<portlet:namespace/>assessmentNext'+ newAssessments );
	    		if ( nextAssessment.hasClass('hidden-element') ){
		    		nextAssessment.removeClass('hidden-element');
	    		} else {
	    			return false;
	    		}
	    		A.one('#<portlet:namespace/>newAssessments').val( newAssessments );
	    		nextAssessment.addClass('active-element');
	     	}
	    );
		
		var validateScheduled = function (){
			var validates = true;
			A.all('.active-element .scheduled-date').each( function (elem) {
				var id = document.getElementById( elem.attr('id') );
				//console.log ( "id=" + id);
				if ( elem.val() == '' ){
					validates = false;
				}
			});
			return validates;
		} 
		
		A.one('#dispoForm').on(
			      'click',
			      function( ) {
			    	  modalDispose.render();
				  		modalDispose.show();
			      }
			    );
	//-------------
	
	 
	var modalDispose = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="accept-reject-disposition" /></h4>',
        bodyContent: A.one("#signDisposition"),
        centered: true,
        destroyOnHide: false,
        modal: true,
        render: '#modalDispo', 
        resizable: {
          handles: 'b, r'
        },
        visible: false,
        width: 650
    });

	modalDispose.addToolbar([
	        {
	          label: 'Cancel',
	          on: {
	            click: function() {
	            	modalDispose.hide();
	            }
	          }
	        },{
	          label: 'Submit',
	          on: {
	            click: function() {
	            	if ( validateScheduled() ){
	            		modalDispose.hide();
	            			A.one('#<portlet:namespace/>worIm_comment').val(A.one('#<portlet:namespace/>worIm_comment0').val());
				    	  document.forms['createVcg'].submit();
			    		}	
	            }
	          }
	        }
	   ]);
	
	//-------------
	A.all('.assess-completed-action').on(
			      'click',
			      function( id ) {
			    	  A.one ('#<portlet:namespace/>placeHolder').val( e.currentTarget.attr('id') );
			    	  modalAssess.render();
			    	  modalAssess.show();
			      }
			    );
	
	var modalAssess = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="complete-assessment" /></h4>',
        bodyContent: A.one("#signAssessment"),
        centered: true,
        destroyOnHide: false,
        modal: true,
        render: '#modalAssess', 
        resizable: {
          handles: 'b, r'
        },
        visible: false,
        width: 650
    });

	modalAssess.addToolbar([
	        {
	          label: 'Cancel',
	          on: {
	            click: function() {
	            	modalAssess.hide();
	            }
	          }
	        },{
	          label: 'Update',
	          on: {
	            click: function() {
	            	if ( validateScheduled() ){
	            		modalAssess.hide();
	            		var ndx = A.one ('#<portlet:namespace/>placeHolder');
	            	}	
	            }
	          }
	        }
	   ]);
	 
</aui:script>


<%@include file="/jsp/version.jsp" %>