<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>


<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<div class="yui3-skin-sam">
    <div id="modal0"></div>
</div>

<%@include file="/jsp/internal/menu.jsp" %>  

<%@include file="/jsp/internal/actionsSupport.jsp" %>  


<div id="mainTab">
  <ul class="nav nav-tabs">
    <li class="active"><a href="#tab-1">${role} Dashboard</a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-1" class="tab-pane">
      	<div class="dashboard-top">
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse1">
			      	<legend class="header toggler-header-expand"><liferay-ui:message key="search" /></legend>
			      		
			      		<div class="content toggler-content-expand" >
			      			
			      			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
								<aui:select label="search-context" name="form_searchContext" id="searchContext" cssClass="srch-caret search-category"  >
									<aui:option value="" label="select-context" />
									<c:forEach var="searchFor" items="${searches}">
										<aui:option value="${searchFor}" label="${searchFor}" />
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
								<aui:select disabled="${isDisabled}" label="facility" cssClass="srch-caret" name="form_userOrgIds" id="userOrgIds" >
									<aui:option value="0" label="select-facility" selected="true" />
									<c:forEach var="district" items="${caretMap_['vhaSystem']}">
										<aui:option value="${district.key}" label="${district.key}" cssClass="district" disabled="true" />
										<c:forEach var="visn" items="${district.value}">
											<aui:option value="${visn.key}" label="${visn.key}" cssClass="visn" disabled="true" />
											<c:forEach var="facility" items="${visn.value}">
												<aui:option value="${facility.value}" label="${facility.key}" cssClass="facility" />
											</c:forEach>
										</c:forEach>
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
			      			
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
								<aui:select label="search-role" name="form_roleId" id="roleId" cssClass="srch-caret role-dashboard"  >
									<aui:option value="0" label="select-role" />
									<c:forEach var="searchFor" items="${CARET_ROLES}">
										<aui:option value="${searchFor.value}" label="${searchFor.key}"   />
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
								<aui:select label="user-name" name="form_userName" id="impersonateId" cssClass="srch-caret search-category"  >
									<aui:option value="" label="select-user" />
								</aui:select>
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
								<aui:input label="context-id" cssClass="number-field srch-caret" name="form_primaryKey" type="text" size="25" value="${search.primaryKey}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout"  >
								<aui:input label="first-name" name="form_firstName" type="text" size="25" cssClass="srch-caret" id="firstName" value="${search.firstName}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout"  >
								<aui:input label="last-name" name="form_lastName" type="text" size="25" cssClass="srch-caret" id="lastName" value="${search.lastName}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout"  >
								<aui:input label="ssn" name="form_ssn" type="text" size="25" cssClass="srch-caret ssn-field" id="ssn" value="${search.ssn}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout"  >
								<aui:input label="dob" name="form_birthDate" type="text" size="25" cssClass="srch-caret date-field" id="birthDate" value="${search.birthDate}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
								<aui:input label="phone" cssClass="phone-field srch-caret"  name="form_phone" type="text" size="25" value="${search.phone}" />
							</aui:field-wrapper>
							
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
								<aui:input label="zip" cssClass="zip-field srch-caret" name="form_zip" type="text" size="25" value="${search.zip}" />
							</aui:field-wrapper>
							
								
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout">
								<aui:select label="user-mode" name="form_impersonationMode" id="impersonationMode" cssClass="srch-caret search-category"  >
									<aui:option value="" label="standard-view-edit" />
									<aui:option value="IMPERSONATE" label="impersonate-selected-userName" />
								</aui:select>
							</aui:field-wrapper>
							
							
							<div class="clear-both">
								<a href="<portlet:actionURL/>" class="btn btn-primary" >
									<liferay-ui:message key="clear" />
								</a>
								<a href="javascript:" id="<portlet:namespace/>searchPerson" class="btn btn-primary" >
									<liferay-ui:message key="search" />
								</a>
							</div>
							
							<div id="searchContextPane"></div>
							
							
						</div>
						
				</fieldset>
      		
      		</div>
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse2">
		      		<legend class="header toggler-header-expand">Notifications</legend>
		      		<div class="content toggler-content-expand" >
	      				<%@include file="/jsp/internal/myMessages.jsp" %>
	      			</div>
      			</fieldset>
      		</div>
      	</div>
    </div>

  </div>
</div>


<aui:script use="aui-tabview,aui-toggler">
	A.all('.role-dashboard').on( 
		      'change',
		      function( event ) {
		    	  	var eventId = event.currentTarget.attr('id');
		    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="getRoleUsers" /></portlet:resourceURL>', 'json', 
							{ roleId: A.one('#'+ eventId).val() },
							function( data ){
						    	 var usersNode = A.one ( '#<portlet:namespace/>impersonateId');
						    	 var options = "<option>Select Found Users</option>";
								if ( data.size > 0 ){
							    	 for ( var i = 0; i < data.size; i++  ){
							    		 options = options + '<option value="' + data.users[i].userId + '">'+ data.users[i].fullName + '</option>';
							    	 }
								}
						    	 usersNode.html( options );
							} 
					);
		     }
		 );


	A.one('#<portlet:namespace/>impersonationMode').on ( 'change', function (e) {
		 window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="impersonate" /></portlet:resourceURL>', 'json', 
				  { 
			 		impersonationMode: e.currentTarget.val(),
			 		userId: A.one('#<portlet:namespace/>impersonateId').val(),
			 		roleId: A.one('#<portlet:namespace/>roleId').val()
			 	  },
				  function( data ){
			 		  	if ( data.form_ == true || data.form_ == 'true'  ){
			 		  		//console.log( 'saved' );
			 		  	} else {
							alert( 'Could not set impersonationMode' );
			 		  	}
					} 
				);
	} );  
	  
	  
	  
	  
for ( i = 1 ; i < 3; i++ ){
    new A.TogglerDelegate(
      {
        animated: true,
        closeAllOnExpand: true,
        container: '#sectionCollapse' + i ,
        content: '.content',
        expanded: true,
        header: '.header',
        transition: {
          duration: 0.2,
          easing: 'cubic-bezier(0, 0.1, 0, 1)'
        }
      }
    );
}

new A.TabView({
    srcNode: '#mainTab',
    type: 'pills'
  }
).render();

    A.all('.submitForm').on(
      'click',
      function(e) {	
//       		A.one ('#<portlet:namespace/>action').val( e.currentTarget.attr('id') );
       		document.forms["approvePaymentMonth"].submit();
      }
    );

    A.one('#<portlet:namespace/>searchPerson').on(
    		'click',
    	function ( e ){
    			var page = A.one('#<portlet:namespace/>searchContext').val();
				if ( page == "" ) {
					return false;
				}
      			var node = A.one( "#searchContextPane" );
	
      			window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="fromParameter" value="true"/></portlet:resourceURL>', 'html', 
      				{ 	page: page,
	      				roleId: A.one('#<portlet:namespace/>roleId').val(),
	      				userOrgIds: A.one('#<portlet:namespace/>userOrgIds').val(),
	      				userId: A.one('#<portlet:namespace/>impersonateId').val(),
	      				firstName: A.one('#<portlet:namespace/>firstName').val(),
	      				lastName: A.one('#<portlet:namespace/>lastName').val(),
	      				birthDate: A.one('#<portlet:namespace/>birthDate').val(),
	      				ssn: A.one('#<portlet:namespace/>ssn').val()
	      			},
      				function( data ){
      					overwrite( node, data);
      				} 
      			);
    		}		
    );
    /*
    var overwrite = function( node, data ){
    	node.plug( A.Plugin.ParseContent );
		node.setContent( data );
		node.all('.dropdown-menu a, .lfr-pagination-buttons a, .table-sort-liner a').on('click', function(e){
			e.preventDefault();
			var href = e.currentTarget.attr('href');
			window.caretIo( href, 'html', {}, function( data ){ overwrite( node, data); });
			return false;
		});
    }
    */
  
</aui:script>

