<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>

<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<div class="yui3-skin-sam">
    <div id="modal0"></div>
</div>

     
<%@include file="/jsp/internal/menu.jsp" %>  


<div id="mainTab">
  <ul class="nav nav-tabs">
    <li class="active"><a href="#tab-1">${role} Dashboard</a></li>
    <li id="vcgs"><a href="#tab-2">Search</a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-1" class="tab-pane">
      	<div class="dashboard-top">
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse1">
      			
		      		<legend class="header toggler-header-expanded">My Work</legend>
			      	<div class="content toggler-content-expanded" >
			    		<div id="myTab">  	
							<ul class="nav nav-tabs">
						    	<li class="active"><a href="#myCalls">My Calls</a></li>
						    	<li id="myReferrals"><a href="#myReferrals">My Referrals</a></li>
						  	</ul>
							<div class="tab-content">
	    						<div id="myCalls" class="tab-pane window-overwrite">
									<%@include file="/jsp/internal/myCalls.jsp" %>
								</div>
								<div id="myReferrals" class="tab-pane window-overwrite">
									<%@include file="/jsp/internal/myReferrals.jsp" %>
								</div>
							</div>
						</div>
					</div>
				
				
				</fieldset>
      		</div>
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse2">
		      		<legend class="header toggler-header-expanded">Notifications</legend>
		      		<div class="content toggler-content-expanded window-overwrite" >
	      				<%@include file="/jsp/internal/myMessages.jsp" %>
	      			</div>
      			</fieldset>
      		</div>
      	</div>
		  
		  	<fieldset  id="sectionCollapse3" class="clear-both">
		  	
				<legend class="header toggler-header-expanded">Group Work</legend>
				<div class="content toggler-content-expanded" >
			  		<div id="groupTab">  	
						<ul class="nav nav-tabs">
				  			<li ><a href="#groupCalls">Calls</a></li>
					    	<li ><a href="#groupReferrals">Referrals</a></li>
					    	<li ><a href="#groupSocs">SOCs</a></li>
					  	</ul>
						<div class="tab-content">
	    					<div id="groupCalls" class="window-overwrite tab-pane"></div>
				  			<div id="groupReferrals" class="window-overwrite tab-pane"></div>
				  			<div id="groupSocs" class="window-overwrite tab-pane"></div>
						</div>
					</div>
				</div>
			</fieldset>
		
    </div>

    <div id="tab-2" class="tab-pane">
		<%@include file="/jsp/internal/filter.jsp" %>
	</div>
    
  </div>

</div>


<aui:script use="aui-tabview,aui-modal,aui-dropdown,aui-toggler,node-event-simulate">
	
	for ( i = 1 ; i < 4; i++ ){
	    new A.TogglerDelegate(
	      {
	        animated: true,
	        closeAllOnExpand: true,
	        container: '#sectionCollapse' + i ,
	        content: '.content',
	        expanded: (i < 3),
	        header: '.header',
	        transition: {
	          duration: 0.2,
	          easing: 'cubic-bezier(0, 0.1, 0, 1)'
	        }
	      }
	    );
	}

  new A.TabView({
      srcNode: '#mainTab',
      type: 'pills'
    }
  ).render();
  
  
  var loadPage = function (e){
    var href = e.currentTarget.getActiveTab().one('a').attr('href')
 	var page = href.substring(href.indexOf('#'));
	var node = A.one( page );
	if (node.hasClass('loaded-pane')){
		return false;
	}

	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /></portlet:resourceURL>', 'html', 
		{ page: page },
		function( data ){
			overwrite( node, data );
		} 
	);
  }
  
  
  new A.TabView({
      srcNode: '#myTab',
      type: 'pills'
    }
  ).render();
  new A.TabView({
      srcNode: '#groupTab',
      type: 'pills',
      on: {
          click: function(e) {
          	loadPage(e);
          }
        }
    }
  ).render();
  
  A.on('domready', function( event ) {
	   	try {
	   		A.one('#groupCalls').simulate('click');
	   	} catch (e){}
	   });
  
</aui:script>

