<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>


<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<div class="yui3-skin-sam">
    <div id="modal0"></div>
</div>

<div class="yui3-skin-sam">
    <div id="modal1"></div>
</div>

<div class="yui3-skin-sam">
    <div id="modal2"></div>
</div>

<div class="yui3-skin-sam">
    <div id="modal3"></div>
</div>

<div class="yui3-skin-sam">
    <div id="modal4"></div>
</div>

<portlet:actionURL var="approvePaymentMonth">
	<portlet:param name="<%=ActionRequest.ACTION_NAME%>" value="doAction"/>
	<portlet:param name="action" value="approvePaymentMonth"/>
</portlet:actionURL>

<div id="mainTab">
  <ul class="nav nav-tabs">
    <li class="active"><a href="#tab-1">${role} Dashboard</a></li>
    
    <li id="payments"><a href="#tab-2">Payments</a></li>
    <li id="blsRates"><a href="#tab-3">BLS Rates</a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-1" class="tab-pane">
      	<div class="dashboard-top">
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse1">
			      	<legend>Approve Monthly Payment</legend>

					<form name="approvePaymentMonth" method="post" action="${approvePaymentMonth}" >
			      	<div>
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"   >
							<aui:select disabled="${isDisabled}" label="" name="year" id="year" >
								<aui:option value="" label="Select Year" />
								<aui:option value="2015" label="2015" />
								<aui:option value="2016" label="2016" />
							</aui:select>
						</aui:field-wrapper>
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"   >
							<aui:select disabled="${isDisabled}" label="" name="month" id="month" >
								<aui:option value="" label="Select Month" />
								<aui:option value="0" label="January" />
								<aui:option value="1" label="February" />
								<aui:option value="2" label="March" />
								<aui:option value="3" label="April" />
								<aui:option value="4" label="May" />
								<aui:option value="5" label="June" />
								<aui:option value="6" label="July" />
								<aui:option value="7" label="August" />
								<aui:option value="8" label="September" />
								<aui:option value="9" label="October" />
								<aui:option value="10" label="November" />
								<aui:option value="11" label="December" />
							</aui:select>
						</aui:field-wrapper>
						<div class="caret-submit-form">
							<button id="submitForm" class="btn btn-primary" type="button" onclick="document.forms['createVcg'].submit();" >Submit</button>
						</div>
						
						<c:if test="${! empty monthYear}">
							<div class="portlet-msg-success dashboard-success" >
								Request submitted for ${monthYear}
							</div>
						</c:if>
					</div>
					
					
					
					</form>
				</fieldset>
      		</div>
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse">
		      		<legend class="header toggler-header-collapsed">Messaging</legend>
		      		<div class="content toggler-content-collapsed" >
	      				<%@include file="/jsp/internal/myMessages.jsp" %>
	      			</div>
      			</fieldset>
      		</div>
      	</div>
      	
		  
		  
					
		
    </div>

    <div id="tab-2" class="tab-pane">
    	<%@include file="/jsp/internal/stipends.jsp" %>
	</div>
    
    <div id="tab-3" class="tab-pane">
    	<%@include file="/jsp/internal/blsRates.jsp" %>
    </div>
    
    
  </div>

</div>


<aui:script use="aui-tabview,aui-toggler">

		new A.TogglerDelegate(
	      {
	        animated: true,
	        container: '#sectionCollapse',
	        content: '.content',
	        expanded: true,
	        header: '.header',
	        transition: {
	          duration: 0.2,
	          easing: 'cubic-bezier(0, 0.1, 0, 1)'
	        }
	      }
	    );
	    
    A.one('#submitForm').on(
      'click',
      function(e) {	
//       		A.one ('#<portlet:namespace/>action').val( e.currentTarget.attr('id') );
       		document.forms["approvePaymentMonth"].submit();
      }
    );
    
    

  window.careTmainTab = new A.TabView({
      srcNode: '#mainTab',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
  
  
  A.one('#<portlet:namespace/>month').on(
	      'change',
	      function( event ) {
				A.io.request( '<portlet:resourceURL><portlet:param name="action" value="getMonthSum" /></portlet:resourceURL>',
						  {
					  method: 'POST',
					  dataType: 'json',
					  data: {
						  month: A.one('#<portlet:namespace/>month').val(),
						  year: A.one('#<portlet:namespace/>year').val()
					  },
			  			on: {
							  success: function() {
									  var data = this.get('responseData');
									  
									  if ( data.paymentAmount ){
										 var sumNode = A.one ('#<portlet:namespace/>monthSum');
								    	 var options = "<div>"+ data.paymentAmount +"</div>";
								    	 sumNode.html( options );
									  }
									}
						  		},
					      	}
					    );
	      }
	 );
  
</aui:script>


