package gov.va.caret.view;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.service.CaretLocalServiceUtil;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;


public class GenericReport implements Comparable<GenericReport>, Serializable {
	
	private static final long serialVersionUID = 1L;
	
	public static final String MY_APPLICATIONS = "myApplications";

	public static final String MY_MESSAGES = "myMessages";

	public static final String MY_VCG_STATUS = "myVcgStatus";

	public static final String MY_STIPENDS = "myStipends";

	
	private String name;
	private ReportParameter[] parameter = new ReportParameter[0];
	private String filtered = StringPool.BLANK;
	private boolean lazy = false;
	private String orderBy;
	private boolean desc;
	
	public GenericReport(String reportName) {
		super();
		this.name = reportName;
	}
	
	public GenericReport(String reportName, boolean lazy) {
		super();
		this.name = reportName;
		this.lazy = lazy;
	}
	
	public GenericReport(String reportName,
			ReportParameter... parameters ) {
		super();
		this.name = reportName;
		this.parameter = parameters;
	}
	
	public GenericReport(String reportName, boolean lazy, 
			String orderBy, boolean desc ) {
		super();
		if ( orderBy != null && !orderBy.isEmpty() ){
			this.orderBy = orderBy.split(",")[0];
		}
		this.desc = desc;
		this.name = reportName;
	}

	
	public GenericReport(String reportName, boolean lazy, 
			String orderBy, boolean desc,
			ReportParameter... parameters ) {
		super();
		if ( orderBy != null && !orderBy.isEmpty() ){
			this.orderBy = orderBy.split(",")[0];
		}
		this.desc = desc;
		this.name = reportName;
		this.parameter = parameters;
	}

	public String getName() {
		return name;
	}
	
	public String getOrderBy() {
		return orderBy;
	}
	
	public boolean isDesc() {
		return desc;
	}
	
	public void setOrderBy( String orderBy ) {
		this.orderBy = orderBy;
	}
	
	public void setDesc( boolean desc ) {
		this.desc = desc;
	}

	public ReportParameter[] getParameterNames() {
		return parameter;
	}
	
	public boolean isLazy(){
		return lazy;
	}
	
	public String getFiltered(){
		return filtered;
	}
	
	public void setFiltered( String filtered ){
		this.filtered = StringPool.FALSE.equals( filtered )? StringPool.BLANK : filtered;
	}

	public String toString(){
		return name;
	}

	public boolean equals(Object o) {
		return o == null? false: o.toString().equals( toString() );
	}

	@Override
	public int compareTo(GenericReport o) {
		return name.compareTo(o.name);
	}
	
	public void run ( PortletRequest request, boolean loadFromParams ){
		run(request, loadFromParams, 0, 0);
	}
	
	public void run ( PortletRequest request, boolean loadFromParams, int start, int end ){
		try {
			ReportParameter[] val = getParameterNames();
			
			Object parameters = null;
			if ( val != null && val.length == 1){
				if ( loadFromParams ){
					parameters = ParamUtil.getLong(request, getParameterNames()[0].name() );
				} else {
					parameters = CaretParam.getParameter( request, getParameterNames() );
				}
			} else {
				Map entries = new HashMap<String,Object>();
				String parameter = null;
				for ( ReportParameter name : getParameterNames() ){
					switch(name){
					case queId: 
						if ( loadFromParams ){
							entries.put( name.name(), ParamUtil.getLong(request, "userOrgIds" ) );
						} else {
							entries.put( name.name(), CaretParam.getUserOrgParameter( request, name ) );
						}
						break;
					case userId:
					case roleId:
					case socDueDate:
					case userOrgIds:
						if ( loadFromParams ){
							entries.put( name.name(), ParamUtil.getLong(request, parameter == null? name.name(): parameter ) );
						} else {
							entries.put( name.name(), CaretParam.getUserOrgParameter( request, name ) );
						}
						break;
					}
				}
				parameters = entries;
			}
			String orderByCol = request.getParameter("orderByCol");
			String _orderByCol = getOrderBy();
			
			String byType = request.getParameter("orderByType");
//			_log.info("request orderByType=" + byType );

			Boolean isDesc;
			if ( orderByCol == null || orderByCol.isEmpty() ){
				orderByCol = _orderByCol;
//				isDesc = "desc".equals(byType);
			} else {
				setOrderBy( orderByCol );
				if ( orderByCol.equals( _orderByCol ) ){
					setDesc( "desc".equals(byType) );
				}
			}
			isDesc = isDesc();
//			request.setAttribute(CaretStrPool.TYPE, isDesc? "desc": "asc" );
			
			String type = request.getParameter("type");
			if ( type != null && !type.isEmpty() ){
				setFiltered(type);
			}
			
			if ( !getFiltered().isEmpty() ){
				if ( getFiltered().equals( type ) ){
					_log.info("report.getFiltered().equals( type ) -" + type );
				}
				type = getFiltered();
				if ( parameters instanceof Map ){
					((Map)parameters).put("FILTERED", " and type_ = '" + type + StringPool.APOSTROPHE );
				}
				
			}
			
			List<Map<String, Object>> list = CaretLocalServiceUtil.getReport( 
					getName(), parameters, orderByCol, isDesc, start, end);
			
			
			ResultMap.getResultListMap( request ).put( getName(), list );
			ResultMap.getResultTotalMap( request ).put( getName(), 
								CaretLocalServiceUtil.getReportCount( getName(), parameters) );

			ResultMap.getResultOrderDeltaMap( request ).put(getName(), end == 0 ? SearchContainer.DEFAULT_DELTA : start-end );
			ResultMap.getResultOrderColumnMap( request ).put( getName(), orderByCol );
			ResultMap.getResultOrderTypeMap( request ).put( getName(), isDesc? "desc": "asc" );
			ResultMap.getResultFilteredMap( request ).put( getName(), getFiltered() );
			
//			public static Map<String,Boolean> getResultOrderTypeMap ( PortletRequest request ) {
//				return getBooleanMap(request, TYPE, true);
//			}
			
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
	}
	
//	private Boolean isFiltered() {
//		return StringPool.BLANK.equals( filtered );
//	}

	private static Log _log = LogFactoryUtil.getLog( GenericReport.class );
}
