package gov.va.caret.view;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class EnabledSearch implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8527995332377299554L;
	private Map<String,GenericReport> cachedReports;

	public static final EnabledSearch ALL_ENABLED = new EnabledSearch();
	
	public EnabledSearch(CachedReport... cachedReports) {
		super();
		this.cachedReports = new HashMap<String,GenericReport>();
		for ( GenericReport cachedReport : cachedReports) {
			this.cachedReports.put( cachedReport.getName(), cachedReport );
		}
	}
	
	public EnabledSearch( Collection<? extends GenericReport> cachedReports) {
		super();
		this.cachedReports = new TreeMap<String,GenericReport>();
		for ( GenericReport cachedReport : cachedReports) {
			this.cachedReports.put( cachedReport.getName(), cachedReport );
		}
	}

	public Collection<GenericReport> getCachedReports() {
		return cachedReports.values();
	}	

	public Set<String> getKeywords() {
		return cachedReports.keySet();
	}
	
}
